/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.platform.PlatformBuilder;
import cn.xfyun.base.http.platform.PlatformHttpClient;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.llmocr.LLMOcrParam;
import cn.xfyun.model.sign.Signature;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LLMOcrClient
extends PlatformHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(LLMOcrClient.class);
    private final String imei;
    private final String imsi;
    private final String mac;
    private final String netType;
    private final String netIsp;
    private final String resId;
    private final String resultOption;
    private final String resultFormat;
    private final String outputType;
    private final String exifOption;
    private final String jsonElementOption;
    private final String markdownElementOption;
    private final String sedElementOption;
    private final String alphaOption;
    private final Float rotationMinAngle;

    public String getImei() {
        return this.imei;
    }

    public String getImsi() {
        return this.imsi;
    }

    public String getMac() {
        return this.mac;
    }

    public String getNetType() {
        return this.netType;
    }

    public String getNetIsp() {
        return this.netIsp;
    }

    public String getResultOption() {
        return this.resultOption;
    }

    public String getResultFormat() {
        return this.resultFormat;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public String getExifOption() {
        return this.exifOption;
    }

    public String getAlphaOption() {
        return this.alphaOption;
    }

    public Float getRotationMinAngle() {
        return this.rotationMinAngle;
    }

    public String getResId() {
        return this.resId;
    }

    public String getMarkdownElementOption() {
        return this.markdownElementOption;
    }

    public String getSedElementOption() {
        return this.sedElementOption;
    }

    public String getJsonElementOption() {
        return this.jsonElementOption;
    }

    public LLMOcrClient(Builder builder) {
        super((PlatformBuilder)builder);
        this.imei = builder.imei;
        this.imsi = builder.imsi;
        this.mac = builder.mac;
        this.netType = builder.netType;
        this.netIsp = builder.netIsp;
        this.resultOption = builder.resultOption;
        this.resultFormat = builder.resultFormat;
        this.outputType = builder.outputType;
        this.exifOption = builder.exifOption;
        this.alphaOption = builder.alphaOption;
        this.rotationMinAngle = builder.rotationMinAngle;
        this.resId = builder.resId;
        this.markdownElementOption = builder.markdownElementOption;
        this.sedElementOption = builder.sedElementOption;
        this.jsonElementOption = builder.jsonElementOption;
    }

    public String send(LLMOcrParam param) throws IOException {
        String body = this.bodyParam(param);
        String signUrl = Signature.signHostDateAuthorization((String)this.hostUrl, (String)"POST", (String)this.apiKey, (String)this.apiSecret);
        return this.sendPost(signUrl, JSON, body);
    }

    private void paramCheck(LLMOcrParam param) {
        if (null == param) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        param.selfCheck();
    }

    private String bodyParam(LLMOcrParam param) {
        this.paramCheck(param);
        JsonObject body = new JsonObject();
        body.add("header", (JsonElement)this.getHeader(param));
        body.add("parameter", (JsonElement)this.getParameter());
        body.add("payload", (JsonElement)this.getPayload(param));
        logger.debug("\u901a\u7528\u5927\u6a21\u578b\u6587\u6863\u8fd8\u539f\u8bf7\u6c42\u5165\u53c2: {}", (Object)body);
        return StringUtils.gson.toJson((JsonElement)body);
    }

    private JsonObject getHeader(LLMOcrParam param) {
        JsonObject header = this.buildHeader();
        header.addProperty("uid", param.getUid());
        header.addProperty("did", param.getDid());
        header.addProperty("imei", this.imei);
        header.addProperty("imsi", this.imsi);
        header.addProperty("mac", this.mac);
        header.addProperty("net_type", this.netType);
        header.addProperty("net_isp", this.netIsp);
        header.addProperty("request_id", param.getRequestId());
        header.addProperty("res_id", this.resId);
        return header;
    }

    private JsonObject getParameter() {
        JsonObject parameter = new JsonObject();
        JsonObject ocr = new JsonObject();
        ocr.addProperty("result_option", this.resultOption);
        ocr.addProperty("result_format", this.resultFormat);
        ocr.addProperty("output_type", this.outputType);
        ocr.addProperty("exif_option", this.exifOption);
        ocr.addProperty("json_element_option", this.jsonElementOption);
        ocr.addProperty("markdown_element_option", this.markdownElementOption);
        ocr.addProperty("sed_element_option", this.sedElementOption);
        ocr.addProperty("alpha_option", this.alphaOption);
        ocr.addProperty("rotation_min_angle", (Number)this.rotationMinAngle);
        ocr.add("result", (JsonElement)this.buildResult());
        parameter.add("ocr", (JsonElement)ocr);
        return parameter;
    }

    private JsonObject getPayload(LLMOcrParam param) {
        JsonObject payload = new JsonObject();
        JsonObject image = new JsonObject();
        image.addProperty("encoding", param.getFormat());
        image.addProperty("image", param.getImageBase64());
        image.addProperty("status", (Number)this.status);
        image.addProperty("seq", (Number)0);
        payload.add("image", (JsonElement)image);
        return payload;
    }

    public static final class Builder
    extends PlatformBuilder<Builder> {
        private static final String HOST_URL = "https://cbm01.cn-huabei-1.xf-yun.com/v1/private/se75ocrbm";
        private static final String SERVICE_ID = "se75ocrbm";
        private String imei;
        private String imsi;
        private String mac;
        private String netType;
        private String netIsp;
        private String resId;
        private String resultOption;
        private String resultFormat;
        private String outputType;
        private String exifOption;
        private String jsonElementOption;
        private String markdownElementOption;
        private String sedElementOption;
        private String alphaOption;
        private Float rotationMinAngle;

        public Builder(String appId, String apiKey, String apiSecret) {
            super(HOST_URL, SERVICE_ID, appId, apiKey, apiSecret);
            this.status(2);
        }

        public LLMOcrClient build() {
            return new LLMOcrClient(this);
        }

        public Builder imei(String imei) {
            this.imei = imei;
            return this;
        }

        public Builder imsi(String imsi) {
            this.imsi = imsi;
            return this;
        }

        public Builder mac(String mac) {
            this.mac = mac;
            return this;
        }

        public Builder netType(String netType) {
            this.netType = netType;
            return this;
        }

        public Builder netIsp(String netIsp) {
            this.netIsp = netIsp;
            return this;
        }

        public Builder resId(String resId) {
            this.resId = resId;
            return this;
        }

        public Builder resultOption(String resultOption) {
            this.resultOption = resultOption;
            return this;
        }

        public Builder resultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
            return this;
        }

        public Builder outputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        public Builder exifOption(String exifOption) {
            this.exifOption = exifOption;
            return this;
        }

        public Builder jsonElementOption(String jsonElementOption) {
            this.jsonElementOption = jsonElementOption;
            return this;
        }

        public Builder markdownElementOption(String markdownElementOption) {
            this.markdownElementOption = markdownElementOption;
            return this;
        }

        public Builder sedElementOption(String sedElementOption) {
            this.sedElementOption = sedElementOption;
            return this;
        }

        public Builder alphaOption(String alphaOption) {
            this.alphaOption = alphaOption;
            return this;
        }

        public Builder rotationMinAngle(Float rotationMinAngle) {
            this.rotationMinAngle = rotationMinAngle;
            return this;
        }
    }
}

