/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.platform.PlatformBuilder;
import cn.xfyun.base.http.platform.PlatformHttpClient;
import cn.xfyun.config.JDRecgEnum;
import cn.xfyun.model.sign.Signature;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;

public class JDOcrClient
extends PlatformHttpClient {
    private JDRecgEnum jdRecgEnum;

    public JDRecgEnum getJdRecgEnum() {
        return this.jdRecgEnum;
    }

    public JDOcrClient(Builder builder) {
        super((PlatformBuilder)builder);
        this.jdRecgEnum = builder.jdRecgEnum;
    }

    public String handle(String imageBase64, String encoding) throws IOException {
        String signUrl = Signature.signHostDateAuthorization((String)(this.hostUrl + this.jdRecgEnum.getValue()), (String)"POST", (String)this.apiKey, (String)this.apiSecret);
        return this.sendPost(signUrl, JSON, null, this.bodyParam(imageBase64, encoding));
    }

    private String bodyParam(String imageBase64, String encoding) {
        JsonObject jso = new JsonObject();
        jso.add("header", (JsonElement)this.buildHeader());
        JsonObject parameter = new JsonObject();
        JsonObject service = new JsonObject();
        service.add(this.jdRecgEnum.getService(), (JsonElement)this.buildResult());
        parameter.add(this.jdRecgEnum.getParameter(), (JsonElement)service);
        jso.add("parameter", (JsonElement)parameter);
        JsonObject payload = new JsonObject();
        JsonObject inputImage1 = new JsonObject();
        inputImage1.addProperty("encoding", encoding);
        inputImage1.addProperty("image", imageBase64);
        inputImage1.addProperty("status", (Number)this.status);
        payload.add(this.jdRecgEnum.getPayload(), (JsonElement)inputImage1);
        jso.add("payload", (JsonElement)payload);
        return jso.toString();
    }

    public static final class Builder
    extends PlatformBuilder<Builder> {
        private static final String HOST_URL = "https://api.xf-yun.com/v1/private/";
        private JDRecgEnum jdRecgEnum;

        public Builder(String appId, String apiKey, String apiSecret, JDRecgEnum jdRecgEnum) {
            super(HOST_URL, jdRecgEnum.getValue(), appId, apiKey, apiSecret);
            this.jdRecgEnum = jdRecgEnum;
        }

        public Builder jdRecg(JDRecgEnum jdRecgEnum) {
            this.serviceId(jdRecgEnum.getValue());
            this.jdRecgEnum = jdRecgEnum;
            return this;
        }

        public JDOcrClient build() {
            return new JDOcrClient(this);
        }
    }
}

