/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.platform.PlatformBuilder;
import cn.xfyun.base.http.platform.PlatformHttpClient;
import cn.xfyun.config.FaceDetectEnum;
import cn.xfyun.model.sign.Signature;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;

public class FaceDetectClient
extends PlatformHttpClient {
    private FaceDetectEnum detectPoints;
    private FaceDetectEnum detectProperty;

    public FaceDetectEnum getDetectPoints() {
        return this.detectPoints;
    }

    public FaceDetectEnum getDetectProperty() {
        return this.detectProperty;
    }

    public FaceDetectClient(Builder builder) {
        super((PlatformBuilder)builder);
        this.detectPoints = builder.detectPoints;
        this.detectProperty = builder.detectProperty;
    }

    public String faceContrast(String imageBase641, String encoding) throws IOException {
        String signUrl = Signature.signHostDateAuthorization((String)this.hostUrl, (String)"POST", (String)this.apiKey, (String)this.apiSecret);
        return this.sendPost(signUrl, JSON, null, this.bodyParam(imageBase641, encoding));
    }

    private String bodyParam(String imageBase641, String imageEncoding1) {
        JsonObject jso = new JsonObject();
        jso.add("header", (JsonElement)this.buildHeader());
        JsonObject parameter = new JsonObject();
        JsonObject service = new JsonObject();
        service.addProperty("service_kind", "face_detect");
        service.addProperty("detect_points", this.detectPoints.getValue());
        service.addProperty("detect_property", this.detectProperty.getValue());
        service.add("face_detect_result", (JsonElement)this.buildResult());
        parameter.add(this.serviceId, (JsonElement)service);
        jso.add("parameter", (JsonElement)parameter);
        JsonObject payload = new JsonObject();
        JsonObject inputImage1 = new JsonObject();
        inputImage1.addProperty("encoding", imageEncoding1);
        inputImage1.addProperty("image", imageBase641);
        payload.add("input1", (JsonElement)inputImage1);
        jso.add("payload", (JsonElement)payload);
        return jso.toString();
    }

    public static final class Builder
    extends PlatformBuilder<Builder> {
        private static final String HOST_URL = "https://api.xf-yun.com/v1/private/s67c9c78c";
        private static final String SERVICE_ID = "s67c9c78c";
        private FaceDetectEnum detectPoints = FaceDetectEnum.OFF;
        private FaceDetectEnum detectProperty = FaceDetectEnum.OFF;

        public Builder(String appId, String apiKey, String apiSecret) {
            super(HOST_URL, SERVICE_ID, appId, apiKey, apiSecret);
        }

        public Builder detectPoints(FaceDetectEnum detectPoints) {
            this.detectPoints = detectPoints;
            return this;
        }

        public Builder detectProperty(FaceDetectEnum detectProperty) {
            this.detectProperty = detectProperty;
            return this;
        }

        public FaceDetectClient build() {
            FaceDetectClient client = new FaceDetectClient(this);
            return client;
        }
    }
}

