/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.util;

import cn.xfyun.util.IOCloseUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Base64;

public class FileUtil {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    public static byte[] readFileToByteArray(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("\u6587\u4ef6\u53c2\u6570\u4e0d\u80fd\u4e3anull");
        }
        if (!file.exists()) {
            throw new IOException("\u6587\u4ef6\u4e0d\u5b58\u5728: " + file);
        }
        if (!file.isFile()) {
            throw new IOException("\u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6: " + file);
        }
        if (file.length() < 81920L) {
            return FileUtil.readSmallFile(file);
        }
        return FileUtil.readLargeFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readSmallFile(File file) throws IOException {
        byte[] byArray;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byte[] buffer = new byte[(int)file.length()];
            int bytesRead = fileInputStream.read(buffer);
            if (bytesRead != buffer.length) {
                throw new IOException("\u65e0\u6cd5\u5b8c\u6574\u8bfb\u53d6\u6587\u4ef6\uff0c\u9884\u671f\u8bfb\u53d6 " + buffer.length + " \u5b57\u8282\uff0c\u5b9e\u9645\u8bfb\u53d6 " + bytesRead + " \u5b57\u8282");
            }
            byArray = buffer;
        }
        catch (Throwable throwable) {
            IOCloseUtil.close(fileInputStream);
            throw throwable;
        }
        IOCloseUtil.close(fileInputStream);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readLargeFile(File file) throws IOException {
        byte[] byArray;
        FileInputStream fileInputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            int bytesRead;
            fileInputStream = new FileInputStream(file);
            outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            IOCloseUtil.close(outputStream);
            IOCloseUtil.close(fileInputStream);
            throw throwable;
        }
        IOCloseUtil.close(outputStream);
        IOCloseUtil.close(fileInputStream);
        return byArray;
    }

    public static String fileToBase64(String filePath) throws IOException {
        return Base64.getEncoder().encodeToString(FileUtil.readFileToByteArray(new File(filePath)));
    }
}

