/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.model.sign;

import cn.xfyun.model.sign.AbstractSignature;
import cn.xfyun.util.CryptTools;
import cn.xfyun.util.StringUtils;
import java.security.SignatureException;

public class LfasrSignature
extends AbstractSignature {
    public LfasrSignature(String appId, String keySecret) {
        super(appId, keySecret, null);
    }

    @Override
    public String getSigna() throws SignatureException {
        if (StringUtils.isNullOrEmpty(this.signa)) {
            this.setOriginSign(this.generateOriginSign());
            this.signa = this.generateSignature();
        }
        return this.signa;
    }

    public String generateSignature() throws SignatureException {
        return CryptTools.hmacEncrypt("HmacSHA1", this.getOriginSign(), this.getKey());
    }

    @Override
    public String generateOriginSign() throws SignatureException {
        return CryptTools.md5Encrypt(this.getId() + this.getTs());
    }
}

