/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.base.websocket;

import cn.xfyun.base.websocket.WebsocketBuilder;
import cn.xfyun.model.sign.AbstractSignature;
import cn.xfyun.model.sign.Hmac256Signature;
import cn.xfyun.util.AuthUtil;
import cn.xfyun.util.OkHttpUtils;
import java.net.MalformedURLException;
import java.security.SignatureException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public abstract class AbstractClient {
    protected String appId;
    protected String apiKey;
    protected String apiSecret;
    protected String originHostUrl;
    protected OkHttpClient okHttpClient;
    protected boolean retryOnConnectionFailure;
    protected int callTimeout;
    protected int connectTimeout;
    protected int readTimeout;
    protected int writeTimeout;
    protected int pingInterval;

    public AbstractClient(WebsocketBuilder builder) {
        this.appId = builder.getAppId();
        this.apiKey = builder.getApiKey();
        this.apiSecret = builder.getApiSecret();
        this.retryOnConnectionFailure = builder.getRetryOnConnectionFailure();
        this.callTimeout = builder.getCallTimeout();
        this.connectTimeout = builder.getConnectTimeout();
        this.readTimeout = builder.getReadTimeout();
        this.writeTimeout = builder.getWriteTimeout();
        this.pingInterval = builder.getPingInterval();
        this.okHttpClient = builder.getHttpClient() != null ? builder.getHttpClient() : OkHttpUtils.getDefaultClient().newBuilder().proxy(builder.getProxy()).callTimeout((long)builder.getCallTimeout(), TimeUnit.SECONDS).connectTimeout((long)builder.getConnectTimeout(), TimeUnit.SECONDS).readTimeout((long)builder.getReadTimeout(), TimeUnit.SECONDS).writeTimeout((long)builder.getWriteTimeout(), TimeUnit.SECONDS).retryOnConnectionFailure(builder.getRetryOnConnectionFailure()).build();
    }

    public String getAppId() {
        return this.appId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public String getOriginHostUrl() {
        return this.originHostUrl;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public boolean isRetryOnConnectionFailure() {
        return this.retryOnConnectionFailure;
    }

    public int getCallTimeout() {
        return this.callTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public int getPingInterval() {
        return this.pingInterval;
    }

    public AbstractSignature getSignature() {
        return new Hmac256Signature(this.apiKey, this.apiSecret, this.originHostUrl);
    }

    public String getHostUrl() throws MalformedURLException, SignatureException {
        String url = AuthUtil.generateRequestUrl(this.getSignature());
        return url.replace("http://", "ws://").replace("https://", "wss://");
    }

    public Request getRequest() throws MalformedURLException, SignatureException {
        return new Request.Builder().url(this.getHostUrl()).build();
    }

    protected WebSocket newWebSocket(WebSocketListener listener) throws MalformedURLException, SignatureException {
        return this.okHttpClient.newWebSocket(this.getRequest(), listener);
    }
}

