/*
 * Decompiled with CFR 0.152.
 */
package cn.apiclub.captcha.servlet;

import cn.apiclub.captcha.audio.Sample;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;

public final class CaptchaServletUtil {
    public static void writeImage(HttpServletResponse response, BufferedImage bi) {
        response.setHeader("Cache-Control", "private,no-cache,no-store");
        response.setContentType("image/png");
        try {
            CaptchaServletUtil.writeImage((OutputStream)response.getOutputStream(), bi);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeImage(OutputStream os, BufferedImage bi) {
        try {
            ImageIO.write((RenderedImage)bi, "png", os);
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeAudio(HttpServletResponse response, Sample sample) {
        response.setHeader("Cache-Control", "private,no-cache,no-store");
        response.setContentType("audio/wave");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            AudioSystem.write(sample.getAudioInputStream(), AudioFileFormat.Type.WAVE, baos);
            response.setContentLength(baos.size());
            ServletOutputStream os = response.getOutputStream();
            os.write(baos.toByteArray());
            os.flush();
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

