/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.csv.export;

import cn.afterturn.easypoi.csv.entity.CsvExportParams;
import cn.afterturn.easypoi.entity.BaseTypeConstants;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.export.base.BaseExportService;
import cn.afterturn.easypoi.exception.excel.ExcelExportException;
import cn.afterturn.easypoi.exception.excel.enums.ExcelExportEnum;
import cn.afterturn.easypoi.handler.inter.IWriter;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvExportService
extends BaseExportService
implements IWriter<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvExportService.class);
    private CsvExportParams params;
    private List<ExcelExportEntity> excelParams;
    private Writer writer;

    public CsvExportService(OutputStream outputStream, CsvExportParams params, Class<?> pojoClass) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CSV export start ,class is {}", pojoClass);
        }
        if (params == null || pojoClass == null) {
            throw new ExcelExportException(ExcelExportEnum.PARAMETER_ERROR);
        }
        try {
            ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
            Field[] fields = PoiPublicUtil.getClassFields(pojoClass);
            ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
            String targetId = etarget == null ? null : etarget.value();
            this.getAllExcelField(params.getExclusions(), targetId, fields, excelParams, pojoClass, null, null);
            this.createCsvOfList(outputStream, params, excelParams);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, (Throwable)e);
        }
    }

    public CsvExportService(OutputStream outputStream, CsvExportParams params, List<ExcelExportEntity> excelParams) {
        this.createCsvOfList(outputStream, params, excelParams);
    }

    private CsvExportService createCsvOfList(OutputStream outputStream, CsvExportParams params, List<ExcelExportEntity> excelParams) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, params.getEncoding()));
            this.params = params;
            this.excelParams = excelParams;
            this.writer = writer;
            this.dataHandler = params.getDataHandler();
            if (this.dataHandler != null && this.dataHandler.getNeedHandlerFields() != null) {
                this.needHandlerList = Arrays.asList(this.dataHandler.getNeedHandlerFields());
            }
            this.dictHandler = params.getDictHandler();
            this.i18nHandler = params.getI18nHandler();
            this.sortAllParams(excelParams);
            if (params.isCreateHeadRows()) {
                writer.write(this.createHeaderRow(params, excelParams));
            }
            return this;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, (Throwable)e);
        }
    }

    private String createRow(List<ExcelExportEntity> excelParams, CsvExportParams params, Object t) {
        StringBuilder sb = new StringBuilder();
        try {
            int paramSize = excelParams.size();
            for (int k = 0; k < paramSize; ++k) {
                ExcelExportEntity entity = excelParams.get(k);
                Object value = this.getCellValue(entity, t);
                if (entity.getType() == BaseTypeConstants.STRING_TYPE.intValue()) {
                    sb.append(params.getTextMark());
                    sb.append(value.toString());
                    sb.append(params.getTextMark());
                } else if (entity.getType() == BaseTypeConstants.DOUBLE_TYPE.intValue()) {
                    sb.append(value.toString());
                }
                if (k >= paramSize - 1) continue;
                sb.append(params.getSpiltMark());
            }
            return sb.append(this.getLineMark()).toString();
        }
        catch (Exception e) {
            LOGGER.error("csv export error ,data is :{}", (Object)ReflectionToStringBuilder.toString((Object)t));
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, (Throwable)e);
        }
    }

    private String createHeaderRow(CsvExportParams params, List<ExcelExportEntity> excelParams) {
        StringBuilder sb = new StringBuilder();
        int exportFieldTitleSize = excelParams.size();
        for (int i = 0; i < exportFieldTitleSize; ++i) {
            ExcelExportEntity entity = excelParams.get(i);
            sb.append(entity.getName());
            if (i >= exportFieldTitleSize - 1) continue;
            sb.append(params.getSpiltMark());
        }
        return sb.append(this.getLineMark()).toString();
    }

    private String getLineMark() {
        return "\n";
    }

    @Override
    public IWriter write(Collection data) {
        try {
            Iterator iterator = data.iterator();
            String line = null;
            int i = 0;
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                line = this.createRow(this.excelParams, this.params, obj);
                this.writer.write(line);
                if (i % 10000 == 0) {
                    this.writer.flush();
                }
                ++i;
            }
            this.writer.flush();
            return this;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, (Throwable)e);
        }
    }

    @Override
    public Void close() {
        IOUtils.closeQuietly((Closeable)this.writer);
        return null;
    }
}

