/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.common.AccessConstants;
import ch.qos.logback.access.common.joran.JoranConfigurator;
import ch.qos.logback.access.common.spi.AccessEvent;
import ch.qos.logback.access.common.spi.IAccessEvent;
import ch.qos.logback.access.common.spi.ServerAdapter;
import ch.qos.logback.access.common.util.AccessCommonVersionUtil;
import ch.qos.logback.access.jetty.JettyModernServerAdapter;
import ch.qos.logback.access.jetty.JettyServerAdapter;
import ch.qos.logback.access.jetty.RequestWrapper;
import ch.qos.logback.access.jetty.ResponseWrapper;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.FilterAttachable;
import ch.qos.logback.core.spi.FilterAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.CoreVersionUtil;
import ch.qos.logback.core.util.FileUtil;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusPrinter;
import ch.qos.logback.core.util.VersionUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.net.URL;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.LifeCycle;

public class RequestLogImpl
extends ContextBase
implements LifeCycle,
RequestLog,
AppenderAttachable<IAccessEvent>,
FilterAttachable<IAccessEvent> {
    public static final String DEFAULT_CONFIG_FILE = "etc" + File.separatorChar + "logback-access.xml";
    State state = State.STOPPED;
    AppenderAttachableImpl<IAccessEvent> aai = new AppenderAttachableImpl();
    FilterAttachableImpl<IAccessEvent> fai = new FilterAttachableImpl();
    String fileName;
    String resource;
    boolean quiet = false;
    static String LOGBACK_ACCESS_JETTY12_NAME = "logback-access-jetty12";
    static String LOGBACK_ACCESS_COMMON_NAME = "logback-access-common";
    static String LOGBACK_CORE_NAME = "logback-core";

    public RequestLogImpl() {
        this.setName("default");
        this.putObject("EVALUATOR_MAP", new HashMap());
    }

    public void log(Request jettyRequest, Response jettyResponse) {
        RequestWrapper requestWrapper = new RequestWrapper(jettyRequest);
        ResponseWrapper responseWrapper = new ResponseWrapper(jettyResponse);
        JettyServerAdapter adapter = this.makeJettyServerAdapter(jettyRequest, jettyResponse);
        AccessEvent accessEvent = new AccessEvent((Context)this, (HttpServletRequest)requestWrapper, (HttpServletResponse)responseWrapper, (ServerAdapter)adapter);
        if (this.getFilterChainDecision((IAccessEvent)accessEvent) == FilterReply.DENY) {
            return;
        }
        this.aai.appendLoopOnAppenders((Object)accessEvent);
    }

    private JettyServerAdapter makeJettyServerAdapter(Request jettyRequest, Response jettyResponse) {
        return new JettyModernServerAdapter(jettyRequest, jettyResponse);
    }

    protected void addInfo(String msg) {
        this.getStatusManager().add((Status)new InfoStatus(msg, (Object)this));
    }

    protected void addWarn(String msg) {
        this.getStatusManager().add((Status)new WarnStatus(msg, (Object)this));
    }

    private void addError(String msg) {
        this.getStatusManager().add((Status)new ErrorStatus(msg, (Object)this));
    }

    public void start() {
        this.state = State.STARTING;
        this.versionCheck();
        try {
            this.configure();
            if (!this.isQuiet()) {
                StatusPrinter.print((StatusManager)this.getStatusManager());
            }
            this.state = State.STARTED;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.state = State.FAILED;
        }
    }

    private void versionCheck() {
        try {
            String coreVersion = CoreVersionUtil.getCoreVersionBySelfDeclaredProperties();
            String accessCommonVersion = AccessCommonVersionUtil.getAccessCommonVersionBySelfDeclaredProperties();
            VersionUtil.checkForVersionEquality((Context)this, ((Object)((Object)this)).getClass(), (String)accessCommonVersion, (String)LOGBACK_ACCESS_JETTY12_NAME, (String)LOGBACK_ACCESS_COMMON_NAME);
            VersionUtil.compareExpectedAndFoundVersion((Context)this, (String)coreVersion, AccessConstants.class, (String)accessCommonVersion, (String)LOGBACK_ACCESS_COMMON_NAME, (String)LOGBACK_CORE_NAME);
        }
        catch (NoClassDefFoundError e) {
            this.addWarn("Missing ch.logback.core.util.VersionUtil class on classpath. The version of logback-core is probably earlier than 1.5.25.");
        }
        catch (NoSuchMethodError e) {
            this.addWarn(e.getMessage() + ". The version of logback-core is probably earlier than 1.5.26.");
        }
    }

    protected void configure() {
        URL configURL = this.getConfigurationFileURL();
        if (configURL != null) {
            this.runJoranOnFile(configURL);
        } else {
            this.addError("Could not find configuration file for logback-access");
        }
    }

    protected URL getConfigurationFileURL() {
        File file;
        if (this.fileName != null) {
            this.addInfo("Will use configuration file [" + this.fileName + "]");
            File file2 = new File(this.fileName);
            if (!file2.exists()) {
                return null;
            }
            return FileUtil.fileToURL((File)file2);
        }
        if (this.resource != null) {
            this.addInfo("Will use configuration resource [" + this.resource + "]");
            return ((Object)((Object)this)).getClass().getResource(this.resource);
        }
        Object defaultConfigFile = DEFAULT_CONFIG_FILE;
        String jettyBaseProperty = OptionHelper.getSystemProperty((String)"jetty.base");
        if (!OptionHelper.isNullOrEmpty((String)jettyBaseProperty)) {
            defaultConfigFile = jettyBaseProperty + File.separatorChar + DEFAULT_CONFIG_FILE;
        }
        if (!(file = new File((String)defaultConfigFile)).exists()) {
            String jettyHomeProperty = OptionHelper.getSystemProperty((String)"jetty.home");
            if (!OptionHelper.isEmpty((String)jettyHomeProperty)) {
                defaultConfigFile = jettyHomeProperty + File.separatorChar + DEFAULT_CONFIG_FILE;
            } else {
                this.addInfo("Neither [jetty.base] nor [jetty.home] system properties are set.");
            }
        }
        file = new File((String)defaultConfigFile);
        this.addInfo("Assuming default configuration file [" + (String)defaultConfigFile + "]");
        if (!file.exists()) {
            return null;
        }
        return FileUtil.fileToURL((File)file);
    }

    private void runJoranOnFile(URL configURL) {
        try {
            JoranConfigurator jc = new JoranConfigurator();
            jc.setContext((Context)this);
            jc.doConfigure(configURL);
            if (this.getName() == null) {
                this.setName("LogbackRequestLog");
            }
        }
        catch (JoranException joranException) {
            // empty catch block
        }
    }

    public void stop() {
        this.state = State.STOPPING;
        this.aai.detachAndStopAllAppenders();
        this.state = State.STOPPED;
    }

    public boolean isRunning() {
        return this.state == State.STARTED;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public boolean isStarted() {
        return this.state == State.STARTED;
    }

    public boolean isStarting() {
        return this.state == State.STARTING;
    }

    public boolean isStopping() {
        return this.state == State.STOPPING;
    }

    public boolean isStopped() {
        return this.state == State.STOPPED;
    }

    public boolean isFailed() {
        return this.state == State.FAILED;
    }

    public boolean addEventListener(EventListener listener) {
        return false;
    }

    public boolean removeEventListener(EventListener listener) {
        return false;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void addAppender(Appender<IAccessEvent> newAppender) {
        this.aai.addAppender(newAppender);
    }

    public Iterator<Appender<IAccessEvent>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    public Appender<IAccessEvent> getAppender(String name) {
        return this.aai.getAppender(name);
    }

    public boolean isAttached(Appender<IAccessEvent> appender) {
        return this.aai.isAttached(appender);
    }

    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    public boolean detachAppender(Appender<IAccessEvent> appender) {
        return this.aai.detachAppender(appender);
    }

    public boolean detachAppender(String name) {
        return this.aai.detachAppender(name);
    }

    public void addFilter(Filter<IAccessEvent> newFilter) {
        this.fai.addFilter(newFilter);
    }

    public void clearAllFilters() {
        this.fai.clearAllFilters();
    }

    public List<Filter<IAccessEvent>> getCopyOfAttachedFiltersList() {
        return this.fai.getCopyOfAttachedFiltersList();
    }

    public FilterReply getFilterChainDecision(IAccessEvent event) {
        return this.fai.getFilterChainDecision((Object)event);
    }

    public void addLifeCycleListener(LifeCycle.Listener listener) {
    }

    public void removeLifeCycleListener(LifeCycle.Listener listener) {
    }

    static enum State {
        FAILED,
        STOPPED,
        STARTING,
        STARTED,
        STOPPING;

    }
}

