/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl;

import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.room.AutoMigration;
import androidx.room.Database;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import androidx.room.TypeConverters;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.framework.FrameworkSQLiteOpenHelperFactory;
import androidx.work.Data;
import androidx.work.impl.AutoMigration_14_15;
import androidx.work.impl.CleanupCallback;
import androidx.work.impl.Migration_11_12;
import androidx.work.impl.Migration_12_13;
import androidx.work.impl.Migration_15_16;
import androidx.work.impl.Migration_1_2;
import androidx.work.impl.Migration_3_4;
import androidx.work.impl.Migration_4_5;
import androidx.work.impl.Migration_6_7;
import androidx.work.impl.Migration_7_8;
import androidx.work.impl.Migration_8_9;
import androidx.work.impl.RescheduleMigration;
import androidx.work.impl.WorkMigration9To10;
import androidx.work.impl.model.Dependency;
import androidx.work.impl.model.DependencyDao;
import androidx.work.impl.model.Preference;
import androidx.work.impl.model.PreferenceDao;
import androidx.work.impl.model.RawWorkInfoDao;
import androidx.work.impl.model.SystemIdInfo;
import androidx.work.impl.model.SystemIdInfoDao;
import androidx.work.impl.model.WorkName;
import androidx.work.impl.model.WorkNameDao;
import androidx.work.impl.model.WorkProgress;
import androidx.work.impl.model.WorkProgressDao;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.model.WorkTag;
import androidx.work.impl.model.WorkTagDao;
import androidx.work.impl.model.WorkTypeConverters;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&J\b\u0010\u0005\u001a\u00020\u0006H&J\b\u0010\u0007\u001a\u00020\bH&J\b\u0010\t\u001a\u00020\nH&J\b\u0010\u000b\u001a\u00020\fH&J\b\u0010\r\u001a\u00020\u000eH&J\b\u0010\u000f\u001a\u00020\u0010H&J\b\u0010\u0011\u001a\u00020\u0012H&\u00a8\u0006\u0014"}, d2={"Landroidx/work/impl/WorkDatabase;", "Landroidx/room/RoomDatabase;", "()V", "dependencyDao", "Landroidx/work/impl/model/DependencyDao;", "preferenceDao", "Landroidx/work/impl/model/PreferenceDao;", "rawWorkInfoDao", "Landroidx/work/impl/model/RawWorkInfoDao;", "systemIdInfoDao", "Landroidx/work/impl/model/SystemIdInfoDao;", "workNameDao", "Landroidx/work/impl/model/WorkNameDao;", "workProgressDao", "Landroidx/work/impl/model/WorkProgressDao;", "workSpecDao", "Landroidx/work/impl/model/WorkSpecDao;", "workTagDao", "Landroidx/work/impl/model/WorkTagDao;", "Companion", "work-runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@Database(entities={Dependency.class, WorkSpec.class, WorkTag.class, SystemIdInfo.class, WorkName.class, WorkProgress.class, Preference.class}, version=16, autoMigrations={@AutoMigration(from=13, to=14), @AutoMigration(from=14, to=15, spec=AutoMigration_14_15.class)})
@TypeConverters(value={Data.class, WorkTypeConverters.class})
public abstract class WorkDatabase
extends RoomDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract WorkSpecDao workSpecDao();

    @NotNull
    public abstract DependencyDao dependencyDao();

    @NotNull
    public abstract WorkTagDao workTagDao();

    @NotNull
    public abstract SystemIdInfoDao systemIdInfoDao();

    @NotNull
    public abstract WorkNameDao workNameDao();

    @NotNull
    public abstract WorkProgressDao workProgressDao();

    @NotNull
    public abstract PreferenceDao preferenceDao();

    @NotNull
    public abstract RawWorkInfoDao rawWorkInfoDao();

    @JvmStatic
    @NotNull
    public static final WorkDatabase create(@NotNull Context context, @NotNull Executor queryExecutor, boolean useTestDatabase) {
        return Companion.create(context, queryExecutor, useTestDatabase);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Landroidx/work/impl/WorkDatabase$Companion;", "", "()V", "create", "Landroidx/work/impl/WorkDatabase;", "context", "Landroid/content/Context;", "queryExecutor", "Ljava/util/concurrent/Executor;", "useTestDatabase", "", "work-runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final WorkDatabase create(@NotNull Context context, @NotNull Executor queryExecutor, boolean useTestDatabase) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
            RoomDatabase.Builder builder = useTestDatabase ? Room.inMemoryDatabaseBuilder((Context)context, WorkDatabase.class).allowMainThreadQueries() : Room.databaseBuilder((Context)context, WorkDatabase.class, (String)"androidx.work.workdb").openHelperFactory(arg_0 -> Companion.create$lambda$0(context, arg_0));
            Migration[] migrationArray = new Migration[]{Migration_1_2.INSTANCE};
            RoomDatabase.Builder builder2 = builder.setQueryExecutor(queryExecutor).addCallback((RoomDatabase.Callback)CleanupCallback.INSTANCE).addMigrations(migrationArray);
            migrationArray = new Migration[]{new RescheduleMigration(context, 2, 3)};
            RoomDatabase.Builder builder3 = builder2.addMigrations(migrationArray);
            migrationArray = new Migration[]{Migration_3_4.INSTANCE};
            RoomDatabase.Builder builder4 = builder3.addMigrations(migrationArray);
            migrationArray = new Migration[]{Migration_4_5.INSTANCE};
            RoomDatabase.Builder builder5 = builder4.addMigrations(migrationArray);
            migrationArray = new Migration[]{new RescheduleMigration(context, 5, 6)};
            RoomDatabase.Builder builder6 = builder5.addMigrations(migrationArray);
            migrationArray = new Migration[]{Migration_6_7.INSTANCE};
            RoomDatabase.Builder builder7 = builder6.addMigrations(migrationArray);
            migrationArray = new Migration[]{Migration_7_8.INSTANCE};
            RoomDatabase.Builder builder8 = builder7.addMigrations(migrationArray);
            migrationArray = new Migration[]{Migration_8_9.INSTANCE};
            RoomDatabase.Builder builder9 = builder8.addMigrations(migrationArray);
            migrationArray = new Migration[]{new WorkMigration9To10(context)};
            RoomDatabase.Builder builder10 = builder9.addMigrations(migrationArray);
            migrationArray = new Migration[]{new RescheduleMigration(context, 10, 11)};
            RoomDatabase.Builder builder11 = builder10.addMigrations(migrationArray);
            migrationArray = new Migration[]{Migration_11_12.INSTANCE};
            RoomDatabase.Builder builder12 = builder11.addMigrations(migrationArray);
            migrationArray = new Migration[]{Migration_12_13.INSTANCE};
            RoomDatabase.Builder builder13 = builder12.addMigrations(migrationArray);
            migrationArray = new Migration[]{Migration_15_16.INSTANCE};
            return (WorkDatabase)builder13.addMigrations(migrationArray).fallbackToDestructiveMigration().build();
        }

        private static final SupportSQLiteOpenHelper create$lambda$0(Context $context, SupportSQLiteOpenHelper.Configuration configuration) {
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            SupportSQLiteOpenHelper.Configuration.Builder configBuilder = SupportSQLiteOpenHelper.Configuration.Companion.builder($context);
            configBuilder.name(configuration.name).callback(configuration.callback).noBackupDirectory(true).allowDataLossOnRecovery(true);
            return new FrameworkSQLiteOpenHelperFactory().create(configBuilder.build());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

