/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemalarm;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class WorkTimer {
    private static final String TAG = Logger.tagWithPrefix("WorkTimer");
    private final ThreadFactory mBackgroundThreadFactory = new ThreadFactory(){
        private int mThreadsCreated = 0;

        @Override
        public Thread newThread(@NonNull Runnable r) {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName("WorkManager-WorkTimer-thread-" + this.mThreadsCreated);
            ++this.mThreadsCreated;
            return thread;
        }
    };
    private final ScheduledExecutorService mExecutorService;
    final Map<String, WorkTimerRunnable> mTimerMap = new HashMap<String, WorkTimerRunnable>();
    final Map<String, TimeLimitExceededListener> mListeners = new HashMap<String, TimeLimitExceededListener>();
    final Object mLock = new Object();

    WorkTimer() {
        this.mExecutorService = Executors.newSingleThreadScheduledExecutor(this.mBackgroundThreadFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startTimer(@NonNull String workSpecId, long processingTimeMillis, @NonNull TimeLimitExceededListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            Logger.get().debug(TAG, String.format("Starting timer for %s", workSpecId), new Throwable[0]);
            this.stopTimer(workSpecId);
            WorkTimerRunnable runnable = new WorkTimerRunnable(this, workSpecId);
            this.mTimerMap.put(workSpecId, runnable);
            this.mListeners.put(workSpecId, listener);
            this.mExecutorService.schedule(runnable, processingTimeMillis, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopTimer(@NonNull String workSpecId) {
        Object object = this.mLock;
        synchronized (object) {
            WorkTimerRunnable removed = this.mTimerMap.remove(workSpecId);
            if (removed != null) {
                Logger.get().debug(TAG, String.format("Stopping timer for %s", workSpecId), new Throwable[0]);
                this.mListeners.remove(workSpecId);
            }
        }
    }

    void onDestroy() {
        this.mExecutorService.shutdownNow();
    }

    @VisibleForTesting
    synchronized Map<String, WorkTimerRunnable> getTimerMap() {
        return this.mTimerMap;
    }

    @VisibleForTesting
    synchronized Map<String, TimeLimitExceededListener> getListeners() {
        return this.mListeners;
    }

    @VisibleForTesting
    ScheduledExecutorService getExecutorService() {
        return this.mExecutorService;
    }

    static interface TimeLimitExceededListener {
        public void onTimeLimitExceeded(@NonNull String var1);
    }

    static class WorkTimerRunnable
    implements Runnable {
        static final String TAG = "WrkTimerRunnable";
        private final WorkTimer mWorkTimer;
        private final String mWorkSpecId;

        WorkTimerRunnable(@NonNull WorkTimer workTimer, @NonNull String workSpecId) {
            this.mWorkTimer = workTimer;
            this.mWorkSpecId = workSpecId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.mWorkTimer.mLock;
            synchronized (object) {
                WorkTimerRunnable removed = this.mWorkTimer.mTimerMap.remove(this.mWorkSpecId);
                if (removed != null) {
                    TimeLimitExceededListener listener = this.mWorkTimer.mListeners.remove(this.mWorkSpecId);
                    if (listener != null) {
                        listener.onTimeLimitExceeded(this.mWorkSpecId);
                    }
                } else {
                    Logger.get().debug(TAG, String.format("Timer with %s is already marked as complete.", this.mWorkSpecId), new Throwable[0]);
                }
            }
        }
    }
}

