/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.BackoffPolicy;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.WorkInfo;
import androidx.work.impl.model.WorkSpec;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public abstract class WorkRequest {
    public static final long DEFAULT_BACKOFF_DELAY_MILLIS = 30000L;
    public static final long MAX_BACKOFF_MILLIS = 18000000L;
    public static final long MIN_BACKOFF_MILLIS = 10000L;
    @NonNull
    private UUID mId;
    @NonNull
    private WorkSpec mWorkSpec;
    @NonNull
    private Set<String> mTags;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected WorkRequest(@NonNull UUID id, @NonNull WorkSpec workSpec, @NonNull Set<String> tags) {
        this.mId = id;
        this.mWorkSpec = workSpec;
        this.mTags = tags;
    }

    @NonNull
    public UUID getId() {
        return this.mId;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public String getStringId() {
        return this.mId.toString();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public WorkSpec getWorkSpec() {
        return this.mWorkSpec;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Set<String> getTags() {
        return this.mTags;
    }

    public static abstract class Builder<B extends Builder, W extends WorkRequest> {
        boolean mBackoffCriteriaSet = false;
        UUID mId;
        WorkSpec mWorkSpec;
        Set<String> mTags = new HashSet<String>();

        Builder(@NonNull Class<? extends ListenableWorker> workerClass) {
            this.mId = UUID.randomUUID();
            this.mWorkSpec = new WorkSpec(this.mId.toString(), workerClass.getName());
            this.addTag(workerClass.getName());
        }

        @NonNull
        public final B setBackoffCriteria(@NonNull BackoffPolicy backoffPolicy, long backoffDelay, @NonNull TimeUnit timeUnit) {
            this.mBackoffCriteriaSet = true;
            this.mWorkSpec.backoffPolicy = backoffPolicy;
            this.mWorkSpec.setBackoffDelayDuration(timeUnit.toMillis(backoffDelay));
            return this.getThis();
        }

        @RequiresApi(value=26)
        @NonNull
        public final B setBackoffCriteria(@NonNull BackoffPolicy backoffPolicy, @NonNull Duration duration) {
            this.mBackoffCriteriaSet = true;
            this.mWorkSpec.backoffPolicy = backoffPolicy;
            this.mWorkSpec.setBackoffDelayDuration(duration.toMillis());
            return this.getThis();
        }

        @NonNull
        public final B setConstraints(@NonNull Constraints constraints) {
            this.mWorkSpec.constraints = constraints;
            return this.getThis();
        }

        @NonNull
        public final B setInputData(@NonNull Data inputData) {
            this.mWorkSpec.input = inputData;
            return this.getThis();
        }

        @NonNull
        public final B addTag(@NonNull String tag) {
            this.mTags.add(tag);
            return this.getThis();
        }

        @NonNull
        public final B keepResultsForAtLeast(long duration, @NonNull TimeUnit timeUnit) {
            this.mWorkSpec.minimumRetentionDuration = timeUnit.toMillis(duration);
            return this.getThis();
        }

        @RequiresApi(value=26)
        @NonNull
        public final B keepResultsForAtLeast(@NonNull Duration duration) {
            this.mWorkSpec.minimumRetentionDuration = duration.toMillis();
            return this.getThis();
        }

        @NonNull
        public final W build() {
            W returnValue = this.buildInternal();
            this.mId = UUID.randomUUID();
            this.mWorkSpec = new WorkSpec(this.mWorkSpec);
            this.mWorkSpec.id = this.mId.toString();
            return returnValue;
        }

        @NonNull
        abstract W buildInternal();

        @NonNull
        abstract B getThis();

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @VisibleForTesting
        @NonNull
        public final B setInitialState(@NonNull WorkInfo.State state) {
            this.mWorkSpec.state = state;
            return this.getThis();
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @VisibleForTesting
        @NonNull
        public final B setInitialRunAttemptCount(int runAttemptCount) {
            this.mWorkSpec.runAttemptCount = runAttemptCount;
            return this.getThis();
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @VisibleForTesting
        @NonNull
        public final B setPeriodStartTime(long periodStartTime, @NonNull TimeUnit timeUnit) {
            this.mWorkSpec.periodStartTime = timeUnit.toMillis(periodStartTime);
            return this.getThis();
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @VisibleForTesting
        @NonNull
        public final B setScheduleRequestedAt(long scheduleRequestedAt, @NonNull TimeUnit timeUnit) {
            this.mWorkSpec.scheduleRequestedAt = timeUnit.toMillis(scheduleRequestedAt);
            return this.getThis();
        }
    }
}

