/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess;

import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Logger;
import androidx.work.multiprocess.IWorkManagerImplCallback;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class ListenableCallback<I> {
    final Executor mExecutor;
    final IWorkManagerImplCallback mCallback;
    final ListenableFuture<I> mFuture;

    public ListenableCallback(@NonNull Executor executor, @NonNull IWorkManagerImplCallback callback, @NonNull ListenableFuture<I> future) {
        this.mExecutor = executor;
        this.mCallback = callback;
        this.mFuture = future;
    }

    @NonNull
    public abstract byte[] toByteArray(@NonNull I var1);

    public void dispatchCallbackSafely() {
        this.mFuture.addListener(new ListenableCallbackRunnable(this), this.mExecutor);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class ListenableCallbackRunnable<I>
    implements Runnable {
        private static final String TAG = Logger.tagWithPrefix((String)"ListenableCallbackRbl");
        private final ListenableCallback<I> mCallback;

        public ListenableCallbackRunnable(@NonNull ListenableCallback<I> callback) {
            this.mCallback = callback;
        }

        @Override
        public void run() {
            try {
                Object result = this.mCallback.mFuture.get();
                ListenableCallbackRunnable.successCallback(this.mCallback.mCallback, this.mCallback.toByteArray(result));
            }
            catch (Throwable throwable) {
                ListenableCallbackRunnable.failureCallback(this.mCallback.mCallback, throwable);
            }
        }

        public static void successCallback(@NonNull IWorkManagerImplCallback callback, @NonNull byte[] response) {
            try {
                callback.onSuccess(response);
            }
            catch (RemoteException exception) {
                Logger.get().error(TAG, "Unable to notify successful operation", new Throwable[]{exception});
            }
        }

        public static void failureCallback(@NonNull IWorkManagerImplCallback callback, @NonNull Throwable throwable) {
            try {
                callback.onFailure(throwable.getMessage());
            }
            catch (RemoteException exception) {
                Logger.get().error(TAG, "Unable to notify failures in operation", new Throwable[]{exception});
            }
        }
    }
}

