/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.intent.matcher;

import android.net.Uri;
import androidx.test.espresso.intent.Checks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

public final class UriMatchers {
    private UriMatchers() {
    }

    static Set<String> getQueryParameterNames(Uri uri) {
        int end;
        Checks.checkArgument(!uri.isOpaque(), "This isn't a hierarchical URI.");
        String query = uri.getEncodedQuery();
        if (query == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        int start = 0;
        do {
            int next;
            end = (next = query.indexOf(38, start)) == -1 ? query.length() : next;
            int separator = query.indexOf(61, start);
            if (separator > end || separator == -1) {
                separator = end;
            }
            String name = query.substring(start, separator);
            names.add(Uri.decode((String)name));
        } while ((start = end + 1) < query.length());
        return Collections.unmodifiableSet(names);
    }

    public static Matcher<Uri> hasHost(String host) {
        return UriMatchers.hasHost((Matcher<String>)Matchers.is((Object)host));
    }

    public static Matcher<Uri> hasHost(final Matcher<String> hostMatcher) {
        Checks.checkNotNull(hostMatcher);
        return new TypeSafeMatcher<Uri>(){

            public boolean matchesSafely(Uri uri) {
                return hostMatcher.matches((Object)uri.getHost());
            }

            public void describeTo(Description description) {
                description.appendText("has host: ");
                description.appendDescriptionOf((SelfDescribing)hostMatcher);
            }
        };
    }

    public static Matcher<Uri> hasParamWithName(String paramName) {
        return UriMatchers.hasParamWithName((Matcher<String>)Matchers.is((Object)paramName));
    }

    public static Matcher<Uri> hasParamWithName(final Matcher<String> paramName) {
        Checks.checkNotNull(paramName);
        return new TypeSafeMatcher<Uri>(){

            public boolean matchesSafely(Uri uri) {
                return Matchers.hasItem((Matcher)paramName).matches(UriMatchers.getQueryParameterNames(uri));
            }

            public void describeTo(Description description) {
                description.appendText("has param with name: ");
                description.appendDescriptionOf((SelfDescribing)paramName);
            }
        };
    }

    public static Matcher<Uri> hasPath(String pathName) {
        return UriMatchers.hasPath((Matcher<String>)Matchers.is((Object)pathName));
    }

    public static Matcher<Uri> hasPath(final Matcher<String> pathName) {
        Checks.checkNotNull(pathName);
        return new TypeSafeMatcher<Uri>(){

            public boolean matchesSafely(Uri uri) {
                return pathName.matches((Object)uri.getPath());
            }

            public void describeTo(Description description) {
                description.appendText("has path: ");
                description.appendDescriptionOf((SelfDescribing)pathName);
            }
        };
    }

    public static Matcher<Uri> hasParamWithValue(String paramName, String paramVal) {
        return UriMatchers.hasParamWithValue((Matcher<String>)Matchers.is((Object)paramName), (Matcher<String>)Matchers.is((Object)paramVal));
    }

    public static Matcher<Uri> hasParamWithValue(final Matcher<String> paramName, final Matcher<String> paramVal) {
        Checks.checkNotNull(paramName);
        Checks.checkNotNull(paramVal);
        Matcher<QueryParamEntry> qpe = UriMatchers.queryParamEntry(paramName, paramVal);
        final Matcher matcherImpl = Matchers.hasItem(qpe);
        return new TypeSafeMatcher<Uri>(){

            public boolean matchesSafely(Uri uri) {
                ArrayList<QueryParamEntry> qpes = new ArrayList<QueryParamEntry>();
                for (String name : UriMatchers.getQueryParameterNames(uri)) {
                    qpes.add(new QueryParamEntry(name, uri.getQueryParameters(name)));
                }
                return matcherImpl.matches(qpes);
            }

            public void describeTo(Description description) {
                description.appendText("has param with: name: ");
                description.appendDescriptionOf((SelfDescribing)paramName);
                description.appendText(" value: ");
                description.appendDescriptionOf((SelfDescribing)paramVal);
            }
        };
    }

    private static Matcher<QueryParamEntry> queryParamEntry(final Matcher<String> paramName, final Matcher<String> paramVal) {
        final Matcher valMatcher = Matchers.hasItem(paramVal);
        return new TypeSafeMatcher<QueryParamEntry>(QueryParamEntry.class){

            public boolean matchesSafely(QueryParamEntry qpe) {
                return paramName.matches((Object)qpe.paramName) && valMatcher.matches(qpe.paramVals);
            }

            public void describeTo(Description description) {
                description.appendDescriptionOf((SelfDescribing)paramName);
                description.appendDescriptionOf((SelfDescribing)paramVal);
            }
        };
    }

    public static Matcher<Uri> hasScheme(String scheme) {
        return UriMatchers.hasScheme((Matcher<String>)Matchers.is((Object)scheme));
    }

    public static Matcher<Uri> hasScheme(final Matcher<String> schemeMatcher) {
        Checks.checkNotNull(schemeMatcher);
        return new TypeSafeMatcher<Uri>(){

            public boolean matchesSafely(Uri uri) {
                return schemeMatcher.matches((Object)uri.getScheme());
            }

            public void describeTo(Description description) {
                description.appendText("has scheme: ");
                description.appendDescriptionOf((SelfDescribing)schemeMatcher);
            }
        };
    }

    public static Matcher<Uri> hasSchemeSpecificPart(String scheme, String schemeSpecificPart) {
        return UriMatchers.hasSchemeSpecificPart((Matcher<String>)Matchers.is((Object)scheme), (Matcher<String>)Matchers.is((Object)schemeSpecificPart));
    }

    public static Matcher<Uri> hasSchemeSpecificPart(final Matcher<String> schemeMatcher, final Matcher<String> schemeSpecificPartMatcher) {
        Checks.checkNotNull(schemeMatcher);
        Checks.checkNotNull(schemeSpecificPartMatcher);
        return new TypeSafeMatcher<Uri>(){

            public boolean matchesSafely(Uri uri) {
                return schemeMatcher.matches((Object)uri.getScheme()) && schemeSpecificPartMatcher.matches((Object)uri.getSchemeSpecificPart());
            }

            public void describeTo(Description description) {
                description.appendText("has scheme specific part: scheme: ");
                description.appendDescriptionOf((SelfDescribing)schemeMatcher);
                description.appendText(" scheme specific part: ");
                description.appendDescriptionOf((SelfDescribing)schemeSpecificPartMatcher);
            }
        };
    }

    static class SchemeParamValue {
        String schemeName;
        String schemeVals;

        public SchemeParamValue(String schemeName, String schemeVals) {
            this.schemeName = schemeName;
            this.schemeVals = schemeVals;
        }
    }

    static class QueryParamEntry {
        String paramName;
        Iterable<String> paramVals;

        public QueryParamEntry(String paramName, Iterable<String> paramVals) {
            this.paramName = paramName;
            this.paramVals = paramVals;
        }
    }
}

