/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.testing;

import android.os.Bundle;
import androidx.core.os.BundleKt;
import androidx.lifecycle.SavedStateHandle;
import androidx.navigation.CollectionNavType;
import androidx.navigation.NamedNavArgument;
import androidx.navigation.NavArgument;
import androidx.navigation.NavType;
import androidx.navigation.serialization.RouteEncoder;
import androidx.navigation.serialization.RouteSerializerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u001d\b\u0002\u0010\f\u001a\u0017\u0012\u0004\u0012\u00020\u000e\u0012\r\u0012\u000b\u0012\u0002\b\u00030\u0001\u00a2\u0006\u0002\b\u000f0\rH\u0086\u0002\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00050\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"CommonizedStringArrayType", "Landroidx/navigation/NavType;", "", "", "CommonizedStringListType", "", "CommonizedStringType", "invoke", "Landroidx/lifecycle/SavedStateHandle;", "Landroidx/lifecycle/SavedStateHandle$Companion;", "route", "", "typeMap", "", "Lkotlin/reflect/KType;", "Lkotlin/jvm/JvmSuppressWildcards;", "navigation-testing_release"})
@SourceDebugExtension(value={"SMAP\nSavedStateHandleFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SavedStateHandleFactory.kt\nandroidx/navigation/testing/SavedStateHandleFactoryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,205:1\n1549#2:206\n1620#2,3:207\n1855#2,2:213\n1855#2,2:216\n215#3,2:210\n215#3:212\n216#3:215\n*S KotlinDebug\n*F\n+ 1 SavedStateHandleFactory.kt\nandroidx/navigation/testing/SavedStateHandleFactoryKt\n*L\n53#1:206\n53#1:207,3\n85#1:213,2\n101#1:216,2\n56#1:210,2\n73#1:212\n73#1:215\n*E\n"})
public final class SavedStateHandleFactoryKt {
    @NotNull
    private static final NavType<String> CommonizedStringType = (NavType)new NavType<String>(){

        public String getName() {
            return "string";
        }

        public void put(Bundle bundle, String key, String value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            bundle.putString(key, value);
        }

        public String get(Bundle bundle, String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (String)bundle.get(key);
        }

        public String parseValue(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Intrinsics.areEqual((Object)value, (Object)"null") ? null : value;
        }

        public String serializeAsValue(String value) {
            String string = value;
            if (string == null) {
                string = "null";
            }
            return string;
        }
    };
    @NotNull
    private static final NavType<String[]> CommonizedStringArrayType = (NavType)new CollectionNavType<String[]>(){

        public String getName() {
            return "string[]";
        }

        public void put(Bundle bundle, String key, String[] value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            bundle.putStringArray(key, value);
        }

        public String[] get(Bundle bundle, String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (String[])bundle.get(key);
        }

        public String[] parseValue(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String[] stringArray = new String[]{value};
            return stringArray;
        }

        public String[] parseValue(String value, String[] previousValue) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Object[] objectArray = previousValue;
            if (previousValue == null || (objectArray = (String[])ArraysKt.plus((Object[])objectArray, (Object[])this.parseValue(value))) == null) {
                objectArray = this.parseValue(value);
            }
            return objectArray;
        }

        public boolean valueEquals(String[] value, String[] other) {
            Object[] objectArray = value;
            return ArraysKt.contentDeepEquals((Object[])objectArray, (Object[])other);
        }

        public List<String> serializeAsValues(String[] value) {
            Object object = value;
            if (value == null || (object = ArraysKt.toList((Object[])object)) == null) {
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        public String[] emptyCollection() {
            return new String[0];
        }
    };
    @NotNull
    private static final NavType<List<String>> CommonizedStringListType = (NavType)new CollectionNavType<List<? extends String>>(){

        public String getName() {
            return "List<String>";
        }

        public void put(Bundle bundle, String key, List<String> value) {
            String[] stringArray;
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            List<String> list = value;
            if (list != null) {
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                stringArray = thisCollection$iv.toArray(new String[0]);
            } else {
                stringArray = null;
            }
            bundle.putStringArray(key, stringArray);
        }

        public List<String> get(Bundle bundle, String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object[] objectArray = (String[])bundle.get(key);
            return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
        }

        public List<String> parseValue(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return CollectionsKt.listOf((Object)value);
        }

        public List<String> parseValue(String value, List<String> previousValue) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            List<String> list = previousValue;
            if (list == null || (list = CollectionsKt.plus((Collection)list, (Iterable)((Iterable)this.parseValue(value)))) == null) {
                list = this.parseValue(value);
            }
            return list;
        }

        public boolean valueEquals(List<String> value, List<String> other) {
            String[] stringArray;
            Object[] objectArray;
            List<String> list = value;
            if (list != null) {
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                objectArray = thisCollection$iv.toArray(new String[0]);
            } else {
                objectArray = null;
            }
            Object[] valueArray = objectArray;
            List<String> list2 = other;
            if (list2 != null) {
                Collection $this$toTypedArray$iv = list2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                stringArray = thisCollection$iv.toArray(new String[0]);
            } else {
                stringArray = null;
            }
            String[] otherArray = stringArray;
            Object[] objectArray2 = valueArray;
            return ArraysKt.contentDeepEquals((Object[])objectArray2, otherArray);
        }

        public List<String> serializeAsValues(List<String> value) {
            List list = value;
            if (list == null || (list = CollectionsKt.toList((Iterable)list)) == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        public List<String> emptyCollection() {
            return CollectionsKt.emptyList();
        }
    };

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SavedStateHandle invoke(@NotNull SavedStateHandle.Companion $this$invoke, @NotNull Object route, @NotNull Map<KType, NavType<?>> typeMap) {
        Object it;
        void $this$mapTo$iv$iv;
        Map map;
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Intrinsics.checkNotNullParameter(typeMap, (String)"typeMap");
        KSerializer serializer = SerializersKt.serializer((KClass)Reflection.getOrCreateKotlinClass(route.getClass()));
        Map $this$invoke_u24lambda_u241 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        Iterable $this$map$iv = RouteSerializerKt.generateNavArguments((KSerializer)serializer, typeMap);
        boolean bl2 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            NamedNavArgument namedNavArgument = (NamedNavArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl22 = false;
            collection.add($this$invoke_u24lambda_u241.put(it2.getName(), it2.getArgument()));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        Map namedArgs = map;
        Map finalTypeMap = new LinkedHashMap();
        Map $this$forEach$iv = namedArgs;
        boolean $i$f$forEach = false;
        for (Map.Entry entry : $this$forEach$iv.entrySet()) {
            NavType<List<String>> finalNavType;
            it = entry;
            boolean bl3 = false;
            NavType $i$f$mapTo22 = ((NavArgument)it.getValue()).getType();
            Intrinsics.checkNotNull(Intrinsics.areEqual((Object)$i$f$mapTo22, (Object)NavType.StringListType) ? CommonizedStringListType : (Intrinsics.areEqual((Object)$i$f$mapTo22, (Object)NavType.StringArrayType) ? CommonizedStringArrayType : (Intrinsics.areEqual((Object)$i$f$mapTo22, (Object)NavType.StringType) ? CommonizedStringType : ((NavArgument)it.getValue()).getType())), (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any?>");
            finalNavType = finalNavType;
            finalTypeMap.put(it.getKey(), finalNavType);
        }
        Map argValues = new RouteEncoder(serializer, finalTypeMap).encodeToArgMap(route);
        Bundle bundle = BundleKt.bundleOf((Pair[])new Pair[0]);
        Map $this$forEach$iv2 = argValues;
        boolean bl3 = false;
        it = $this$forEach$iv2.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)it.next();
            boolean bl4 = false;
            String argName = (String)entry.getKey();
            NavType type = (NavType)finalTypeMap.get(entry.getKey());
            if (type == null) {
                boolean $i$a$-checkNotNull-SavedStateHandleFactoryKt$invoke$2$232 = false;
                String $i$a$-checkNotNull-SavedStateHandleFactoryKt$invoke$2$232 = "SavedStateHandleFactory could not locate NavType for argument [" + argName + "]. Pleaseprovide NavType in typeMap.";
                throw new IllegalStateException($i$a$-checkNotNull-SavedStateHandleFactoryKt$invoke$2$232.toString());
            }
            Bundle tempBundle = BundleKt.bundleOf((Pair[])new Pair[0]);
            if (type instanceof CollectionNavType) {
                NavArgument navArgument = (NavArgument)namedArgs.get(argName);
                Boolean bl5 = navArgument != null ? Boolean.valueOf(navArgument.isDefaultValuePresent()) : null;
                Intrinsics.checkNotNull((Object)bl5);
                if (!bl5.booleanValue()) {
                    type.put(tempBundle, argName, ((CollectionNavType)type).emptyCollection());
                }
            }
            Iterable $this$forEach$iv3 = (Iterable)entry.getValue();
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                String value = (String)element$iv2;
                boolean bl6 = false;
                try {
                    if (!tempBundle.containsKey(argName)) {
                        type.parseAndPut(tempBundle, argName, value);
                        continue;
                    }
                    Object previousValue = type.get(tempBundle, argName);
                    type.parseAndPut(tempBundle, argName, value, previousValue);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
            bundle.putAll(tempBundle);
        }
        Map finalMap = new LinkedHashMap();
        Set set = bundle.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"bundle.keySet()");
        Iterable iterable2 = set;
        boolean $i$f$forEach4 = false;
        for (Object element$iv : iterable2) {
            String name = (String)element$iv;
            boolean bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            finalMap.put(name, bundle.get(name));
        }
        return new SavedStateHandle(finalMap);
    }

    public static /* synthetic */ SavedStateHandle invoke$default(SavedStateHandle.Companion companion, Object object, Map map, int n, Object object2) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return SavedStateHandleFactoryKt.invoke(companion, object, map);
    }
}

