/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.dynamicfeatures;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.util.AttributeSet;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavInflater;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.dynamicfeatures.DynamicExtras;
import androidx.navigation.dynamicfeatures.DynamicInstallManager;
import androidx.navigation.dynamicfeatures.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Navigator.Name(value="include-dynamic")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0002H\u0016J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J*\u0010\u0013\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Landroidx/navigation/dynamicfeatures/DynamicIncludeGraphNavigator;", "Landroidx/navigation/Navigator;", "Landroidx/navigation/dynamicfeatures/DynamicIncludeGraphNavigator$DynamicIncludeNavGraph;", "context", "Landroid/content/Context;", "navigatorProvider", "Landroidx/navigation/NavigatorProvider;", "navInflater", "Landroidx/navigation/NavInflater;", "installManager", "Landroidx/navigation/dynamicfeatures/DynamicInstallManager;", "(Landroid/content/Context;Landroidx/navigation/NavigatorProvider;Landroidx/navigation/NavInflater;Landroidx/navigation/dynamicfeatures/DynamicInstallManager;)V", "createdDestinations", "", "packageName", "", "getPackageName$navigation_dynamic_features_runtime_release", "()Ljava/lang/String;", "createDestination", "navigate", "", "entry", "Landroidx/navigation/NavBackStackEntry;", "navOptions", "Landroidx/navigation/NavOptions;", "navigatorExtras", "Landroidx/navigation/Navigator$Extras;", "entries", "", "onRestoreState", "savedState", "Landroid/os/Bundle;", "onSaveState", "replaceWithIncludedNav", "Landroidx/navigation/NavGraph;", "destination", "DynamicIncludeNavGraph", "navigation-dynamic-features-runtime_release"})
public final class DynamicIncludeGraphNavigator
extends Navigator<DynamicIncludeNavGraph> {
    @NotNull
    private final Context context;
    @NotNull
    private final NavigatorProvider navigatorProvider;
    @NotNull
    private final NavInflater navInflater;
    @NotNull
    private final DynamicInstallManager installManager;
    @NotNull
    private final String packageName;
    @NotNull
    private final List<DynamicIncludeNavGraph> createdDestinations;

    public DynamicIncludeGraphNavigator(@NotNull Context context, @NotNull NavigatorProvider navigatorProvider, @NotNull NavInflater navInflater, @NotNull DynamicInstallManager installManager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)navigatorProvider, (String)"navigatorProvider");
        Intrinsics.checkNotNullParameter((Object)navInflater, (String)"navInflater");
        Intrinsics.checkNotNullParameter((Object)installManager, (String)"installManager");
        this.context = context;
        this.navigatorProvider = navigatorProvider;
        this.navInflater = navInflater;
        this.installManager = installManager;
        String string = this.context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        this.packageName = string;
        this.createdDestinations = new ArrayList();
    }

    @NotNull
    public final String getPackageName$navigation_dynamic_features_runtime_release() {
        return this.packageName;
    }

    @NotNull
    public DynamicIncludeNavGraph createDestination() {
        DynamicIncludeNavGraph dynamicIncludeNavGraph;
        DynamicIncludeNavGraph it = dynamicIncludeNavGraph = new DynamicIncludeNavGraph((Navigator<? extends NavDestination>)((Navigator)this));
        boolean bl = false;
        this.createdDestinations.add(it);
        return dynamicIncludeNavGraph;
    }

    public void navigate(@NotNull List<NavBackStackEntry> entries, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        for (NavBackStackEntry entry : entries) {
            this.navigate(entry, navOptions, navigatorExtras);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void navigate(NavBackStackEntry entry, NavOptions navOptions, Navigator.Extras navigatorExtras) {
        DynamicIncludeNavGraph destination = (DynamicIncludeNavGraph)entry.getDestination();
        DynamicExtras extras = navigatorExtras instanceof DynamicExtras ? (DynamicExtras)navigatorExtras : null;
        String moduleName = destination.getModuleName();
        if (moduleName != null && this.installManager.needsInstall(moduleName)) {
            this.installManager.performInstall(entry, extras, moduleName);
        } else {
            void $this$get$iv;
            NavGraph includedNav = this.replaceWithIncludedNav(destination);
            NavigatorProvider navigatorProvider = this.navigatorProvider;
            String name$iv = includedNav.getNavigatorName();
            boolean $i$f$get = false;
            Navigator navigator = $this$get$iv.getNavigator(name$iv);
            NavBackStackEntry newGraphEntry = this.getState().createBackStackEntry((NavDestination)includedNav, entry.getArguments());
            navigator.navigate(CollectionsKt.listOf((Object)newGraphEntry), navOptions, navigatorExtras);
        }
    }

    private final NavGraph replaceWithIncludedNav(DynamicIncludeNavGraph destination) {
        int graphId = this.context.getResources().getIdentifier(destination.getGraphResourceName(), "navigation", destination.getGraphPackage());
        if (graphId == 0) {
            throw new Resources.NotFoundException(destination.getGraphPackage() + ":navigation/" + destination.getGraphResourceName());
        }
        NavGraph includedNav = this.navInflater.inflate(graphId);
        if (!(includedNav.getId() == 0 || includedNav.getId() == destination.getId())) {
            boolean bl = false;
            String string = "The included <navigation>'s id " + includedNav.getDisplayName() + " is different from the destination id " + destination.getDisplayName() + ". Either remove the <navigation> id or make them match.";
            throw new IllegalStateException(string.toString());
        }
        includedNav.setId(destination.getId());
        NavGraph navGraph = destination.getParent();
        if (navGraph == null) {
            throw new IllegalStateException("The include-dynamic destination with id " + destination.getDisplayName() + " does not have a parent. Make sure it is attached to a NavGraph.");
        }
        NavGraph outerNav = navGraph;
        outerNav.addDestination((NavDestination)includedNav);
        this.createdDestinations.remove((Object)destination);
        return includedNav;
    }

    @Nullable
    public Bundle onSaveState() {
        return Bundle.EMPTY;
    }

    public void onRestoreState(@NotNull Bundle savedState) {
        Intrinsics.checkNotNullParameter((Object)savedState, (String)"savedState");
        super.onRestoreState(savedState);
        while (!((Collection)this.createdDestinations).isEmpty()) {
            Iterator iterator;
            Intrinsics.checkNotNullExpressionValue(new ArrayList(this.createdDestinations).iterator(), (String)"ArrayList(createdDestinations).iterator()");
            this.createdDestinations.clear();
            while (iterator.hasNext()) {
                DynamicIncludeNavGraph dynamicNavGraph = (DynamicIncludeNavGraph)((Object)iterator.next());
                String moduleName = dynamicNavGraph.getModuleName();
                if (moduleName != null && this.installManager.needsInstall(moduleName)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)dynamicNavGraph), (String)"dynamicNavGraph");
                this.replaceWithIncludedNav(dynamicNavGraph);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\u001f\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\n\u00a8\u0006\u001f"}, d2={"Landroidx/navigation/dynamicfeatures/DynamicIncludeGraphNavigator$DynamicIncludeNavGraph;", "Landroidx/navigation/NavDestination;", "navGraphNavigator", "Landroidx/navigation/Navigator;", "(Landroidx/navigation/Navigator;)V", "graphPackage", "", "getGraphPackage", "()Ljava/lang/String;", "setGraphPackage", "(Ljava/lang/String;)V", "graphResourceName", "getGraphResourceName", "setGraphResourceName", "moduleName", "getModuleName", "setModuleName", "equals", "", "other", "", "getPackageOrDefault", "context", "Landroid/content/Context;", "getPackageOrDefault$navigation_dynamic_features_runtime_release", "hashCode", "", "onInflate", "", "attrs", "Landroid/util/AttributeSet;", "navigation-dynamic-features-runtime_release"})
    public static final class DynamicIncludeNavGraph
    extends NavDestination {
        @Nullable
        private String graphResourceName;
        @Nullable
        private String graphPackage;
        @Nullable
        private String moduleName;

        public DynamicIncludeNavGraph(@NotNull Navigator<? extends NavDestination> navGraphNavigator) {
            Intrinsics.checkNotNullParameter(navGraphNavigator, (String)"navGraphNavigator");
            super(navGraphNavigator);
        }

        @Nullable
        public final String getGraphResourceName() {
            return this.graphResourceName;
        }

        public final void setGraphResourceName(@Nullable String string) {
            this.graphResourceName = string;
        }

        @Nullable
        public final String getGraphPackage() {
            return this.graphPackage;
        }

        public final void setGraphPackage(@Nullable String string) {
            this.graphPackage = string;
        }

        @Nullable
        public final String getModuleName() {
            return this.moduleName;
        }

        public final void setModuleName(@Nullable String string) {
            this.moduleName = string;
        }

        /*
         * WARNING - void declaration
         */
        public void onInflate(@NotNull Context context, @NotNull AttributeSet attrs) {
            void it;
            void $this$withStyledAttributes$iv;
            TypedArray typedArray;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
            super.onInflate(context, attrs);
            Context context2 = context;
            Intrinsics.checkNotNullExpressionValue((Object)R.styleable.DynamicIncludeGraphNavigator, (String)"DynamicIncludeGraphNavigator");
            int[] attrs$iv = R.styleable.DynamicIncludeGraphNavigator;
            int defStyleAttr$iv = 0;
            int defStyleRes$iv = 0;
            boolean $i$f$withStyledAttributes = false;
            TypedArray $this$onInflate_u24lambda_u2d4 = typedArray = $this$withStyledAttributes$iv.obtainStyledAttributes(attrs, attrs$iv, defStyleAttr$iv, defStyleRes$iv);
            boolean bl = false;
            this.moduleName = $this$onInflate_u24lambda_u2d4.getString(R.styleable.DynamicIncludeGraphNavigator_moduleName);
            CharSequence charSequence = this.moduleName;
            if (!(!(charSequence == null || charSequence.length() == 0))) {
                boolean $i$a$-require-DynamicIncludeGraphNavigator$DynamicIncludeNavGraph$onInflate$1$22 = false;
                String $i$a$-require-DynamicIncludeGraphNavigator$DynamicIncludeNavGraph$onInflate$1$22 = "`moduleName` must be set for <include-dynamic>";
                throw new IllegalArgumentException($i$a$-require-DynamicIncludeGraphNavigator$DynamicIncludeNavGraph$onInflate$1$22.toString());
            }
            String $i$a$-require-DynamicIncludeGraphNavigator$DynamicIncludeNavGraph$onInflate$1$22 = $this$onInflate_u24lambda_u2d4.getString(R.styleable.DynamicIncludeGraphNavigator_graphPackage);
            DynamicIncludeNavGraph dynamicIncludeNavGraph = this;
            boolean bl2 = false;
            if (it != null && !(((CharSequence)it).length() > 0)) {
                boolean bl3 = false;
                String string = "`graphPackage` cannot be empty for <include-dynamic>. You can omit the `graphPackage` attribute entirely to use the default of " + context.getPackageName() + '.' + this.moduleName + '.';
                throw new IllegalArgumentException(string.toString());
            }
            dynamicIncludeNavGraph.graphPackage = this.getPackageOrDefault$navigation_dynamic_features_runtime_release(context, (String)it);
            this.graphResourceName = $this$onInflate_u24lambda_u2d4.getString(R.styleable.DynamicIncludeGraphNavigator_graphResName);
            charSequence = this.graphResourceName;
            if (!(!(charSequence == null || charSequence.length() == 0))) {
                boolean bl4 = false;
                String string = "`graphResName` must be set for <include-dynamic>";
                throw new IllegalArgumentException(string.toString());
            }
            typedArray.recycle();
        }

        @NotNull
        public final String getPackageOrDefault$navigation_dynamic_features_runtime_release(@NotNull Context context, @Nullable String graphPackage) {
            String string;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    string = graphPackage;
                    if (string == null) break block2;
                    String string2 = context.getPackageName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.packageName");
                    if ((string = StringsKt.replace$default((String)string, (String)"${applicationId}", (String)string2, (boolean)false, (int)4, null)) != null) break block3;
                }
                string = context.getPackageName() + '.' + this.moduleName;
            }
            return string;
        }

        public boolean equals(@Nullable Object other) {
            if (other == null || !(other instanceof DynamicIncludeNavGraph)) {
                return false;
            }
            return super.equals(other) && Intrinsics.areEqual((Object)this.graphResourceName, (Object)((DynamicIncludeNavGraph)((Object)other)).graphResourceName) && Intrinsics.areEqual((Object)this.graphPackage, (Object)((DynamicIncludeNavGraph)((Object)other)).graphPackage) && Intrinsics.areEqual((Object)this.moduleName, (Object)((DynamicIncludeNavGraph)((Object)other)).moduleName);
        }

        public int hashCode() {
            int result = super.hashCode();
            String string = this.graphResourceName;
            result = 31 * result + (string != null ? string.hashCode() : 0);
            String string2 = this.graphPackage;
            result = 31 * result + (string2 != null ? string2.hashCode() : 0);
            String string3 = this.moduleName;
            result = 31 * result + (string3 != null ? string3.hashCode() : 0);
            return result;
        }
    }
}

