/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.dynamicfeatures;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.navigation.ActivityNavigator;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.dynamicfeatures.DynamicExtras;
import androidx.navigation.dynamicfeatures.DynamicInstallManager;
import androidx.navigation.dynamicfeatures.R;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Navigator.Name(value="activity")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J*\u0010\r\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Landroidx/navigation/dynamicfeatures/DynamicActivityNavigator;", "Landroidx/navigation/ActivityNavigator;", "context", "Landroid/content/Context;", "installManager", "Landroidx/navigation/dynamicfeatures/DynamicInstallManager;", "(Landroid/content/Context;Landroidx/navigation/dynamicfeatures/DynamicInstallManager;)V", "packageName", "", "getPackageName$navigation_dynamic_features_runtime_release", "()Ljava/lang/String;", "createDestination", "Landroidx/navigation/dynamicfeatures/DynamicActivityNavigator$Destination;", "navigate", "", "entry", "Landroidx/navigation/NavBackStackEntry;", "navOptions", "Landroidx/navigation/NavOptions;", "navigatorExtras", "Landroidx/navigation/Navigator$Extras;", "entries", "", "Destination", "navigation-dynamic-features-runtime_release"})
public final class DynamicActivityNavigator
extends ActivityNavigator {
    @NotNull
    private final DynamicInstallManager installManager;
    @NotNull
    private final String packageName;

    public DynamicActivityNavigator(@NotNull Context context, @NotNull DynamicInstallManager installManager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)installManager, (String)"installManager");
        super(context);
        this.installManager = installManager;
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        this.packageName = string;
    }

    @NotNull
    public final String getPackageName$navigation_dynamic_features_runtime_release() {
        return this.packageName;
    }

    public void navigate(@NotNull List<NavBackStackEntry> entries, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        for (NavBackStackEntry entry : entries) {
            this.navigate(entry, navOptions, navigatorExtras);
        }
    }

    private final void navigate(NavBackStackEntry entry, NavOptions navOptions, Navigator.Extras navigatorExtras) {
        String moduleName;
        DynamicExtras extras;
        NavDestination destination = entry.getDestination();
        DynamicExtras dynamicExtras = extras = navigatorExtras instanceof DynamicExtras ? (DynamicExtras)navigatorExtras : null;
        if (destination instanceof Destination && (moduleName = ((Destination)destination).getModuleName()) != null && this.installManager.needsInstall(moduleName)) {
            this.installManager.performInstall(entry, extras, moduleName);
            return;
        }
        DynamicExtras dynamicExtras2 = extras;
        super.navigate(CollectionsKt.listOf((Object)entry), navOptions, dynamicExtras2 != null ? dynamicExtras2.getDestinationExtras() : navigatorExtras);
    }

    @NotNull
    public Destination createDestination() {
        return new Destination((Navigator<? extends ActivityNavigator.Destination>)((Navigator)this));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Landroidx/navigation/dynamicfeatures/DynamicActivityNavigator$Destination;", "Landroidx/navigation/ActivityNavigator$Destination;", "navigatorProvider", "Landroidx/navigation/NavigatorProvider;", "(Landroidx/navigation/NavigatorProvider;)V", "activityNavigator", "Landroidx/navigation/Navigator;", "(Landroidx/navigation/Navigator;)V", "moduleName", "", "getModuleName", "()Ljava/lang/String;", "setModuleName", "(Ljava/lang/String;)V", "equals", "", "other", "", "hashCode", "", "onInflate", "", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "navigation-dynamic-features-runtime_release"})
    public static final class Destination
    extends ActivityNavigator.Destination {
        @Nullable
        private String moduleName;

        @Nullable
        public final String getModuleName() {
            return this.moduleName;
        }

        public final void setModuleName(@Nullable String string) {
            this.moduleName = string;
        }

        public Destination(@NotNull NavigatorProvider navigatorProvider) {
            Intrinsics.checkNotNullParameter((Object)navigatorProvider, (String)"navigatorProvider");
            super(navigatorProvider);
        }

        public Destination(@NotNull Navigator<? extends ActivityNavigator.Destination> activityNavigator) {
            Intrinsics.checkNotNullParameter(activityNavigator, (String)"activityNavigator");
            super(activityNavigator);
        }

        /*
         * WARNING - void declaration
         */
        public void onInflate(@NotNull Context context, @NotNull AttributeSet attrs) {
            void $this$withStyledAttributes$iv;
            TypedArray typedArray;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
            super.onInflate(context, attrs);
            Context context2 = context;
            Intrinsics.checkNotNullExpressionValue((Object)R.styleable.DynamicActivityNavigator, (String)"DynamicActivityNavigator");
            int[] attrs$iv = R.styleable.DynamicActivityNavigator;
            int defStyleAttr$iv = 0;
            int defStyleRes$iv = 0;
            boolean $i$f$withStyledAttributes = false;
            TypedArray $this$onInflate_u24lambda_u2d0 = typedArray = $this$withStyledAttributes$iv.obtainStyledAttributes(attrs, attrs$iv, defStyleAttr$iv, defStyleRes$iv);
            boolean bl = false;
            this.moduleName = $this$onInflate_u24lambda_u2d0.getString(R.styleable.DynamicActivityNavigator_moduleName);
            typedArray.recycle();
        }

        public boolean equals(@Nullable Object other) {
            if (other == null || !(other instanceof Destination)) {
                return false;
            }
            return super.equals(other) && Intrinsics.areEqual((Object)this.moduleName, (Object)((Destination)((Object)other)).moduleName);
        }

        public int hashCode() {
            int result = super.hashCode();
            String string = this.moduleName;
            result = 31 * result + (string != null ? string.hashCode() : 0);
            return result;
        }
    }
}

