/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.databinding.tool

import com.google.gson.FieldNamingPolicy
import com.google.gson.GsonBuilder
import com.google.gson.annotations.SerializedName
import java.io.File

/**
 * Information about a feature that is necessary for data binding.
 * It is generated by DataBindingExportFeatureInfoTask
 */
class FeaturePackageInfo(
        @SerializedName("package_id")
        val packageId : Int) {
    companion object {
        private val GSON = GsonBuilder()
                .disableHtmlEscaping()
                .setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES)
                .setPrettyPrinting().create()

        @JvmStatic
        fun fromFile(file: File): FeaturePackageInfo {
            if (!file.exists()) {
                return FeaturePackageInfo(0)
            }
            return file.reader(Charsets.UTF_16).use {
                GSON.fromJson(it, FeaturePackageInfo::class.java)
            }
        }
    }

    fun serialize(file: File) {
        if (file.exists()) {
            file.delete()
        }
        file.writer(Charsets.UTF_16).use {
            GSON.toJson(this, it)
        }
    }
}
