/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.solver.widgets.analyzer;

import androidx.constraintlayout.solver.LinearSystem;
import androidx.constraintlayout.solver.widgets.Chain;
import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import androidx.constraintlayout.solver.widgets.ConstraintWidgetContainer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class WidgetGroup {
    private static final boolean DEBUG = false;
    ArrayList<ConstraintWidget> widgets = new ArrayList();
    static int count = 0;
    int id = count++;
    boolean authoritative = false;
    int orientation = 0;
    ArrayList<MeasureResult> results = null;
    private int moveTo = -1;

    public WidgetGroup(int orientation) {
        this.orientation = orientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getId() {
        return this.id;
    }

    public boolean add(ConstraintWidget widget) {
        if (this.widgets.contains(widget)) {
            return false;
        }
        this.widgets.add(widget);
        return true;
    }

    public void setAuthoritative(boolean isAuthoritative) {
        this.authoritative = isAuthoritative;
    }

    public boolean isAuthoritative() {
        return this.authoritative;
    }

    private String getOrientationString() {
        if (this.orientation == 0) {
            return "Horizontal";
        }
        if (this.orientation == 1) {
            return "Vertical";
        }
        if (this.orientation == 2) {
            return "Both";
        }
        return "Unknown";
    }

    public String toString() {
        String ret = this.getOrientationString() + " [" + this.id + "] <";
        for (ConstraintWidget widget : this.widgets) {
            ret = ret + " " + widget.getDebugName();
        }
        ret = ret + " >";
        return ret;
    }

    public void moveTo(int orientation, WidgetGroup widgetGroup) {
        for (ConstraintWidget widget : this.widgets) {
            widgetGroup.add(widget);
            if (orientation == 0) {
                widget.horizontalGroup = widgetGroup.getId();
                continue;
            }
            widget.verticalGroup = widgetGroup.getId();
        }
        this.moveTo = widgetGroup.id;
    }

    public void clear() {
        this.widgets.clear();
    }

    private int measureWrap(int orientation, ConstraintWidget widget) {
        ConstraintWidget.DimensionBehaviour behaviour = widget.getDimensionBehaviour(orientation);
        if (behaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || behaviour == ConstraintWidget.DimensionBehaviour.MATCH_PARENT || behaviour == ConstraintWidget.DimensionBehaviour.FIXED) {
            int dimension = orientation == 0 ? widget.getWidth() : widget.getHeight();
            return dimension;
        }
        return -1;
    }

    public int measureWrap(LinearSystem system, int orientation) {
        int count = this.widgets.size();
        if (count == 0) {
            return 0;
        }
        return this.solverMeasure(system, this.widgets, orientation);
    }

    private int solverMeasure(LinearSystem system, ArrayList<ConstraintWidget> widgets, int orientation) {
        ConstraintWidget widget;
        ConstraintWidgetContainer container = (ConstraintWidgetContainer)widgets.get(0).getParent();
        system.reset();
        boolean prevDebug = false;
        container.addToSolver(system, false);
        for (int i = 0; i < widgets.size(); ++i) {
            widget = widgets.get(i);
            widget.addToSolver(system, false);
        }
        if (orientation == 0 && container.mHorizontalChainsSize > 0) {
            Chain.applyChainConstraints(container, system, widgets, 0);
        }
        if (orientation == 1 && container.mVerticalChainsSize > 0) {
            Chain.applyChainConstraints(container, system, widgets, 1);
        }
        try {
            system.minimize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.results = new ArrayList();
        for (int i = 0; i < widgets.size(); ++i) {
            widget = widgets.get(i);
            MeasureResult result = new MeasureResult(widget, system, orientation);
            this.results.add(result);
        }
        if (orientation == 0) {
            int left = system.getObjectVariableValue(container.mLeft);
            int right = system.getObjectVariableValue(container.mRight);
            system.reset();
            return right - left;
        }
        int top = system.getObjectVariableValue(container.mTop);
        int bottom = system.getObjectVariableValue(container.mBottom);
        system.reset();
        return bottom - top;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public void apply() {
        if (this.results == null) {
            return;
        }
        if (!this.authoritative) {
            return;
        }
        for (int i = 0; i < this.results.size(); ++i) {
            MeasureResult result = this.results.get(i);
            result.apply();
        }
    }

    public boolean intersectWith(WidgetGroup group) {
        for (int i = 0; i < this.widgets.size(); ++i) {
            ConstraintWidget widget = this.widgets.get(i);
            if (!group.contains(widget)) continue;
            return true;
        }
        return false;
    }

    private boolean contains(ConstraintWidget widget) {
        return this.widgets.contains(widget);
    }

    public int size() {
        return this.widgets.size();
    }

    public void cleanup(ArrayList<WidgetGroup> dependencyLists) {
        int count = this.widgets.size();
        if (this.moveTo != -1 && count > 0) {
            for (int i = 0; i < dependencyLists.size(); ++i) {
                WidgetGroup group = dependencyLists.get(i);
                if (this.moveTo != group.id) continue;
                this.moveTo(this.orientation, group);
            }
        }
        if (count == 0) {
            dependencyLists.remove(this);
            return;
        }
    }

    class MeasureResult {
        WeakReference<ConstraintWidget> widgetRef;
        int left;
        int top;
        int right;
        int bottom;
        int baseline;
        int orientation;

        public MeasureResult(ConstraintWidget widget, LinearSystem system, int orientation) {
            this.widgetRef = new WeakReference<ConstraintWidget>(widget);
            this.left = system.getObjectVariableValue(widget.mLeft);
            this.top = system.getObjectVariableValue(widget.mTop);
            this.right = system.getObjectVariableValue(widget.mRight);
            this.bottom = system.getObjectVariableValue(widget.mBottom);
            this.baseline = system.getObjectVariableValue(widget.mBaseline);
            this.orientation = orientation;
        }

        public void apply() {
            ConstraintWidget widget = (ConstraintWidget)this.widgetRef.get();
            if (widget != null) {
                widget.setFinalFrame(this.left, this.top, this.right, this.bottom, this.baseline, this.orientation);
            }
        }
    }
}

