/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets;

import androidx.constraintlayout.core.Cache;
import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.SolverVariable;
import androidx.constraintlayout.core.state.WidgetFrame;
import androidx.constraintlayout.core.widgets.Barrier;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.Guideline;
import androidx.constraintlayout.core.widgets.Optimizer;
import androidx.constraintlayout.core.widgets.VirtualLayout;
import androidx.constraintlayout.core.widgets.analyzer.ChainRun;
import androidx.constraintlayout.core.widgets.analyzer.HorizontalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class ConstraintWidget {
    private static final boolean AUTOTAG_CENTER = false;
    protected static final int SOLVER = 1;
    protected static final int DIRECT = 2;
    private static final boolean USE_WRAP_DIMENSION_FOR_SPREAD = false;
    public boolean measured = false;
    public WidgetRun[] run = new WidgetRun[2];
    public ChainRun horizontalChainRun;
    public ChainRun verticalChainRun;
    public HorizontalWidgetRun horizontalRun = null;
    public VerticalWidgetRun verticalRun = null;
    public boolean[] isTerminalWidget = new boolean[]{true, true};
    boolean mResolvedHasRatio = false;
    private boolean mMeasureRequested = true;
    private boolean OPTIMIZE_WRAP = false;
    private boolean OPTIMIZE_WRAP_ON_RESOLVED = true;
    private int mWidthOverride = -1;
    private int mHeightOverride = -1;
    public WidgetFrame frame = new WidgetFrame(this);
    public String stringId;
    private boolean resolvedHorizontal = false;
    private boolean resolvedVertical = false;
    private boolean horizontalSolvingPass = false;
    private boolean verticalSolvingPass = false;
    public static final int MATCH_CONSTRAINT_SPREAD = 0;
    public static final int MATCH_CONSTRAINT_WRAP = 1;
    public static final int MATCH_CONSTRAINT_PERCENT = 2;
    public static final int MATCH_CONSTRAINT_RATIO = 3;
    public static final int MATCH_CONSTRAINT_RATIO_RESOLVED = 4;
    public static final int UNKNOWN = -1;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int BOTH = 2;
    public static final int VISIBLE = 0;
    public static final int INVISIBLE = 4;
    public static final int GONE = 8;
    public static final int CHAIN_SPREAD = 0;
    public static final int CHAIN_SPREAD_INSIDE = 1;
    public static final int CHAIN_PACKED = 2;
    public static final int WRAP_BEHAVIOR_INCLUDED = 0;
    public static final int WRAP_BEHAVIOR_HORIZONTAL_ONLY = 1;
    public static final int WRAP_BEHAVIOR_VERTICAL_ONLY = 2;
    public static final int WRAP_BEHAVIOR_SKIPPED = 3;
    public int mHorizontalResolution = -1;
    public int mVerticalResolution = -1;
    private static final int WRAP = -2;
    private int mWrapBehaviorInParent = 0;
    public int mMatchConstraintDefaultWidth = 0;
    public int mMatchConstraintDefaultHeight = 0;
    public int[] mResolvedMatchConstraintDefault = new int[2];
    public int mMatchConstraintMinWidth = 0;
    public int mMatchConstraintMaxWidth = 0;
    public float mMatchConstraintPercentWidth = 1.0f;
    public int mMatchConstraintMinHeight = 0;
    public int mMatchConstraintMaxHeight = 0;
    public float mMatchConstraintPercentHeight = 1.0f;
    public boolean mIsWidthWrapContent;
    public boolean mIsHeightWrapContent;
    int mResolvedDimensionRatioSide = -1;
    float mResolvedDimensionRatio = 1.0f;
    private int[] mMaxDimension = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};
    private float mCircleConstraintAngle = 0.0f;
    private boolean hasBaseline = false;
    private boolean inPlaceholder;
    private boolean mInVirtualLayout = false;
    private int mLastHorizontalMeasureSpec = 0;
    private int mLastVerticalMeasureSpec = 0;
    public ConstraintAnchor mLeft = new ConstraintAnchor(this, ConstraintAnchor.Type.LEFT);
    public ConstraintAnchor mTop = new ConstraintAnchor(this, ConstraintAnchor.Type.TOP);
    public ConstraintAnchor mRight = new ConstraintAnchor(this, ConstraintAnchor.Type.RIGHT);
    public ConstraintAnchor mBottom = new ConstraintAnchor(this, ConstraintAnchor.Type.BOTTOM);
    public ConstraintAnchor mBaseline = new ConstraintAnchor(this, ConstraintAnchor.Type.BASELINE);
    ConstraintAnchor mCenterX = new ConstraintAnchor(this, ConstraintAnchor.Type.CENTER_X);
    ConstraintAnchor mCenterY = new ConstraintAnchor(this, ConstraintAnchor.Type.CENTER_Y);
    public ConstraintAnchor mCenter = new ConstraintAnchor(this, ConstraintAnchor.Type.CENTER);
    public static final int ANCHOR_LEFT = 0;
    public static final int ANCHOR_RIGHT = 1;
    public static final int ANCHOR_TOP = 2;
    public static final int ANCHOR_BOTTOM = 3;
    public static final int ANCHOR_BASELINE = 4;
    public ConstraintAnchor[] mListAnchors = new ConstraintAnchor[]{this.mLeft, this.mRight, this.mTop, this.mBottom, this.mBaseline, this.mCenter};
    protected ArrayList<ConstraintAnchor> mAnchors = new ArrayList();
    private boolean[] mIsInBarrier = new boolean[2];
    static final int DIMENSION_HORIZONTAL = 0;
    static final int DIMENSION_VERTICAL = 1;
    public DimensionBehaviour[] mListDimensionBehaviors = new DimensionBehaviour[]{DimensionBehaviour.FIXED, DimensionBehaviour.FIXED};
    public ConstraintWidget mParent = null;
    int mWidth = 0;
    int mHeight = 0;
    public float mDimensionRatio = 0.0f;
    protected int mDimensionRatioSide = -1;
    protected int mX = 0;
    protected int mY = 0;
    int mRelX = 0;
    int mRelY = 0;
    protected int mOffsetX = 0;
    protected int mOffsetY = 0;
    int mBaselineDistance = 0;
    protected int mMinWidth;
    protected int mMinHeight;
    public static float DEFAULT_BIAS = 0.5f;
    float mHorizontalBiasPercent = DEFAULT_BIAS;
    float mVerticalBiasPercent = DEFAULT_BIAS;
    private Object mCompanionWidget;
    private int mContainerItemSkip = 0;
    private int mVisibility = 0;
    private String mDebugName = null;
    private String mType = null;
    int mDistToTop;
    int mDistToLeft;
    int mDistToRight;
    int mDistToBottom;
    boolean mLeftHasCentered;
    boolean mRightHasCentered;
    boolean mTopHasCentered;
    boolean mBottomHasCentered;
    boolean mHorizontalWrapVisited;
    boolean mVerticalWrapVisited;
    boolean mGroupsToSolver = false;
    int mHorizontalChainStyle = 0;
    int mVerticalChainStyle = 0;
    boolean mHorizontalChainFixedPosition;
    boolean mVerticalChainFixedPosition;
    public float[] mWeight = new float[]{-1.0f, -1.0f};
    protected ConstraintWidget[] mListNextMatchConstraintsWidget = new ConstraintWidget[]{null, null};
    protected ConstraintWidget[] mNextChainWidget = new ConstraintWidget[]{null, null};
    ConstraintWidget mHorizontalNextWidget = null;
    ConstraintWidget mVerticalNextWidget = null;
    public int horizontalGroup = -1;
    public int verticalGroup = -1;

    public WidgetRun getRun(int orientation) {
        if (orientation == 0) {
            return this.horizontalRun;
        }
        if (orientation == 1) {
            return this.verticalRun;
        }
        return null;
    }

    public void setFinalFrame(int left, int top, int right, int bottom, int baseline, int orientation) {
        this.setFrame(left, top, right, bottom);
        this.setBaselineDistance(baseline);
        if (orientation == 0) {
            this.resolvedHorizontal = true;
            this.resolvedVertical = false;
        } else if (orientation == 1) {
            this.resolvedHorizontal = false;
            this.resolvedVertical = true;
        } else if (orientation == 2) {
            this.resolvedHorizontal = true;
            this.resolvedVertical = true;
        } else {
            this.resolvedHorizontal = false;
            this.resolvedVertical = false;
        }
    }

    public void setFinalLeft(int x1) {
        this.mLeft.setFinalValue(x1);
        this.mX = x1;
    }

    public void setFinalTop(int y1) {
        this.mTop.setFinalValue(y1);
        this.mY = y1;
    }

    public void resetSolvingPassFlag() {
        this.horizontalSolvingPass = false;
        this.verticalSolvingPass = false;
    }

    public boolean isHorizontalSolvingPassDone() {
        return this.horizontalSolvingPass;
    }

    public boolean isVerticalSolvingPassDone() {
        return this.verticalSolvingPass;
    }

    public void markHorizontalSolvingPassDone() {
        this.horizontalSolvingPass = true;
    }

    public void markVerticalSolvingPassDone() {
        this.verticalSolvingPass = true;
    }

    public void setFinalHorizontal(int x1, int x2) {
        if (this.resolvedHorizontal) {
            return;
        }
        this.mLeft.setFinalValue(x1);
        this.mRight.setFinalValue(x2);
        this.mX = x1;
        this.mWidth = x2 - x1;
        this.resolvedHorizontal = true;
    }

    public void setFinalVertical(int y1, int y2) {
        if (this.resolvedVertical) {
            return;
        }
        this.mTop.setFinalValue(y1);
        this.mBottom.setFinalValue(y2);
        this.mY = y1;
        this.mHeight = y2 - y1;
        if (this.hasBaseline) {
            this.mBaseline.setFinalValue(y1 + this.mBaselineDistance);
        }
        this.resolvedVertical = true;
    }

    public void setFinalBaseline(int baselineValue) {
        if (!this.hasBaseline) {
            return;
        }
        int y1 = baselineValue - this.mBaselineDistance;
        int y2 = y1 + this.mHeight;
        this.mY = y1;
        this.mTop.setFinalValue(y1);
        this.mBottom.setFinalValue(y2);
        this.mBaseline.setFinalValue(baselineValue);
        this.resolvedVertical = true;
    }

    public boolean isResolvedHorizontally() {
        return this.resolvedHorizontal || this.mLeft.hasFinalValue() && this.mRight.hasFinalValue();
    }

    public boolean isResolvedVertically() {
        return this.resolvedVertical || this.mTop.hasFinalValue() && this.mBottom.hasFinalValue();
    }

    public void resetFinalResolution() {
        this.resolvedHorizontal = false;
        this.resolvedVertical = false;
        this.horizontalSolvingPass = false;
        this.verticalSolvingPass = false;
        int mAnchorsSize = this.mAnchors.size();
        for (int i = 0; i < mAnchorsSize; ++i) {
            ConstraintAnchor anchor = this.mAnchors.get(i);
            anchor.resetFinalResolution();
        }
    }

    public void ensureMeasureRequested() {
        this.mMeasureRequested = true;
    }

    public boolean hasDependencies() {
        int mAnchorsSize = this.mAnchors.size();
        for (int i = 0; i < mAnchorsSize; ++i) {
            ConstraintAnchor anchor = this.mAnchors.get(i);
            if (!anchor.hasDependents()) continue;
            return true;
        }
        return false;
    }

    public boolean hasDanglingDimension(int orientation) {
        if (orientation == 0) {
            int horizontalTargets = (this.mLeft.mTarget != null ? 1 : 0) + (this.mRight.mTarget != null ? 1 : 0);
            return horizontalTargets < 2;
        }
        int verticalTargets = (this.mTop.mTarget != null ? 1 : 0) + (this.mBottom.mTarget != null ? 1 : 0) + (this.mBaseline.mTarget != null ? 1 : 0);
        return verticalTargets < 2;
    }

    public boolean hasResolvedTargets(int orientation, int size) {
        if (orientation == 0) {
            if (this.mLeft.mTarget != null && this.mLeft.mTarget.hasFinalValue() && this.mRight.mTarget != null && this.mRight.mTarget.hasFinalValue()) {
                return this.mRight.mTarget.getFinalValue() - this.mRight.getMargin() - (this.mLeft.mTarget.getFinalValue() + this.mLeft.getMargin()) >= size;
            }
        } else if (this.mTop.mTarget != null && this.mTop.mTarget.hasFinalValue() && this.mBottom.mTarget != null && this.mBottom.mTarget.hasFinalValue()) {
            return this.mBottom.mTarget.getFinalValue() - this.mBottom.getMargin() - (this.mTop.mTarget.getFinalValue() + this.mTop.getMargin()) >= size;
        }
        return false;
    }

    public boolean isInVirtualLayout() {
        return this.mInVirtualLayout;
    }

    public void setInVirtualLayout(boolean inVirtualLayout) {
        this.mInVirtualLayout = inVirtualLayout;
    }

    public int getMaxHeight() {
        return this.mMaxDimension[1];
    }

    public int getMaxWidth() {
        return this.mMaxDimension[0];
    }

    public void setMaxWidth(int maxWidth) {
        this.mMaxDimension[0] = maxWidth;
    }

    public void setMaxHeight(int maxHeight) {
        this.mMaxDimension[1] = maxHeight;
    }

    public boolean isSpreadWidth() {
        return this.mMatchConstraintDefaultWidth == 0 && this.mDimensionRatio == 0.0f && this.mMatchConstraintMinWidth == 0 && this.mMatchConstraintMaxWidth == 0 && this.mListDimensionBehaviors[0] == DimensionBehaviour.MATCH_CONSTRAINT;
    }

    public boolean isSpreadHeight() {
        return this.mMatchConstraintDefaultHeight == 0 && this.mDimensionRatio == 0.0f && this.mMatchConstraintMinHeight == 0 && this.mMatchConstraintMaxHeight == 0 && this.mListDimensionBehaviors[1] == DimensionBehaviour.MATCH_CONSTRAINT;
    }

    public void setHasBaseline(boolean hasBaseline) {
        this.hasBaseline = hasBaseline;
    }

    public boolean getHasBaseline() {
        return this.hasBaseline;
    }

    public boolean isInPlaceholder() {
        return this.inPlaceholder;
    }

    public void setInPlaceholder(boolean inPlaceholder) {
        this.inPlaceholder = inPlaceholder;
    }

    protected void setInBarrier(int orientation, boolean value) {
        this.mIsInBarrier[orientation] = value;
    }

    public boolean isInBarrier(int orientation) {
        return this.mIsInBarrier[orientation];
    }

    public void setMeasureRequested(boolean measureRequested) {
        this.mMeasureRequested = measureRequested;
    }

    public boolean isMeasureRequested() {
        return this.mMeasureRequested && this.mVisibility != 8;
    }

    public void setWrapBehaviorInParent(int behavior) {
        if (behavior >= 0 && behavior <= 3) {
            this.mWrapBehaviorInParent = behavior;
        }
    }

    public int getWrapBehaviorInParent() {
        return this.mWrapBehaviorInParent;
    }

    public int getLastHorizontalMeasureSpec() {
        return this.mLastHorizontalMeasureSpec;
    }

    public int getLastVerticalMeasureSpec() {
        return this.mLastVerticalMeasureSpec;
    }

    public void setLastMeasureSpec(int horizontal, int vertical) {
        this.mLastHorizontalMeasureSpec = horizontal;
        this.mLastVerticalMeasureSpec = vertical;
        this.setMeasureRequested(false);
    }

    public void reset() {
        this.mLeft.reset();
        this.mTop.reset();
        this.mRight.reset();
        this.mBottom.reset();
        this.mBaseline.reset();
        this.mCenterX.reset();
        this.mCenterY.reset();
        this.mCenter.reset();
        this.mParent = null;
        this.mCircleConstraintAngle = 0.0f;
        this.mWidth = 0;
        this.mHeight = 0;
        this.mDimensionRatio = 0.0f;
        this.mDimensionRatioSide = -1;
        this.mX = 0;
        this.mY = 0;
        this.mOffsetX = 0;
        this.mOffsetY = 0;
        this.mBaselineDistance = 0;
        this.mMinWidth = 0;
        this.mMinHeight = 0;
        this.mHorizontalBiasPercent = DEFAULT_BIAS;
        this.mVerticalBiasPercent = DEFAULT_BIAS;
        this.mListDimensionBehaviors[0] = DimensionBehaviour.FIXED;
        this.mListDimensionBehaviors[1] = DimensionBehaviour.FIXED;
        this.mCompanionWidget = null;
        this.mContainerItemSkip = 0;
        this.mVisibility = 0;
        this.mType = null;
        this.mHorizontalWrapVisited = false;
        this.mVerticalWrapVisited = false;
        this.mHorizontalChainStyle = 0;
        this.mVerticalChainStyle = 0;
        this.mHorizontalChainFixedPosition = false;
        this.mVerticalChainFixedPosition = false;
        this.mWeight[0] = -1.0f;
        this.mWeight[1] = -1.0f;
        this.mHorizontalResolution = -1;
        this.mVerticalResolution = -1;
        this.mMaxDimension[0] = Integer.MAX_VALUE;
        this.mMaxDimension[1] = Integer.MAX_VALUE;
        this.mMatchConstraintDefaultWidth = 0;
        this.mMatchConstraintDefaultHeight = 0;
        this.mMatchConstraintPercentWidth = 1.0f;
        this.mMatchConstraintPercentHeight = 1.0f;
        this.mMatchConstraintMaxWidth = Integer.MAX_VALUE;
        this.mMatchConstraintMaxHeight = Integer.MAX_VALUE;
        this.mMatchConstraintMinWidth = 0;
        this.mMatchConstraintMinHeight = 0;
        this.mResolvedHasRatio = false;
        this.mResolvedDimensionRatioSide = -1;
        this.mResolvedDimensionRatio = 1.0f;
        this.mGroupsToSolver = false;
        this.isTerminalWidget[0] = true;
        this.isTerminalWidget[1] = true;
        this.mInVirtualLayout = false;
        this.mIsInBarrier[0] = false;
        this.mIsInBarrier[1] = false;
        this.mMeasureRequested = true;
        this.mResolvedMatchConstraintDefault[0] = 0;
        this.mResolvedMatchConstraintDefault[1] = 0;
        this.mWidthOverride = -1;
        this.mHeightOverride = -1;
    }

    private void serializeAnchor(StringBuilder ret, String side, ConstraintAnchor a) {
        if (a.mTarget == null) {
            return;
        }
        ret.append(side);
        ret.append(" : [ '");
        ret.append(a.mTarget);
        ret.append("',");
        ret.append(a.mMargin);
        ret.append(",");
        ret.append(a.mGoneMargin);
        ret.append(",");
        ret.append(" ] ,\n");
    }

    private void serializeCircle(StringBuilder ret, ConstraintAnchor a, float angle) {
        if (a.mTarget == null) {
            return;
        }
        ret.append("circle : [ '");
        ret.append(a.mTarget);
        ret.append("',");
        ret.append(a.mMargin);
        ret.append(",");
        ret.append(angle);
        ret.append(",");
        ret.append(" ] ,\n");
    }

    private void serializeAttribute(StringBuilder ret, String type, float value, float def) {
        if (value == def) {
            return;
        }
        ret.append(type);
        ret.append(" :   ");
        ret.append(def);
        ret.append(",\n");
    }

    private void serializeDimensionRatio(StringBuilder ret, String type, float value, int whichSide) {
        if (value == 0.0f) {
            return;
        }
        ret.append(type);
        ret.append(" :  [");
        ret.append(value);
        ret.append(",");
        ret.append(whichSide);
        ret.append("");
        ret.append("],\n");
    }

    private void serializeSize(StringBuilder ret, String type, int size, int min, int max, int override, int matchConstraintMin, int matchConstraintDefault, float MatchConstraintPercent, float weight) {
        ret.append(type);
        ret.append(" :  {\n");
        this.serializeAttribute(ret, "size", size, -2.1474836E9f);
        this.serializeAttribute(ret, "min", min, 0.0f);
        this.serializeAttribute(ret, "max", max, 2.1474836E9f);
        this.serializeAttribute(ret, "matchMin", matchConstraintMin, 0.0f);
        this.serializeAttribute(ret, "matchDef", matchConstraintDefault, 0.0f);
        this.serializeAttribute(ret, "matchPercent", matchConstraintDefault, 1.0f);
        ret.append("},\n");
    }

    public StringBuilder serialize(StringBuilder ret) {
        ret.append("{\n");
        this.serializeAnchor(ret, "left", this.mLeft);
        this.serializeAnchor(ret, "top", this.mTop);
        this.serializeAnchor(ret, "right", this.mRight);
        this.serializeAnchor(ret, "bottom", this.mBottom);
        this.serializeAnchor(ret, "baseline", this.mBaseline);
        this.serializeAnchor(ret, "centerX", this.mCenterX);
        this.serializeAnchor(ret, "centerY", this.mCenterY);
        this.serializeCircle(ret, this.mCenter, this.mCircleConstraintAngle);
        this.serializeSize(ret, "width", this.mWidth, this.mMinWidth, this.mMaxDimension[0], this.mWidthOverride, this.mMatchConstraintMinWidth, this.mMatchConstraintDefaultWidth, this.mMatchConstraintPercentWidth, this.mWeight[0]);
        this.serializeSize(ret, "height", this.mHeight, this.mMinHeight, this.mMaxDimension[1], this.mHeightOverride, this.mMatchConstraintMinHeight, this.mMatchConstraintDefaultHeight, this.mMatchConstraintPercentHeight, this.mWeight[1]);
        this.serializeDimensionRatio(ret, "dimensionRatio", this.mDimensionRatio, this.mDimensionRatioSide);
        this.serializeAttribute(ret, "horizontalBias", this.mHorizontalBiasPercent, DEFAULT_BIAS);
        this.serializeAttribute(ret, "verticalBias", this.mVerticalBiasPercent, DEFAULT_BIAS);
        ret.append("}\n");
        return ret;
    }

    public boolean oppositeDimensionDependsOn(int orientation) {
        int oppositeOrientation = orientation == 0 ? 1 : 0;
        DimensionBehaviour dimensionBehaviour = this.mListDimensionBehaviors[orientation];
        DimensionBehaviour oppositeDimensionBehaviour = this.mListDimensionBehaviors[oppositeOrientation];
        return dimensionBehaviour == DimensionBehaviour.MATCH_CONSTRAINT && oppositeDimensionBehaviour == DimensionBehaviour.MATCH_CONSTRAINT;
    }

    public boolean oppositeDimensionsTied() {
        return this.mListDimensionBehaviors[0] == DimensionBehaviour.MATCH_CONSTRAINT && this.mListDimensionBehaviors[1] == DimensionBehaviour.MATCH_CONSTRAINT;
    }

    public boolean hasDimensionOverride() {
        return this.mWidthOverride != -1 || this.mHeightOverride != -1;
    }

    public ConstraintWidget() {
        this.addAnchors();
    }

    public ConstraintWidget(String debugName) {
        this.addAnchors();
        this.setDebugName(debugName);
    }

    public ConstraintWidget(int x, int y, int width, int height) {
        this.mX = x;
        this.mY = y;
        this.mWidth = width;
        this.mHeight = height;
        this.addAnchors();
    }

    public ConstraintWidget(String debugName, int x, int y, int width, int height) {
        this(x, y, width, height);
        this.setDebugName(debugName);
    }

    public ConstraintWidget(int width, int height) {
        this(0, 0, width, height);
    }

    public void ensureWidgetRuns() {
        if (this.horizontalRun == null) {
            this.horizontalRun = new HorizontalWidgetRun(this);
        }
        if (this.verticalRun == null) {
            this.verticalRun = new VerticalWidgetRun(this);
        }
    }

    public ConstraintWidget(String debugName, int width, int height) {
        this(width, height);
        this.setDebugName(debugName);
    }

    public void resetSolverVariables(Cache cache) {
        this.mLeft.resetSolverVariable(cache);
        this.mTop.resetSolverVariable(cache);
        this.mRight.resetSolverVariable(cache);
        this.mBottom.resetSolverVariable(cache);
        this.mBaseline.resetSolverVariable(cache);
        this.mCenter.resetSolverVariable(cache);
        this.mCenterX.resetSolverVariable(cache);
        this.mCenterY.resetSolverVariable(cache);
    }

    private void addAnchors() {
        this.mAnchors.add(this.mLeft);
        this.mAnchors.add(this.mTop);
        this.mAnchors.add(this.mRight);
        this.mAnchors.add(this.mBottom);
        this.mAnchors.add(this.mCenterX);
        this.mAnchors.add(this.mCenterY);
        this.mAnchors.add(this.mCenter);
        this.mAnchors.add(this.mBaseline);
    }

    public boolean isRoot() {
        return this.mParent == null;
    }

    public ConstraintWidget getParent() {
        return this.mParent;
    }

    public void setParent(ConstraintWidget widget) {
        this.mParent = widget;
    }

    public void setWidthWrapContent(boolean widthWrapContent) {
        this.mIsWidthWrapContent = widthWrapContent;
    }

    public boolean isWidthWrapContent() {
        return this.mIsWidthWrapContent;
    }

    public void setHeightWrapContent(boolean heightWrapContent) {
        this.mIsHeightWrapContent = heightWrapContent;
    }

    public boolean isHeightWrapContent() {
        return this.mIsHeightWrapContent;
    }

    public void connectCircularConstraint(ConstraintWidget target, float angle, int radius) {
        this.immediateConnect(ConstraintAnchor.Type.CENTER, target, ConstraintAnchor.Type.CENTER, radius, 0);
        this.mCircleConstraintAngle = angle;
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public void setVisibility(int visibility) {
        this.mVisibility = visibility;
    }

    public int getVisibility() {
        return this.mVisibility;
    }

    public String getDebugName() {
        return this.mDebugName;
    }

    public void setDebugName(String name) {
        this.mDebugName = name;
    }

    public void setDebugSolverName(LinearSystem system, String name) {
        this.mDebugName = name;
        SolverVariable left = system.createObjectVariable(this.mLeft);
        SolverVariable top = system.createObjectVariable(this.mTop);
        SolverVariable right = system.createObjectVariable(this.mRight);
        SolverVariable bottom = system.createObjectVariable(this.mBottom);
        left.setName(name + ".left");
        top.setName(name + ".top");
        right.setName(name + ".right");
        bottom.setName(name + ".bottom");
        SolverVariable baseline = system.createObjectVariable(this.mBaseline);
        baseline.setName(name + ".baseline");
    }

    public void createObjectVariables(LinearSystem system) {
        SolverVariable left = system.createObjectVariable(this.mLeft);
        SolverVariable top = system.createObjectVariable(this.mTop);
        SolverVariable right = system.createObjectVariable(this.mRight);
        SolverVariable bottom = system.createObjectVariable(this.mBottom);
        if (this.mBaselineDistance > 0) {
            SolverVariable solverVariable = system.createObjectVariable(this.mBaseline);
        }
    }

    public String toString() {
        return (this.mType != null ? "type: " + this.mType + " " : "") + (this.mDebugName != null ? "id: " + this.mDebugName + " " : "") + "(" + this.mX + ", " + this.mY + ") - (" + this.mWidth + " x " + this.mHeight + ")";
    }

    public int getX() {
        if (this.mParent != null && this.mParent instanceof ConstraintWidgetContainer) {
            return ((ConstraintWidgetContainer)this.mParent).mPaddingLeft + this.mX;
        }
        return this.mX;
    }

    public int getY() {
        if (this.mParent != null && this.mParent instanceof ConstraintWidgetContainer) {
            return ((ConstraintWidgetContainer)this.mParent).mPaddingTop + this.mY;
        }
        return this.mY;
    }

    public int getWidth() {
        if (this.mVisibility == 8) {
            return 0;
        }
        return this.mWidth;
    }

    public int getOptimizerWrapWidth() {
        int w = this.mWidth;
        if (this.mListDimensionBehaviors[0] == DimensionBehaviour.MATCH_CONSTRAINT) {
            if (this.mMatchConstraintDefaultWidth == 1) {
                w = Math.max(this.mMatchConstraintMinWidth, w);
            } else if (this.mMatchConstraintMinWidth > 0) {
                this.mWidth = w = this.mMatchConstraintMinWidth;
            } else {
                w = 0;
            }
            if (this.mMatchConstraintMaxWidth > 0 && this.mMatchConstraintMaxWidth < w) {
                w = this.mMatchConstraintMaxWidth;
            }
        }
        return w;
    }

    public int getOptimizerWrapHeight() {
        int h = this.mHeight;
        if (this.mListDimensionBehaviors[1] == DimensionBehaviour.MATCH_CONSTRAINT) {
            if (this.mMatchConstraintDefaultHeight == 1) {
                h = Math.max(this.mMatchConstraintMinHeight, h);
            } else if (this.mMatchConstraintMinHeight > 0) {
                this.mHeight = h = this.mMatchConstraintMinHeight;
            } else {
                h = 0;
            }
            if (this.mMatchConstraintMaxHeight > 0 && this.mMatchConstraintMaxHeight < h) {
                h = this.mMatchConstraintMaxHeight;
            }
        }
        return h;
    }

    public int getHeight() {
        if (this.mVisibility == 8) {
            return 0;
        }
        return this.mHeight;
    }

    public int getLength(int orientation) {
        if (orientation == 0) {
            return this.getWidth();
        }
        if (orientation == 1) {
            return this.getHeight();
        }
        return 0;
    }

    protected int getRootX() {
        return this.mX + this.mOffsetX;
    }

    protected int getRootY() {
        return this.mY + this.mOffsetY;
    }

    public int getMinWidth() {
        return this.mMinWidth;
    }

    public int getMinHeight() {
        return this.mMinHeight;
    }

    public int getLeft() {
        return this.getX();
    }

    public int getTop() {
        return this.getY();
    }

    public int getRight() {
        return this.getX() + this.mWidth;
    }

    public int getBottom() {
        return this.getY() + this.mHeight;
    }

    public int getHorizontalMargin() {
        int margin = 0;
        if (this.mLeft != null) {
            margin += this.mLeft.mMargin;
        }
        if (this.mRight != null) {
            margin += this.mRight.mMargin;
        }
        return margin;
    }

    public int getVerticalMargin() {
        int margin = 0;
        if (this.mLeft != null) {
            margin += this.mTop.mMargin;
        }
        if (this.mRight != null) {
            margin += this.mBottom.mMargin;
        }
        return margin;
    }

    public float getHorizontalBiasPercent() {
        return this.mHorizontalBiasPercent;
    }

    public float getVerticalBiasPercent() {
        return this.mVerticalBiasPercent;
    }

    public float getBiasPercent(int orientation) {
        if (orientation == 0) {
            return this.mHorizontalBiasPercent;
        }
        if (orientation == 1) {
            return this.mVerticalBiasPercent;
        }
        return -1.0f;
    }

    public boolean hasBaseline() {
        return this.hasBaseline;
    }

    public int getBaselineDistance() {
        return this.mBaselineDistance;
    }

    public Object getCompanionWidget() {
        return this.mCompanionWidget;
    }

    public ArrayList<ConstraintAnchor> getAnchors() {
        return this.mAnchors;
    }

    public void setX(int x) {
        this.mX = x;
    }

    public void setY(int y) {
        this.mY = y;
    }

    public void setOrigin(int x, int y) {
        this.mX = x;
        this.mY = y;
    }

    public void setOffset(int x, int y) {
        this.mOffsetX = x;
        this.mOffsetY = y;
    }

    public void setGoneMargin(ConstraintAnchor.Type type, int goneMargin) {
        switch (type) {
            case LEFT: {
                this.mLeft.mGoneMargin = goneMargin;
                break;
            }
            case TOP: {
                this.mTop.mGoneMargin = goneMargin;
                break;
            }
            case RIGHT: {
                this.mRight.mGoneMargin = goneMargin;
                break;
            }
            case BOTTOM: {
                this.mBottom.mGoneMargin = goneMargin;
                break;
            }
            case BASELINE: {
                this.mBaseline.mGoneMargin = goneMargin;
                break;
            }
        }
    }

    public void setWidth(int w) {
        this.mWidth = w;
        if (this.mWidth < this.mMinWidth) {
            this.mWidth = this.mMinWidth;
        }
    }

    public void setHeight(int h) {
        this.mHeight = h;
        if (this.mHeight < this.mMinHeight) {
            this.mHeight = this.mMinHeight;
        }
    }

    public void setLength(int length, int orientation) {
        if (orientation == 0) {
            this.setWidth(length);
        } else if (orientation == 1) {
            this.setHeight(length);
        }
    }

    public void setHorizontalMatchStyle(int horizontalMatchStyle, int min, int max, float percent) {
        this.mMatchConstraintDefaultWidth = horizontalMatchStyle;
        this.mMatchConstraintMinWidth = min;
        this.mMatchConstraintMaxWidth = max == Integer.MAX_VALUE ? 0 : max;
        this.mMatchConstraintPercentWidth = percent;
        if (percent > 0.0f && percent < 1.0f && this.mMatchConstraintDefaultWidth == 0) {
            this.mMatchConstraintDefaultWidth = 2;
        }
    }

    public void setVerticalMatchStyle(int verticalMatchStyle, int min, int max, float percent) {
        this.mMatchConstraintDefaultHeight = verticalMatchStyle;
        this.mMatchConstraintMinHeight = min;
        this.mMatchConstraintMaxHeight = max == Integer.MAX_VALUE ? 0 : max;
        this.mMatchConstraintPercentHeight = percent;
        if (percent > 0.0f && percent < 1.0f && this.mMatchConstraintDefaultHeight == 0) {
            this.mMatchConstraintDefaultHeight = 2;
        }
    }

    public void setDimensionRatio(String ratio) {
        float dimensionRatio;
        int dimensionRatioSide;
        block16: {
            if (ratio == null || ratio.length() == 0) {
                this.mDimensionRatio = 0.0f;
                return;
            }
            dimensionRatioSide = -1;
            dimensionRatio = 0.0f;
            int len = ratio.length();
            int commaIndex = ratio.indexOf(44);
            if (commaIndex > 0 && commaIndex < len - 1) {
                String dimension = ratio.substring(0, commaIndex);
                if (dimension.equalsIgnoreCase("W")) {
                    dimensionRatioSide = 0;
                } else if (dimension.equalsIgnoreCase("H")) {
                    dimensionRatioSide = 1;
                }
                ++commaIndex;
            } else {
                commaIndex = 0;
            }
            int colonIndex = ratio.indexOf(58);
            if (colonIndex >= 0 && colonIndex < len - 1) {
                String nominator = ratio.substring(commaIndex, colonIndex);
                String denominator = ratio.substring(colonIndex + 1);
                if (nominator.length() > 0 && denominator.length() > 0) {
                    try {
                        float nominatorValue = Float.parseFloat(nominator);
                        float denominatorValue = Float.parseFloat(denominator);
                        if (!(nominatorValue > 0.0f) || !(denominatorValue > 0.0f)) break block16;
                        if (dimensionRatioSide == 1) {
                            dimensionRatio = Math.abs(denominatorValue / nominatorValue);
                            break block16;
                        }
                        dimensionRatio = Math.abs(nominatorValue / denominatorValue);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                String r = ratio.substring(commaIndex);
                if (r.length() > 0) {
                    try {
                        dimensionRatio = Float.parseFloat(r);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (dimensionRatio > 0.0f) {
            this.mDimensionRatio = dimensionRatio;
            this.mDimensionRatioSide = dimensionRatioSide;
        }
    }

    public void setDimensionRatio(float ratio, int dimensionRatioSide) {
        this.mDimensionRatio = ratio;
        this.mDimensionRatioSide = dimensionRatioSide;
    }

    public float getDimensionRatio() {
        return this.mDimensionRatio;
    }

    public int getDimensionRatioSide() {
        return this.mDimensionRatioSide;
    }

    public void setHorizontalBiasPercent(float horizontalBiasPercent) {
        this.mHorizontalBiasPercent = horizontalBiasPercent;
    }

    public void setVerticalBiasPercent(float verticalBiasPercent) {
        this.mVerticalBiasPercent = verticalBiasPercent;
    }

    public void setMinWidth(int w) {
        this.mMinWidth = w < 0 ? 0 : w;
    }

    public void setMinHeight(int h) {
        this.mMinHeight = h < 0 ? 0 : h;
    }

    public void setDimension(int w, int h) {
        this.mWidth = w;
        if (this.mWidth < this.mMinWidth) {
            this.mWidth = this.mMinWidth;
        }
        this.mHeight = h;
        if (this.mHeight < this.mMinHeight) {
            this.mHeight = this.mMinHeight;
        }
    }

    public void setFrame(int left, int top, int right, int bottom) {
        int w = right - left;
        int h = bottom - top;
        this.mX = left;
        this.mY = top;
        if (this.mVisibility == 8) {
            this.mWidth = 0;
            this.mHeight = 0;
            return;
        }
        if (this.mListDimensionBehaviors[0] == DimensionBehaviour.FIXED && w < this.mWidth) {
            w = this.mWidth;
        }
        if (this.mListDimensionBehaviors[1] == DimensionBehaviour.FIXED && h < this.mHeight) {
            h = this.mHeight;
        }
        this.mWidth = w;
        this.mHeight = h;
        if (this.mHeight < this.mMinHeight) {
            this.mHeight = this.mMinHeight;
        }
        if (this.mWidth < this.mMinWidth) {
            this.mWidth = this.mMinWidth;
        }
        if (this.mMatchConstraintMaxWidth > 0 && this.mListDimensionBehaviors[0] == DimensionBehaviour.MATCH_CONSTRAINT) {
            this.mWidth = Math.min(this.mWidth, this.mMatchConstraintMaxWidth);
        }
        if (this.mMatchConstraintMaxHeight > 0 && this.mListDimensionBehaviors[1] == DimensionBehaviour.MATCH_CONSTRAINT) {
            this.mHeight = Math.min(this.mHeight, this.mMatchConstraintMaxHeight);
        }
        if (w != this.mWidth) {
            this.mWidthOverride = this.mWidth;
        }
        if (h != this.mHeight) {
            this.mHeightOverride = this.mHeight;
        }
    }

    public void setFrame(int start, int end, int orientation) {
        if (orientation == 0) {
            this.setHorizontalDimension(start, end);
        } else if (orientation == 1) {
            this.setVerticalDimension(start, end);
        }
    }

    public void setHorizontalDimension(int left, int right) {
        this.mX = left;
        this.mWidth = right - left;
        if (this.mWidth < this.mMinWidth) {
            this.mWidth = this.mMinWidth;
        }
    }

    public void setVerticalDimension(int top, int bottom) {
        this.mY = top;
        this.mHeight = bottom - top;
        if (this.mHeight < this.mMinHeight) {
            this.mHeight = this.mMinHeight;
        }
    }

    int getRelativePositioning(int orientation) {
        if (orientation == 0) {
            return this.mRelX;
        }
        if (orientation == 1) {
            return this.mRelY;
        }
        return 0;
    }

    void setRelativePositioning(int offset, int orientation) {
        if (orientation == 0) {
            this.mRelX = offset;
        } else if (orientation == 1) {
            this.mRelY = offset;
        }
    }

    public void setBaselineDistance(int baseline) {
        this.mBaselineDistance = baseline;
        this.hasBaseline = baseline > 0;
    }

    public void setCompanionWidget(Object companion) {
        this.mCompanionWidget = companion;
    }

    public void setContainerItemSkip(int skip) {
        this.mContainerItemSkip = skip >= 0 ? skip : 0;
    }

    public int getContainerItemSkip() {
        return this.mContainerItemSkip;
    }

    public void setHorizontalWeight(float horizontalWeight) {
        this.mWeight[0] = horizontalWeight;
    }

    public void setVerticalWeight(float verticalWeight) {
        this.mWeight[1] = verticalWeight;
    }

    public void setHorizontalChainStyle(int horizontalChainStyle) {
        this.mHorizontalChainStyle = horizontalChainStyle;
    }

    public int getHorizontalChainStyle() {
        return this.mHorizontalChainStyle;
    }

    public void setVerticalChainStyle(int verticalChainStyle) {
        this.mVerticalChainStyle = verticalChainStyle;
    }

    public int getVerticalChainStyle() {
        return this.mVerticalChainStyle;
    }

    public boolean allowedInBarrier() {
        return this.mVisibility != 8;
    }

    public void immediateConnect(ConstraintAnchor.Type startType, ConstraintWidget target, ConstraintAnchor.Type endType, int margin, int goneMargin) {
        ConstraintAnchor startAnchor = this.getAnchor(startType);
        ConstraintAnchor endAnchor = target.getAnchor(endType);
        startAnchor.connect(endAnchor, margin, goneMargin, true);
    }

    public void connect(ConstraintAnchor from, ConstraintAnchor to, int margin) {
        if (from.getOwner() == this) {
            this.connect(from.getType(), to.getOwner(), to.getType(), margin);
        }
    }

    public void connect(ConstraintAnchor.Type constraintFrom, ConstraintWidget target, ConstraintAnchor.Type constraintTo) {
        this.connect(constraintFrom, target, constraintTo, 0);
    }

    public void connect(ConstraintAnchor.Type constraintFrom, ConstraintWidget target, ConstraintAnchor.Type constraintTo, int margin) {
        if (constraintFrom == ConstraintAnchor.Type.CENTER) {
            if (constraintTo == ConstraintAnchor.Type.CENTER) {
                ConstraintAnchor left = this.getAnchor(ConstraintAnchor.Type.LEFT);
                ConstraintAnchor right = this.getAnchor(ConstraintAnchor.Type.RIGHT);
                ConstraintAnchor top = this.getAnchor(ConstraintAnchor.Type.TOP);
                ConstraintAnchor bottom = this.getAnchor(ConstraintAnchor.Type.BOTTOM);
                boolean centerX = false;
                boolean centerY = false;
                if (!(left != null && left.isConnected() || right != null && right.isConnected())) {
                    this.connect(ConstraintAnchor.Type.LEFT, target, ConstraintAnchor.Type.LEFT, 0);
                    this.connect(ConstraintAnchor.Type.RIGHT, target, ConstraintAnchor.Type.RIGHT, 0);
                    centerX = true;
                }
                if (!(top != null && top.isConnected() || bottom != null && bottom.isConnected())) {
                    this.connect(ConstraintAnchor.Type.TOP, target, ConstraintAnchor.Type.TOP, 0);
                    this.connect(ConstraintAnchor.Type.BOTTOM, target, ConstraintAnchor.Type.BOTTOM, 0);
                    centerY = true;
                }
                if (centerX && centerY) {
                    ConstraintAnchor center = this.getAnchor(ConstraintAnchor.Type.CENTER);
                    center.connect(target.getAnchor(ConstraintAnchor.Type.CENTER), 0);
                } else if (centerX) {
                    ConstraintAnchor center = this.getAnchor(ConstraintAnchor.Type.CENTER_X);
                    center.connect(target.getAnchor(ConstraintAnchor.Type.CENTER_X), 0);
                } else if (centerY) {
                    ConstraintAnchor center = this.getAnchor(ConstraintAnchor.Type.CENTER_Y);
                    center.connect(target.getAnchor(ConstraintAnchor.Type.CENTER_Y), 0);
                }
            } else if (constraintTo == ConstraintAnchor.Type.LEFT || constraintTo == ConstraintAnchor.Type.RIGHT) {
                this.connect(ConstraintAnchor.Type.LEFT, target, constraintTo, 0);
                this.connect(ConstraintAnchor.Type.RIGHT, target, constraintTo, 0);
                ConstraintAnchor center = this.getAnchor(ConstraintAnchor.Type.CENTER);
                center.connect(target.getAnchor(constraintTo), 0);
            } else if (constraintTo == ConstraintAnchor.Type.TOP || constraintTo == ConstraintAnchor.Type.BOTTOM) {
                this.connect(ConstraintAnchor.Type.TOP, target, constraintTo, 0);
                this.connect(ConstraintAnchor.Type.BOTTOM, target, constraintTo, 0);
                ConstraintAnchor center = this.getAnchor(ConstraintAnchor.Type.CENTER);
                center.connect(target.getAnchor(constraintTo), 0);
            }
        } else if (constraintFrom == ConstraintAnchor.Type.CENTER_X && (constraintTo == ConstraintAnchor.Type.LEFT || constraintTo == ConstraintAnchor.Type.RIGHT)) {
            ConstraintAnchor left = this.getAnchor(ConstraintAnchor.Type.LEFT);
            ConstraintAnchor targetAnchor = target.getAnchor(constraintTo);
            ConstraintAnchor right = this.getAnchor(ConstraintAnchor.Type.RIGHT);
            left.connect(targetAnchor, 0);
            right.connect(targetAnchor, 0);
            ConstraintAnchor centerX = this.getAnchor(ConstraintAnchor.Type.CENTER_X);
            centerX.connect(targetAnchor, 0);
        } else if (constraintFrom == ConstraintAnchor.Type.CENTER_Y && (constraintTo == ConstraintAnchor.Type.TOP || constraintTo == ConstraintAnchor.Type.BOTTOM)) {
            ConstraintAnchor targetAnchor = target.getAnchor(constraintTo);
            ConstraintAnchor top = this.getAnchor(ConstraintAnchor.Type.TOP);
            top.connect(targetAnchor, 0);
            ConstraintAnchor bottom = this.getAnchor(ConstraintAnchor.Type.BOTTOM);
            bottom.connect(targetAnchor, 0);
            ConstraintAnchor centerY = this.getAnchor(ConstraintAnchor.Type.CENTER_Y);
            centerY.connect(targetAnchor, 0);
        } else if (constraintFrom == ConstraintAnchor.Type.CENTER_X && constraintTo == ConstraintAnchor.Type.CENTER_X) {
            ConstraintAnchor left = this.getAnchor(ConstraintAnchor.Type.LEFT);
            ConstraintAnchor leftTarget = target.getAnchor(ConstraintAnchor.Type.LEFT);
            left.connect(leftTarget, 0);
            ConstraintAnchor right = this.getAnchor(ConstraintAnchor.Type.RIGHT);
            ConstraintAnchor rightTarget = target.getAnchor(ConstraintAnchor.Type.RIGHT);
            right.connect(rightTarget, 0);
            ConstraintAnchor centerX = this.getAnchor(ConstraintAnchor.Type.CENTER_X);
            centerX.connect(target.getAnchor(constraintTo), 0);
        } else if (constraintFrom == ConstraintAnchor.Type.CENTER_Y && constraintTo == ConstraintAnchor.Type.CENTER_Y) {
            ConstraintAnchor top = this.getAnchor(ConstraintAnchor.Type.TOP);
            ConstraintAnchor topTarget = target.getAnchor(ConstraintAnchor.Type.TOP);
            top.connect(topTarget, 0);
            ConstraintAnchor bottom = this.getAnchor(ConstraintAnchor.Type.BOTTOM);
            ConstraintAnchor bottomTarget = target.getAnchor(ConstraintAnchor.Type.BOTTOM);
            bottom.connect(bottomTarget, 0);
            ConstraintAnchor centerY = this.getAnchor(ConstraintAnchor.Type.CENTER_Y);
            centerY.connect(target.getAnchor(constraintTo), 0);
        } else {
            ConstraintAnchor toAnchor;
            ConstraintAnchor fromAnchor = this.getAnchor(constraintFrom);
            if (fromAnchor.isValidConnection(toAnchor = target.getAnchor(constraintTo))) {
                if (constraintFrom == ConstraintAnchor.Type.BASELINE) {
                    ConstraintAnchor top = this.getAnchor(ConstraintAnchor.Type.TOP);
                    ConstraintAnchor bottom = this.getAnchor(ConstraintAnchor.Type.BOTTOM);
                    if (top != null) {
                        top.reset();
                    }
                    if (bottom != null) {
                        bottom.reset();
                    }
                } else if (constraintFrom == ConstraintAnchor.Type.TOP || constraintFrom == ConstraintAnchor.Type.BOTTOM) {
                    ConstraintAnchor center;
                    ConstraintAnchor baseline = this.getAnchor(ConstraintAnchor.Type.BASELINE);
                    if (baseline != null) {
                        baseline.reset();
                    }
                    if ((center = this.getAnchor(ConstraintAnchor.Type.CENTER)).getTarget() != toAnchor) {
                        center.reset();
                    }
                    ConstraintAnchor opposite = this.getAnchor(constraintFrom).getOpposite();
                    ConstraintAnchor centerY = this.getAnchor(ConstraintAnchor.Type.CENTER_Y);
                    if (centerY.isConnected()) {
                        opposite.reset();
                        centerY.reset();
                    }
                } else if (constraintFrom == ConstraintAnchor.Type.LEFT || constraintFrom == ConstraintAnchor.Type.RIGHT) {
                    ConstraintAnchor center = this.getAnchor(ConstraintAnchor.Type.CENTER);
                    if (center.getTarget() != toAnchor) {
                        center.reset();
                    }
                    ConstraintAnchor opposite = this.getAnchor(constraintFrom).getOpposite();
                    ConstraintAnchor centerX = this.getAnchor(ConstraintAnchor.Type.CENTER_X);
                    if (centerX.isConnected()) {
                        opposite.reset();
                        centerX.reset();
                    }
                }
                fromAnchor.connect(toAnchor, margin);
            }
        }
    }

    public void resetAllConstraints() {
        this.resetAnchors();
        this.setVerticalBiasPercent(DEFAULT_BIAS);
        this.setHorizontalBiasPercent(DEFAULT_BIAS);
    }

    public void resetAnchor(ConstraintAnchor anchor) {
        ConstraintWidgetContainer parent;
        if (this.getParent() != null && this.getParent() instanceof ConstraintWidgetContainer && (parent = (ConstraintWidgetContainer)this.getParent()).handlesInternalConstraints()) {
            return;
        }
        ConstraintAnchor left = this.getAnchor(ConstraintAnchor.Type.LEFT);
        ConstraintAnchor right = this.getAnchor(ConstraintAnchor.Type.RIGHT);
        ConstraintAnchor top = this.getAnchor(ConstraintAnchor.Type.TOP);
        ConstraintAnchor bottom = this.getAnchor(ConstraintAnchor.Type.BOTTOM);
        ConstraintAnchor center = this.getAnchor(ConstraintAnchor.Type.CENTER);
        ConstraintAnchor centerX = this.getAnchor(ConstraintAnchor.Type.CENTER_X);
        ConstraintAnchor centerY = this.getAnchor(ConstraintAnchor.Type.CENTER_Y);
        if (anchor == center) {
            if (left.isConnected() && right.isConnected() && left.getTarget() == right.getTarget()) {
                left.reset();
                right.reset();
            }
            if (top.isConnected() && bottom.isConnected() && top.getTarget() == bottom.getTarget()) {
                top.reset();
                bottom.reset();
            }
            this.mHorizontalBiasPercent = 0.5f;
            this.mVerticalBiasPercent = 0.5f;
        } else if (anchor == centerX) {
            if (left.isConnected() && right.isConnected() && left.getTarget().getOwner() == right.getTarget().getOwner()) {
                left.reset();
                right.reset();
            }
            this.mHorizontalBiasPercent = 0.5f;
        } else if (anchor == centerY) {
            if (top.isConnected() && bottom.isConnected() && top.getTarget().getOwner() == bottom.getTarget().getOwner()) {
                top.reset();
                bottom.reset();
            }
            this.mVerticalBiasPercent = 0.5f;
        } else if (anchor == left || anchor == right) {
            if (left.isConnected() && left.getTarget() == right.getTarget()) {
                center.reset();
            }
        } else if ((anchor == top || anchor == bottom) && top.isConnected() && top.getTarget() == bottom.getTarget()) {
            center.reset();
        }
        anchor.reset();
    }

    public void resetAnchors() {
        ConstraintWidgetContainer parentContainer;
        ConstraintWidget parent = this.getParent();
        if (parent != null && parent instanceof ConstraintWidgetContainer && (parentContainer = (ConstraintWidgetContainer)this.getParent()).handlesInternalConstraints()) {
            return;
        }
        int mAnchorsSize = this.mAnchors.size();
        for (int i = 0; i < mAnchorsSize; ++i) {
            ConstraintAnchor anchor = this.mAnchors.get(i);
            anchor.reset();
        }
    }

    public ConstraintAnchor getAnchor(ConstraintAnchor.Type anchorType) {
        switch (anchorType) {
            case LEFT: {
                return this.mLeft;
            }
            case TOP: {
                return this.mTop;
            }
            case RIGHT: {
                return this.mRight;
            }
            case BOTTOM: {
                return this.mBottom;
            }
            case BASELINE: {
                return this.mBaseline;
            }
            case CENTER_X: {
                return this.mCenterX;
            }
            case CENTER_Y: {
                return this.mCenterY;
            }
            case CENTER: {
                return this.mCenter;
            }
            case NONE: {
                return null;
            }
        }
        throw new AssertionError((Object)anchorType.name());
    }

    public DimensionBehaviour getHorizontalDimensionBehaviour() {
        return this.mListDimensionBehaviors[0];
    }

    public DimensionBehaviour getVerticalDimensionBehaviour() {
        return this.mListDimensionBehaviors[1];
    }

    public DimensionBehaviour getDimensionBehaviour(int orientation) {
        if (orientation == 0) {
            return this.getHorizontalDimensionBehaviour();
        }
        if (orientation == 1) {
            return this.getVerticalDimensionBehaviour();
        }
        return null;
    }

    public void setHorizontalDimensionBehaviour(DimensionBehaviour behaviour) {
        this.mListDimensionBehaviors[0] = behaviour;
    }

    public void setVerticalDimensionBehaviour(DimensionBehaviour behaviour) {
        this.mListDimensionBehaviors[1] = behaviour;
    }

    public boolean isInHorizontalChain() {
        return this.mLeft.mTarget != null && this.mLeft.mTarget.mTarget == this.mLeft || this.mRight.mTarget != null && this.mRight.mTarget.mTarget == this.mRight;
    }

    public ConstraintWidget getPreviousChainMember(int orientation) {
        if (orientation == 0) {
            if (this.mLeft.mTarget != null && this.mLeft.mTarget.mTarget == this.mLeft) {
                return this.mLeft.mTarget.mOwner;
            }
        } else if (orientation == 1 && this.mTop.mTarget != null && this.mTop.mTarget.mTarget == this.mTop) {
            return this.mTop.mTarget.mOwner;
        }
        return null;
    }

    public ConstraintWidget getNextChainMember(int orientation) {
        if (orientation == 0) {
            if (this.mRight.mTarget != null && this.mRight.mTarget.mTarget == this.mRight) {
                return this.mRight.mTarget.mOwner;
            }
        } else if (orientation == 1 && this.mBottom.mTarget != null && this.mBottom.mTarget.mTarget == this.mBottom) {
            return this.mBottom.mTarget.mOwner;
        }
        return null;
    }

    public ConstraintWidget getHorizontalChainControlWidget() {
        ConstraintWidget found = null;
        if (this.isInHorizontalChain()) {
            ConstraintWidget tmp = this;
            while (found == null && tmp != null) {
                ConstraintAnchor targetAnchor;
                ConstraintWidget target;
                ConstraintAnchor anchor = tmp.getAnchor(ConstraintAnchor.Type.LEFT);
                ConstraintAnchor targetOwner = anchor == null ? null : anchor.getTarget();
                ConstraintWidget constraintWidget = target = targetOwner == null ? null : targetOwner.getOwner();
                if (target == this.getParent()) {
                    found = tmp;
                    break;
                }
                ConstraintAnchor constraintAnchor = targetAnchor = target == null ? null : target.getAnchor(ConstraintAnchor.Type.RIGHT).getTarget();
                if (targetAnchor != null && targetAnchor.getOwner() != tmp) {
                    found = tmp;
                    continue;
                }
                tmp = target;
            }
        }
        return found;
    }

    public boolean isInVerticalChain() {
        return this.mTop.mTarget != null && this.mTop.mTarget.mTarget == this.mTop || this.mBottom.mTarget != null && this.mBottom.mTarget.mTarget == this.mBottom;
    }

    public ConstraintWidget getVerticalChainControlWidget() {
        ConstraintWidget found = null;
        if (this.isInVerticalChain()) {
            ConstraintWidget tmp = this;
            while (found == null && tmp != null) {
                ConstraintAnchor targetAnchor;
                ConstraintWidget target;
                ConstraintAnchor anchor = tmp.getAnchor(ConstraintAnchor.Type.TOP);
                ConstraintAnchor targetOwner = anchor == null ? null : anchor.getTarget();
                ConstraintWidget constraintWidget = target = targetOwner == null ? null : targetOwner.getOwner();
                if (target == this.getParent()) {
                    found = tmp;
                    break;
                }
                ConstraintAnchor constraintAnchor = targetAnchor = target == null ? null : target.getAnchor(ConstraintAnchor.Type.BOTTOM).getTarget();
                if (targetAnchor != null && targetAnchor.getOwner() != tmp) {
                    found = tmp;
                    continue;
                }
                tmp = target;
            }
        }
        return found;
    }

    private boolean isChainHead(int orientation) {
        int offset = orientation * 2;
        return this.mListAnchors[offset].mTarget != null && this.mListAnchors[offset].mTarget.mTarget != this.mListAnchors[offset] && this.mListAnchors[offset + 1].mTarget != null && this.mListAnchors[offset + 1].mTarget.mTarget == this.mListAnchors[offset + 1];
    }

    public void addToSolver(LinearSystem system, boolean optimize) {
        SolverVariable parentMax;
        boolean wrapContent;
        int height;
        int width;
        SolverVariable left = system.createObjectVariable(this.mLeft);
        SolverVariable right = system.createObjectVariable(this.mRight);
        SolverVariable top = system.createObjectVariable(this.mTop);
        SolverVariable bottom = system.createObjectVariable(this.mBottom);
        SolverVariable baseline = system.createObjectVariable(this.mBaseline);
        boolean horizontalParentWrapContent = false;
        boolean verticalParentWrapContent = false;
        if (this.mParent != null) {
            boolean bl = this.mParent != null ? this.mParent.mListDimensionBehaviors[0] == DimensionBehaviour.WRAP_CONTENT : (horizontalParentWrapContent = false);
            verticalParentWrapContent = this.mParent != null ? this.mParent.mListDimensionBehaviors[1] == DimensionBehaviour.WRAP_CONTENT : false;
            switch (this.mWrapBehaviorInParent) {
                case 3: {
                    horizontalParentWrapContent = false;
                    verticalParentWrapContent = false;
                    break;
                }
                case 1: {
                    verticalParentWrapContent = false;
                    break;
                }
                case 2: {
                    horizontalParentWrapContent = false;
                }
            }
        }
        if (!(this.mVisibility != 8 || this.hasDependencies() || this.mIsInBarrier[0] || this.mIsInBarrier[1])) {
            return;
        }
        if (this.resolvedHorizontal || this.resolvedVertical) {
            ConstraintWidgetContainer container;
            if (this.resolvedHorizontal) {
                system.addEquality(left, this.mX);
                system.addEquality(right, this.mX + this.mWidth);
                if (horizontalParentWrapContent && this.mParent != null) {
                    if (this.OPTIMIZE_WRAP_ON_RESOLVED) {
                        container = (ConstraintWidgetContainer)this.mParent;
                        container.addHorizontalWrapMinVariable(this.mLeft);
                        container.addHorizontalWrapMaxVariable(this.mRight);
                    } else {
                        int wrapStrength = 5;
                        system.addGreaterThan(system.createObjectVariable(this.mParent.mRight), right, 0, wrapStrength);
                    }
                }
            }
            if (this.resolvedVertical) {
                system.addEquality(top, this.mY);
                system.addEquality(bottom, this.mY + this.mHeight);
                if (this.mBaseline.hasDependents()) {
                    system.addEquality(baseline, this.mY + this.mBaselineDistance);
                }
                if (verticalParentWrapContent && this.mParent != null) {
                    if (this.OPTIMIZE_WRAP_ON_RESOLVED) {
                        container = (ConstraintWidgetContainer)this.mParent;
                        container.addVerticalWrapMinVariable(this.mTop);
                        container.addVerticalWrapMaxVariable(this.mBottom);
                    } else {
                        int wrapStrength = 5;
                        system.addGreaterThan(system.createObjectVariable(this.mParent.mBottom), bottom, 0, wrapStrength);
                    }
                }
            }
            if (this.resolvedHorizontal && this.resolvedVertical) {
                this.resolvedHorizontal = false;
                this.resolvedVertical = false;
                return;
            }
        }
        if (LinearSystem.sMetrics != null) {
            ++LinearSystem.sMetrics.widgets;
        }
        if (optimize && this.horizontalRun != null && this.verticalRun != null && this.horizontalRun.start.resolved && this.horizontalRun.end.resolved && this.verticalRun.start.resolved && this.verticalRun.end.resolved) {
            if (LinearSystem.sMetrics != null) {
                ++LinearSystem.sMetrics.graphSolved;
            }
            system.addEquality(left, this.horizontalRun.start.value);
            system.addEquality(right, this.horizontalRun.end.value);
            system.addEquality(top, this.verticalRun.start.value);
            system.addEquality(bottom, this.verticalRun.end.value);
            system.addEquality(baseline, this.verticalRun.baseline.value);
            if (this.mParent != null) {
                if (horizontalParentWrapContent && this.isTerminalWidget[0] && !this.isInHorizontalChain()) {
                    SolverVariable parentMax2 = system.createObjectVariable(this.mParent.mRight);
                    system.addGreaterThan(parentMax2, right, 0, 8);
                }
                if (verticalParentWrapContent && this.isTerminalWidget[1] && !this.isInVerticalChain()) {
                    SolverVariable parentMax3 = system.createObjectVariable(this.mParent.mBottom);
                    system.addGreaterThan(parentMax3, bottom, 0, 8);
                }
            }
            this.resolvedHorizontal = false;
            this.resolvedVertical = false;
            return;
        }
        if (LinearSystem.sMetrics != null) {
            ++LinearSystem.sMetrics.linearSolved;
        }
        boolean inHorizontalChain = false;
        boolean inVerticalChain = false;
        if (this.mParent != null) {
            if (this.isChainHead(0)) {
                ((ConstraintWidgetContainer)this.mParent).addChain(this, 0);
                inHorizontalChain = true;
            } else {
                inHorizontalChain = this.isInHorizontalChain();
            }
            if (this.isChainHead(1)) {
                ((ConstraintWidgetContainer)this.mParent).addChain(this, 1);
                inVerticalChain = true;
            } else {
                inVerticalChain = this.isInVerticalChain();
            }
            if (!inHorizontalChain && horizontalParentWrapContent && this.mVisibility != 8 && this.mLeft.mTarget == null && this.mRight.mTarget == null) {
                SolverVariable parentRight = system.createObjectVariable(this.mParent.mRight);
                system.addGreaterThan(parentRight, right, 0, 1);
            }
            if (!inVerticalChain && verticalParentWrapContent && this.mVisibility != 8 && this.mTop.mTarget == null && this.mBottom.mTarget == null && this.mBaseline == null) {
                SolverVariable parentBottom = system.createObjectVariable(this.mParent.mBottom);
                system.addGreaterThan(parentBottom, bottom, 0, 1);
            }
        }
        if ((width = this.mWidth) < this.mMinWidth) {
            width = this.mMinWidth;
        }
        if ((height = this.mHeight) < this.mMinHeight) {
            height = this.mMinHeight;
        }
        boolean horizontalDimensionFixed = this.mListDimensionBehaviors[0] != DimensionBehaviour.MATCH_CONSTRAINT;
        boolean verticalDimensionFixed = this.mListDimensionBehaviors[1] != DimensionBehaviour.MATCH_CONSTRAINT;
        boolean useRatio = false;
        this.mResolvedDimensionRatioSide = this.mDimensionRatioSide;
        this.mResolvedDimensionRatio = this.mDimensionRatio;
        int matchConstraintDefaultWidth = this.mMatchConstraintDefaultWidth;
        int matchConstraintDefaultHeight = this.mMatchConstraintDefaultHeight;
        if (this.mDimensionRatio > 0.0f && this.mVisibility != 8) {
            useRatio = true;
            if (this.mListDimensionBehaviors[0] == DimensionBehaviour.MATCH_CONSTRAINT && matchConstraintDefaultWidth == 0) {
                matchConstraintDefaultWidth = 3;
            }
            if (this.mListDimensionBehaviors[1] == DimensionBehaviour.MATCH_CONSTRAINT && matchConstraintDefaultHeight == 0) {
                matchConstraintDefaultHeight = 3;
            }
            if (this.mListDimensionBehaviors[0] == DimensionBehaviour.MATCH_CONSTRAINT && this.mListDimensionBehaviors[1] == DimensionBehaviour.MATCH_CONSTRAINT && matchConstraintDefaultWidth == 3 && matchConstraintDefaultHeight == 3) {
                this.setupDimensionRatio(horizontalParentWrapContent, verticalParentWrapContent, horizontalDimensionFixed, verticalDimensionFixed);
            } else if (this.mListDimensionBehaviors[0] == DimensionBehaviour.MATCH_CONSTRAINT && matchConstraintDefaultWidth == 3) {
                this.mResolvedDimensionRatioSide = 0;
                width = (int)(this.mResolvedDimensionRatio * (float)this.mHeight);
                if (this.mListDimensionBehaviors[1] != DimensionBehaviour.MATCH_CONSTRAINT) {
                    matchConstraintDefaultWidth = 4;
                    useRatio = false;
                }
            } else if (this.mListDimensionBehaviors[1] == DimensionBehaviour.MATCH_CONSTRAINT && matchConstraintDefaultHeight == 3) {
                this.mResolvedDimensionRatioSide = 1;
                if (this.mDimensionRatioSide == -1) {
                    this.mResolvedDimensionRatio = 1.0f / this.mResolvedDimensionRatio;
                }
                height = (int)(this.mResolvedDimensionRatio * (float)this.mWidth);
                if (this.mListDimensionBehaviors[0] != DimensionBehaviour.MATCH_CONSTRAINT) {
                    matchConstraintDefaultHeight = 4;
                    useRatio = false;
                }
            }
        }
        this.mResolvedMatchConstraintDefault[0] = matchConstraintDefaultWidth;
        this.mResolvedMatchConstraintDefault[1] = matchConstraintDefaultHeight;
        this.mResolvedHasRatio = useRatio;
        boolean useHorizontalRatio = useRatio && (this.mResolvedDimensionRatioSide == 0 || this.mResolvedDimensionRatioSide == -1);
        boolean useVerticalRatio = useRatio && (this.mResolvedDimensionRatioSide == 1 || this.mResolvedDimensionRatioSide == -1);
        boolean bl = wrapContent = this.mListDimensionBehaviors[0] == DimensionBehaviour.WRAP_CONTENT && this instanceof ConstraintWidgetContainer;
        if (wrapContent) {
            width = 0;
        }
        boolean applyPosition = true;
        if (this.mCenter.isConnected()) {
            applyPosition = false;
        }
        boolean isInHorizontalBarrier = this.mIsInBarrier[0];
        boolean isInVerticalBarrier = this.mIsInBarrier[1];
        if (this.mHorizontalResolution != 2 && !this.resolvedHorizontal) {
            SolverVariable parentMax4;
            if (!(optimize && this.horizontalRun != null && this.horizontalRun.start.resolved && this.horizontalRun.end.resolved)) {
                parentMax4 = this.mParent != null ? system.createObjectVariable(this.mParent.mRight) : null;
                SolverVariable parentMin = this.mParent != null ? system.createObjectVariable(this.mParent.mLeft) : null;
                this.applyConstraints(system, true, horizontalParentWrapContent, verticalParentWrapContent, this.isTerminalWidget[0], parentMin, parentMax4, this.mListDimensionBehaviors[0], wrapContent, this.mLeft, this.mRight, this.mX, width, this.mMinWidth, this.mMaxDimension[0], this.mHorizontalBiasPercent, useHorizontalRatio, this.mListDimensionBehaviors[1] == DimensionBehaviour.MATCH_CONSTRAINT, inHorizontalChain, inVerticalChain, isInHorizontalBarrier, matchConstraintDefaultWidth, matchConstraintDefaultHeight, this.mMatchConstraintMinWidth, this.mMatchConstraintMaxWidth, this.mMatchConstraintPercentWidth, applyPosition);
            } else if (optimize) {
                system.addEquality(left, this.horizontalRun.start.value);
                system.addEquality(right, this.horizontalRun.end.value);
                if (this.mParent != null && horizontalParentWrapContent && this.isTerminalWidget[0] && !this.isInHorizontalChain()) {
                    parentMax4 = system.createObjectVariable(this.mParent.mRight);
                    system.addGreaterThan(parentMax4, right, 0, 8);
                }
            }
        }
        boolean applyVerticalConstraints = true;
        if (optimize && this.verticalRun != null && this.verticalRun.start.resolved && this.verticalRun.end.resolved) {
            system.addEquality(top, this.verticalRun.start.value);
            system.addEquality(bottom, this.verticalRun.end.value);
            system.addEquality(baseline, this.verticalRun.baseline.value);
            if (this.mParent != null && !inVerticalChain && verticalParentWrapContent && this.isTerminalWidget[1]) {
                parentMax = system.createObjectVariable(this.mParent.mBottom);
                system.addGreaterThan(parentMax, bottom, 0, 8);
            }
            applyVerticalConstraints = false;
        }
        if (this.mVerticalResolution == 2) {
            applyVerticalConstraints = false;
        }
        if (applyVerticalConstraints && !this.resolvedVertical) {
            SolverVariable parentMin;
            boolean bl2 = wrapContent = this.mListDimensionBehaviors[1] == DimensionBehaviour.WRAP_CONTENT && this instanceof ConstraintWidgetContainer;
            if (wrapContent) {
                height = 0;
            }
            parentMax = this.mParent != null ? system.createObjectVariable(this.mParent.mBottom) : null;
            SolverVariable solverVariable = parentMin = this.mParent != null ? system.createObjectVariable(this.mParent.mTop) : null;
            if (this.mBaselineDistance > 0 || this.mVisibility == 8) {
                if (this.mBaseline.mTarget != null) {
                    system.addEquality(baseline, top, this.getBaselineDistance(), 8);
                    SolverVariable baselineTarget = system.createObjectVariable(this.mBaseline.mTarget);
                    int baselineMargin = this.mBaseline.getMargin();
                    system.addEquality(baseline, baselineTarget, baselineMargin, 8);
                    applyPosition = false;
                    if (verticalParentWrapContent) {
                        SolverVariable end = system.createObjectVariable(this.mBottom);
                        int wrapStrength = 5;
                        system.addGreaterThan(parentMax, end, 0, wrapStrength);
                    }
                } else if (this.mVisibility == 8) {
                    system.addEquality(baseline, top, this.mBaseline.getMargin(), 8);
                } else {
                    system.addEquality(baseline, top, this.getBaselineDistance(), 8);
                }
            }
            this.applyConstraints(system, false, verticalParentWrapContent, horizontalParentWrapContent, this.isTerminalWidget[1], parentMin, parentMax, this.mListDimensionBehaviors[1], wrapContent, this.mTop, this.mBottom, this.mY, height, this.mMinHeight, this.mMaxDimension[1], this.mVerticalBiasPercent, useVerticalRatio, this.mListDimensionBehaviors[0] == DimensionBehaviour.MATCH_CONSTRAINT, inVerticalChain, inHorizontalChain, isInVerticalBarrier, matchConstraintDefaultHeight, matchConstraintDefaultWidth, this.mMatchConstraintMinHeight, this.mMatchConstraintMaxHeight, this.mMatchConstraintPercentHeight, applyPosition);
        }
        if (useRatio) {
            int strength = 8;
            if (this.mResolvedDimensionRatioSide == 1) {
                system.addRatio(bottom, top, right, left, this.mResolvedDimensionRatio, strength);
            } else {
                system.addRatio(right, left, bottom, top, this.mResolvedDimensionRatio, strength);
            }
        }
        if (this.mCenter.isConnected()) {
            system.addCenterPoint(this, this.mCenter.getTarget().getOwner(), (float)Math.toRadians(this.mCircleConstraintAngle + 90.0f), this.mCenter.getMargin());
        }
        this.resolvedHorizontal = false;
        this.resolvedVertical = false;
    }

    boolean addFirst() {
        return this instanceof VirtualLayout || this instanceof Guideline;
    }

    public void setupDimensionRatio(boolean hParentWrapContent, boolean vParentWrapContent, boolean horizontalDimensionFixed, boolean verticalDimensionFixed) {
        if (this.mResolvedDimensionRatioSide == -1) {
            if (horizontalDimensionFixed && !verticalDimensionFixed) {
                this.mResolvedDimensionRatioSide = 0;
            } else if (!horizontalDimensionFixed && verticalDimensionFixed) {
                this.mResolvedDimensionRatioSide = 1;
                if (this.mDimensionRatioSide == -1) {
                    this.mResolvedDimensionRatio = 1.0f / this.mResolvedDimensionRatio;
                }
            }
        }
        if (!(this.mResolvedDimensionRatioSide != 0 || this.mTop.isConnected() && this.mBottom.isConnected())) {
            this.mResolvedDimensionRatioSide = 1;
        } else if (!(this.mResolvedDimensionRatioSide != 1 || this.mLeft.isConnected() && this.mRight.isConnected())) {
            this.mResolvedDimensionRatioSide = 0;
        }
        if (!(this.mResolvedDimensionRatioSide != -1 || this.mTop.isConnected() && this.mBottom.isConnected() && this.mLeft.isConnected() && this.mRight.isConnected())) {
            if (this.mTop.isConnected() && this.mBottom.isConnected()) {
                this.mResolvedDimensionRatioSide = 0;
            } else if (this.mLeft.isConnected() && this.mRight.isConnected()) {
                this.mResolvedDimensionRatio = 1.0f / this.mResolvedDimensionRatio;
                this.mResolvedDimensionRatioSide = 1;
            }
        }
        if (this.mResolvedDimensionRatioSide == -1) {
            if (this.mMatchConstraintMinWidth > 0 && this.mMatchConstraintMinHeight == 0) {
                this.mResolvedDimensionRatioSide = 0;
            } else if (this.mMatchConstraintMinWidth == 0 && this.mMatchConstraintMinHeight > 0) {
                this.mResolvedDimensionRatio = 1.0f / this.mResolvedDimensionRatio;
                this.mResolvedDimensionRatioSide = 1;
            }
        }
    }

    private void applyConstraints(LinearSystem system, boolean isHorizontal, boolean parentWrapContent, boolean oppositeParentWrapContent, boolean isTerminal, SolverVariable parentMin, SolverVariable parentMax, DimensionBehaviour dimensionBehaviour, boolean wrapContent, ConstraintAnchor beginAnchor, ConstraintAnchor endAnchor, int beginPosition, int dimension, int minDimension, int maxDimension, float bias, boolean useRatio, boolean oppositeVariable, boolean inChain, boolean oppositeInChain, boolean inBarrier, int matchConstraintDefault, int oppositeMatchConstraintDefault, int matchMinDimension, int matchMaxDimension, float matchPercentDimension, boolean applyPosition) {
        SolverVariable begin = system.createObjectVariable(beginAnchor);
        SolverVariable end = system.createObjectVariable(endAnchor);
        SolverVariable beginTarget = system.createObjectVariable(beginAnchor.getTarget());
        SolverVariable endTarget = system.createObjectVariable(endAnchor.getTarget());
        if (system.getMetrics() != null) {
            ++system.getMetrics().nonresolvedWidgets;
        }
        boolean isBeginConnected = beginAnchor.isConnected();
        boolean isEndConnected = endAnchor.isConnected();
        boolean isCenterConnected = this.mCenter.isConnected();
        boolean variableSize = false;
        int numConnections = 0;
        if (isBeginConnected) {
            ++numConnections;
        }
        if (isEndConnected) {
            ++numConnections;
        }
        if (isCenterConnected) {
            ++numConnections;
        }
        if (useRatio) {
            matchConstraintDefault = 3;
        }
        switch (dimensionBehaviour) {
            case FIXED: {
                variableSize = false;
                break;
            }
            case WRAP_CONTENT: {
                variableSize = false;
                break;
            }
            case MATCH_PARENT: {
                variableSize = false;
                break;
            }
            case MATCH_CONSTRAINT: {
                boolean bl = variableSize = matchConstraintDefault != 4;
            }
        }
        if (this.mWidthOverride != -1 && isHorizontal) {
            variableSize = false;
            dimension = this.mWidthOverride;
            this.mWidthOverride = -1;
        }
        if (this.mHeightOverride != -1 && !isHorizontal) {
            variableSize = false;
            dimension = this.mHeightOverride;
            this.mHeightOverride = -1;
        }
        if (this.mVisibility == 8) {
            dimension = 0;
            variableSize = false;
        }
        if (applyPosition) {
            if (!(isBeginConnected || isEndConnected || isCenterConnected)) {
                system.addEquality(begin, beginPosition);
            } else if (isBeginConnected && !isEndConnected) {
                system.addEquality(begin, beginTarget, beginAnchor.getMargin(), 8);
            }
        }
        if (!variableSize) {
            if (wrapContent) {
                system.addEquality(end, begin, 0, 3);
                if (minDimension > 0) {
                    system.addGreaterThan(end, begin, minDimension, 8);
                }
                if (maxDimension < Integer.MAX_VALUE) {
                    system.addLowerThan(end, begin, maxDimension, 8);
                }
            } else {
                system.addEquality(end, begin, dimension, 8);
            }
        } else if (!(numConnections == 2 || useRatio || matchConstraintDefault != 1 && matchConstraintDefault != 0)) {
            variableSize = false;
            int d = Math.max(matchMinDimension, dimension);
            if (matchMaxDimension > 0) {
                d = Math.min(matchMaxDimension, d);
            }
            system.addEquality(end, begin, d, 8);
        } else {
            if (matchMinDimension == -2) {
                matchMinDimension = dimension;
            }
            if (matchMaxDimension == -2) {
                matchMaxDimension = dimension;
            }
            if (dimension > 0 && matchConstraintDefault != 1) {
                dimension = 0;
            }
            if (matchMinDimension > 0) {
                system.addGreaterThan(end, begin, matchMinDimension, 8);
                dimension = Math.max(dimension, matchMinDimension);
            }
            if (matchMaxDimension > 0) {
                boolean applyLimit = true;
                if (parentWrapContent && matchConstraintDefault == 1) {
                    applyLimit = false;
                }
                if (applyLimit) {
                    system.addLowerThan(end, begin, matchMaxDimension, 8);
                }
                dimension = Math.min(dimension, matchMaxDimension);
            }
            if (matchConstraintDefault == 1) {
                if (parentWrapContent) {
                    system.addEquality(end, begin, dimension, 8);
                } else if (inChain) {
                    system.addEquality(end, begin, dimension, 5);
                    system.addLowerThan(end, begin, dimension, 8);
                } else {
                    system.addEquality(end, begin, dimension, 5);
                    system.addLowerThan(end, begin, dimension, 8);
                }
            } else if (matchConstraintDefault == 2) {
                SolverVariable percentBegin = null;
                SolverVariable percentEnd = null;
                if (beginAnchor.getType() == ConstraintAnchor.Type.TOP || beginAnchor.getType() == ConstraintAnchor.Type.BOTTOM) {
                    percentBegin = system.createObjectVariable(this.mParent.getAnchor(ConstraintAnchor.Type.TOP));
                    percentEnd = system.createObjectVariable(this.mParent.getAnchor(ConstraintAnchor.Type.BOTTOM));
                } else {
                    percentBegin = system.createObjectVariable(this.mParent.getAnchor(ConstraintAnchor.Type.LEFT));
                    percentEnd = system.createObjectVariable(this.mParent.getAnchor(ConstraintAnchor.Type.RIGHT));
                }
                system.addConstraint(system.createRow().createRowDimensionRatio(end, begin, percentEnd, percentBegin, matchPercentDimension));
                if (parentWrapContent) {
                    variableSize = false;
                }
            } else {
                isTerminal = true;
            }
        }
        if (!applyPosition || inChain) {
            if (numConnections < 2 && parentWrapContent && isTerminal) {
                boolean applyEnd;
                system.addGreaterThan(begin, parentMin, 0, 8);
                boolean bl = applyEnd = isHorizontal || this.mBaseline.mTarget == null;
                if (!isHorizontal && this.mBaseline.mTarget != null) {
                    ConstraintWidget target = this.mBaseline.mTarget.mOwner;
                    applyEnd = target.mDimensionRatio != 0.0f && target.mListDimensionBehaviors[0] == DimensionBehaviour.MATCH_CONSTRAINT && target.mListDimensionBehaviors[1] == DimensionBehaviour.MATCH_CONSTRAINT;
                }
                if (applyEnd) {
                    system.addGreaterThan(parentMax, end, 0, 8);
                }
            }
            return;
        }
        int wrapStrength = 5;
        if (isBeginConnected || isEndConnected || isCenterConnected) {
            if (isBeginConnected && !isEndConnected) {
                ConstraintWidget beginWidget = beginAnchor.mTarget.mOwner;
                if (parentWrapContent && beginWidget instanceof Barrier) {
                    wrapStrength = 8;
                }
            } else if (!isBeginConnected && isEndConnected) {
                system.addEquality(end, endTarget, -endAnchor.getMargin(), 8);
                if (parentWrapContent) {
                    if (this.OPTIMIZE_WRAP && begin.isFinalValue && this.mParent != null) {
                        ConstraintWidgetContainer container = (ConstraintWidgetContainer)this.mParent;
                        if (isHorizontal) {
                            container.addHorizontalWrapMinVariable(beginAnchor);
                        } else {
                            container.addVerticalWrapMinVariable(beginAnchor);
                        }
                    } else {
                        system.addGreaterThan(begin, parentMin, 0, 5);
                    }
                }
            } else if (isBeginConnected && isEndConnected) {
                boolean applyBoundsCheck = true;
                boolean applyCentering = false;
                boolean applyStrongChecks = false;
                boolean applyRangeCheck = false;
                int rangeCheckStrength = 5;
                int boundsCheckStrength = 4;
                int centeringStrength = 6;
                if (parentWrapContent) {
                    rangeCheckStrength = 5;
                }
                ConstraintWidget beginWidget = beginAnchor.mTarget.mOwner;
                ConstraintWidget endWidget = endAnchor.mTarget.mOwner;
                ConstraintWidget parent = this.getParent();
                if (variableSize) {
                    if (matchConstraintDefault == 0) {
                        if (matchMaxDimension == 0 && matchMinDimension == 0) {
                            applyStrongChecks = true;
                            rangeCheckStrength = 8;
                            boundsCheckStrength = 8;
                            if (beginTarget.isFinalValue && endTarget.isFinalValue) {
                                system.addEquality(begin, beginTarget, beginAnchor.getMargin(), 8);
                                system.addEquality(end, endTarget, -endAnchor.getMargin(), 8);
                                return;
                            }
                        } else {
                            applyCentering = true;
                            rangeCheckStrength = 5;
                            boundsCheckStrength = 5;
                            applyBoundsCheck = true;
                            applyRangeCheck = true;
                        }
                        if (beginWidget instanceof Barrier || endWidget instanceof Barrier) {
                            boundsCheckStrength = 4;
                        }
                    } else if (matchConstraintDefault == 2) {
                        applyCentering = true;
                        rangeCheckStrength = 5;
                        boundsCheckStrength = 5;
                        applyBoundsCheck = true;
                        applyRangeCheck = true;
                        if (beginWidget instanceof Barrier || endWidget instanceof Barrier) {
                            boundsCheckStrength = 4;
                        }
                    } else if (matchConstraintDefault == 1) {
                        applyCentering = true;
                        applyRangeCheck = true;
                        rangeCheckStrength = 8;
                    } else if (matchConstraintDefault == 3) {
                        if (this.mResolvedDimensionRatioSide == -1) {
                            applyCentering = true;
                            applyRangeCheck = true;
                            applyStrongChecks = true;
                            rangeCheckStrength = 8;
                            boundsCheckStrength = 5;
                            if (oppositeInChain) {
                                boundsCheckStrength = 5;
                                centeringStrength = 4;
                                if (parentWrapContent) {
                                    centeringStrength = 5;
                                }
                            } else {
                                centeringStrength = 8;
                            }
                        } else {
                            applyCentering = true;
                            applyRangeCheck = true;
                            applyStrongChecks = true;
                            if (useRatio) {
                                boolean otherSideInvariable;
                                boolean bl = otherSideInvariable = oppositeMatchConstraintDefault == 2 || oppositeMatchConstraintDefault == 1;
                                if (!otherSideInvariable) {
                                    rangeCheckStrength = 8;
                                    boundsCheckStrength = 5;
                                }
                            } else {
                                rangeCheckStrength = 5;
                                if (matchMaxDimension > 0) {
                                    boundsCheckStrength = 5;
                                } else if (matchMaxDimension == 0 && matchMinDimension == 0) {
                                    if (!oppositeInChain) {
                                        boundsCheckStrength = 8;
                                    } else {
                                        rangeCheckStrength = beginWidget != parent && endWidget != parent ? 4 : 5;
                                        boundsCheckStrength = 4;
                                    }
                                }
                            }
                        }
                    }
                } else {
                    applyCentering = true;
                    applyRangeCheck = true;
                    if (beginTarget.isFinalValue && endTarget.isFinalValue) {
                        system.addCentering(begin, beginTarget, beginAnchor.getMargin(), bias, endTarget, end, endAnchor.getMargin(), 8);
                        if (parentWrapContent && isTerminal) {
                            int margin = 0;
                            if (endAnchor.mTarget != null) {
                                margin = endAnchor.getMargin();
                            }
                            if (endTarget != parentMax) {
                                system.addGreaterThan(parentMax, end, margin, wrapStrength);
                            }
                        }
                        return;
                    }
                }
                if (applyRangeCheck && beginTarget == endTarget && beginWidget != parent) {
                    applyRangeCheck = false;
                    applyBoundsCheck = false;
                }
                if (applyCentering) {
                    if (!(variableSize || oppositeVariable || oppositeInChain || beginTarget != parentMin || endTarget != parentMax)) {
                        centeringStrength = 8;
                        rangeCheckStrength = 8;
                        applyBoundsCheck = false;
                        parentWrapContent = false;
                    }
                    system.addCentering(begin, beginTarget, beginAnchor.getMargin(), bias, endTarget, end, endAnchor.getMargin(), centeringStrength);
                }
                if (this.mVisibility == 8 && !endAnchor.hasDependents()) {
                    return;
                }
                if (applyRangeCheck) {
                    if (parentWrapContent && beginTarget != endTarget && !variableSize && (beginWidget instanceof Barrier || endWidget instanceof Barrier)) {
                        rangeCheckStrength = 6;
                    }
                    system.addGreaterThan(begin, beginTarget, beginAnchor.getMargin(), rangeCheckStrength);
                    system.addLowerThan(end, endTarget, -endAnchor.getMargin(), rangeCheckStrength);
                }
                if (parentWrapContent && inBarrier && !(beginWidget instanceof Barrier) && !(endWidget instanceof Barrier) && endWidget != parent) {
                    boundsCheckStrength = 6;
                    rangeCheckStrength = 6;
                    applyBoundsCheck = true;
                }
                if (applyBoundsCheck) {
                    if (applyStrongChecks && (!oppositeInChain || oppositeParentWrapContent)) {
                        int strength = boundsCheckStrength;
                        if (beginWidget == parent || endWidget == parent) {
                            strength = 6;
                        }
                        if (beginWidget instanceof Guideline || endWidget instanceof Guideline) {
                            strength = 5;
                        }
                        if (beginWidget instanceof Barrier || endWidget instanceof Barrier) {
                            strength = 5;
                        }
                        if (oppositeInChain) {
                            strength = 5;
                        }
                        boundsCheckStrength = Math.max(strength, boundsCheckStrength);
                    }
                    if (parentWrapContent) {
                        boundsCheckStrength = Math.min(rangeCheckStrength, boundsCheckStrength);
                        if (useRatio && !oppositeInChain && (beginWidget == parent || endWidget == parent)) {
                            boundsCheckStrength = 4;
                        }
                    }
                    system.addEquality(begin, beginTarget, beginAnchor.getMargin(), boundsCheckStrength);
                    system.addEquality(end, endTarget, -endAnchor.getMargin(), boundsCheckStrength);
                }
                if (parentWrapContent) {
                    int margin = 0;
                    if (parentMin == beginTarget) {
                        margin = beginAnchor.getMargin();
                    }
                    if (beginTarget != parentMin) {
                        system.addGreaterThan(begin, parentMin, margin, wrapStrength);
                    }
                }
                if (parentWrapContent && variableSize && minDimension == 0 && matchMinDimension == 0) {
                    if (variableSize && matchConstraintDefault == 3) {
                        system.addGreaterThan(end, begin, 0, 8);
                    } else {
                        system.addGreaterThan(end, begin, 0, wrapStrength);
                    }
                }
            }
        }
        if (parentWrapContent && isTerminal) {
            int margin = 0;
            if (endAnchor.mTarget != null) {
                margin = endAnchor.getMargin();
            }
            if (endTarget != parentMax) {
                if (this.OPTIMIZE_WRAP && end.isFinalValue && this.mParent != null) {
                    ConstraintWidgetContainer container = (ConstraintWidgetContainer)this.mParent;
                    if (isHorizontal) {
                        container.addHorizontalWrapMaxVariable(endAnchor);
                    } else {
                        container.addVerticalWrapMaxVariable(endAnchor);
                    }
                    return;
                }
                system.addGreaterThan(parentMax, end, margin, wrapStrength);
            }
        }
    }

    public void updateFromSolver(LinearSystem system, boolean optimize) {
        int left = system.getObjectVariableValue(this.mLeft);
        int top = system.getObjectVariableValue(this.mTop);
        int right = system.getObjectVariableValue(this.mRight);
        int bottom = system.getObjectVariableValue(this.mBottom);
        if (optimize && this.horizontalRun != null && this.horizontalRun.start.resolved && this.horizontalRun.end.resolved) {
            left = this.horizontalRun.start.value;
            right = this.horizontalRun.end.value;
        }
        if (optimize && this.verticalRun != null && this.verticalRun.start.resolved && this.verticalRun.end.resolved) {
            top = this.verticalRun.start.value;
            bottom = this.verticalRun.end.value;
        }
        int w = right - left;
        int h = bottom - top;
        if (w < 0 || h < 0 || left == Integer.MIN_VALUE || left == Integer.MAX_VALUE || top == Integer.MIN_VALUE || top == Integer.MAX_VALUE || right == Integer.MIN_VALUE || right == Integer.MAX_VALUE || bottom == Integer.MIN_VALUE || bottom == Integer.MAX_VALUE) {
            left = 0;
            top = 0;
            right = 0;
            bottom = 0;
        }
        this.setFrame(left, top, right, bottom);
    }

    public void copy(ConstraintWidget src, HashMap<ConstraintWidget, ConstraintWidget> map) {
        this.mHorizontalResolution = src.mHorizontalResolution;
        this.mVerticalResolution = src.mVerticalResolution;
        this.mMatchConstraintDefaultWidth = src.mMatchConstraintDefaultWidth;
        this.mMatchConstraintDefaultHeight = src.mMatchConstraintDefaultHeight;
        this.mResolvedMatchConstraintDefault[0] = src.mResolvedMatchConstraintDefault[0];
        this.mResolvedMatchConstraintDefault[1] = src.mResolvedMatchConstraintDefault[1];
        this.mMatchConstraintMinWidth = src.mMatchConstraintMinWidth;
        this.mMatchConstraintMaxWidth = src.mMatchConstraintMaxWidth;
        this.mMatchConstraintMinHeight = src.mMatchConstraintMinHeight;
        this.mMatchConstraintMaxHeight = src.mMatchConstraintMaxHeight;
        this.mMatchConstraintPercentHeight = src.mMatchConstraintPercentHeight;
        this.mIsWidthWrapContent = src.mIsWidthWrapContent;
        this.mIsHeightWrapContent = src.mIsHeightWrapContent;
        this.mResolvedDimensionRatioSide = src.mResolvedDimensionRatioSide;
        this.mResolvedDimensionRatio = src.mResolvedDimensionRatio;
        this.mMaxDimension = Arrays.copyOf(src.mMaxDimension, src.mMaxDimension.length);
        this.mCircleConstraintAngle = src.mCircleConstraintAngle;
        this.hasBaseline = src.hasBaseline;
        this.inPlaceholder = src.inPlaceholder;
        this.mLeft.reset();
        this.mTop.reset();
        this.mRight.reset();
        this.mBottom.reset();
        this.mBaseline.reset();
        this.mCenterX.reset();
        this.mCenterY.reset();
        this.mCenter.reset();
        this.mListDimensionBehaviors = Arrays.copyOf(this.mListDimensionBehaviors, 2);
        this.mParent = this.mParent == null ? null : map.get(src.mParent);
        this.mWidth = src.mWidth;
        this.mHeight = src.mHeight;
        this.mDimensionRatio = src.mDimensionRatio;
        this.mDimensionRatioSide = src.mDimensionRatioSide;
        this.mX = src.mX;
        this.mY = src.mY;
        this.mRelX = src.mRelX;
        this.mRelY = src.mRelY;
        this.mOffsetX = src.mOffsetX;
        this.mOffsetY = src.mOffsetY;
        this.mBaselineDistance = src.mBaselineDistance;
        this.mMinWidth = src.mMinWidth;
        this.mMinHeight = src.mMinHeight;
        this.mHorizontalBiasPercent = src.mHorizontalBiasPercent;
        this.mVerticalBiasPercent = src.mVerticalBiasPercent;
        this.mCompanionWidget = src.mCompanionWidget;
        this.mContainerItemSkip = src.mContainerItemSkip;
        this.mVisibility = src.mVisibility;
        this.mDebugName = src.mDebugName;
        this.mType = src.mType;
        this.mDistToTop = src.mDistToTop;
        this.mDistToLeft = src.mDistToLeft;
        this.mDistToRight = src.mDistToRight;
        this.mDistToBottom = src.mDistToBottom;
        this.mLeftHasCentered = src.mLeftHasCentered;
        this.mRightHasCentered = src.mRightHasCentered;
        this.mTopHasCentered = src.mTopHasCentered;
        this.mBottomHasCentered = src.mBottomHasCentered;
        this.mHorizontalWrapVisited = src.mHorizontalWrapVisited;
        this.mVerticalWrapVisited = src.mVerticalWrapVisited;
        this.mHorizontalChainStyle = src.mHorizontalChainStyle;
        this.mVerticalChainStyle = src.mVerticalChainStyle;
        this.mHorizontalChainFixedPosition = src.mHorizontalChainFixedPosition;
        this.mVerticalChainFixedPosition = src.mVerticalChainFixedPosition;
        this.mWeight[0] = src.mWeight[0];
        this.mWeight[1] = src.mWeight[1];
        this.mListNextMatchConstraintsWidget[0] = src.mListNextMatchConstraintsWidget[0];
        this.mListNextMatchConstraintsWidget[1] = src.mListNextMatchConstraintsWidget[1];
        this.mNextChainWidget[0] = src.mNextChainWidget[0];
        this.mNextChainWidget[1] = src.mNextChainWidget[1];
        this.mHorizontalNextWidget = src.mHorizontalNextWidget == null ? null : map.get(src.mHorizontalNextWidget);
        this.mVerticalNextWidget = src.mVerticalNextWidget == null ? null : map.get(src.mVerticalNextWidget);
    }

    public void updateFromRuns(boolean updateHorizontal, boolean updateVertical) {
        updateHorizontal &= this.horizontalRun.isResolved();
        updateVertical &= this.verticalRun.isResolved();
        int left = this.horizontalRun.start.value;
        int top = this.verticalRun.start.value;
        int right = this.horizontalRun.end.value;
        int bottom = this.verticalRun.end.value;
        int w = right - left;
        int h = bottom - top;
        if (w < 0 || h < 0 || left == Integer.MIN_VALUE || left == Integer.MAX_VALUE || top == Integer.MIN_VALUE || top == Integer.MAX_VALUE || right == Integer.MIN_VALUE || right == Integer.MAX_VALUE || bottom == Integer.MIN_VALUE || bottom == Integer.MAX_VALUE) {
            left = 0;
            top = 0;
            right = 0;
            bottom = 0;
        }
        w = right - left;
        h = bottom - top;
        if (updateHorizontal) {
            this.mX = left;
        }
        if (updateVertical) {
            this.mY = top;
        }
        if (this.mVisibility == 8) {
            this.mWidth = 0;
            this.mHeight = 0;
            return;
        }
        if (updateHorizontal) {
            if (this.mListDimensionBehaviors[0] == DimensionBehaviour.FIXED && w < this.mWidth) {
                w = this.mWidth;
            }
            this.mWidth = w;
            if (this.mWidth < this.mMinWidth) {
                this.mWidth = this.mMinWidth;
            }
        }
        if (updateVertical) {
            if (this.mListDimensionBehaviors[1] == DimensionBehaviour.FIXED && h < this.mHeight) {
                h = this.mHeight;
            }
            this.mHeight = h;
            if (this.mHeight < this.mMinHeight) {
                this.mHeight = this.mMinHeight;
            }
        }
    }

    public void addChildrenToSolverByDependency(ConstraintWidgetContainer container, LinearSystem system, HashSet<ConstraintWidget> widgets, int orientation, boolean addSelf) {
        block12: {
            block11: {
                if (addSelf) {
                    if (!widgets.contains(this)) {
                        return;
                    }
                    Optimizer.checkMatchParent(container, system, this);
                    widgets.remove(this);
                    this.addToSolver(system, container.optimizeFor(64));
                }
                if (orientation != 0) break block11;
                HashSet<ConstraintAnchor> dependents = this.mLeft.getDependents();
                if (dependents != null) {
                    for (ConstraintAnchor anchor : dependents) {
                        anchor.mOwner.addChildrenToSolverByDependency(container, system, widgets, orientation, true);
                    }
                }
                if ((dependents = this.mRight.getDependents()) == null) break block12;
                for (ConstraintAnchor anchor : dependents) {
                    anchor.mOwner.addChildrenToSolverByDependency(container, system, widgets, orientation, true);
                }
                break block12;
            }
            HashSet<ConstraintAnchor> dependents = this.mTop.getDependents();
            if (dependents != null) {
                for (ConstraintAnchor anchor : dependents) {
                    anchor.mOwner.addChildrenToSolverByDependency(container, system, widgets, orientation, true);
                }
            }
            if ((dependents = this.mBottom.getDependents()) != null) {
                for (ConstraintAnchor anchor : dependents) {
                    anchor.mOwner.addChildrenToSolverByDependency(container, system, widgets, orientation, true);
                }
            }
            if ((dependents = this.mBaseline.getDependents()) != null) {
                for (ConstraintAnchor anchor : dependents) {
                    anchor.mOwner.addChildrenToSolverByDependency(container, system, widgets, orientation, true);
                }
            }
        }
    }

    public static enum DimensionBehaviour {
        FIXED,
        WRAP_CONTENT,
        MATCH_CONSTRAINT,
        MATCH_PARENT;

    }
}

