/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.constraintlayout.core.state.ConstraintReference;
import androidx.constraintlayout.core.state.Dimension;
import androidx.constraintlayout.core.state.HelperReference;
import androidx.constraintlayout.core.state.Reference;
import androidx.constraintlayout.core.state.helpers.AlignHorizontallyReference;
import androidx.constraintlayout.core.state.helpers.AlignVerticallyReference;
import androidx.constraintlayout.core.state.helpers.BarrierReference;
import androidx.constraintlayout.core.state.helpers.GuidelineReference;
import androidx.constraintlayout.core.state.helpers.HorizontalChainReference;
import androidx.constraintlayout.core.state.helpers.VerticalChainReference;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.HelperWidget;
import java.util.ArrayList;
import java.util.HashMap;

public class State {
    protected HashMap<Object, Reference> mReferences = new HashMap();
    protected HashMap<Object, HelperReference> mHelperReferences = new HashMap();
    HashMap<String, ArrayList<String>> mTags = new HashMap();
    static final int UNKNOWN = -1;
    static final int CONSTRAINT_SPREAD = 0;
    static final int CONSTRAINT_WRAP = 1;
    static final int CONSTRAINT_RATIO = 2;
    public static final Integer PARENT = 0;
    public final ConstraintReference mParent = new ConstraintReference(this);
    private int numHelpers = 0;

    public State() {
        this.mReferences.put(PARENT, this.mParent);
    }

    public void reset() {
        this.mHelperReferences.clear();
        this.mTags.clear();
    }

    public int convertDimension(Object value) {
        if (value instanceof Float) {
            return ((Float)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    public ConstraintReference createConstraintReference(Object key) {
        return new ConstraintReference(this);
    }

    public boolean sameFixedWidth(int width) {
        return this.mParent.getWidth().equalsFixedValue(width);
    }

    public boolean sameFixedHeight(int height) {
        return this.mParent.getHeight().equalsFixedValue(height);
    }

    public State width(Dimension dimension) {
        return this.setWidth(dimension);
    }

    public State height(Dimension dimension) {
        return this.setHeight(dimension);
    }

    public State setWidth(Dimension dimension) {
        this.mParent.setWidth(dimension);
        return this;
    }

    public State setHeight(Dimension dimension) {
        this.mParent.setHeight(dimension);
        return this;
    }

    Reference reference(Object key) {
        return this.mReferences.get(key);
    }

    public ConstraintReference constraints(Object key) {
        Reference reference = this.mReferences.get(key);
        if (reference == null) {
            reference = this.createConstraintReference(key);
            this.mReferences.put(key, reference);
            reference.setKey(key);
        }
        if (reference instanceof ConstraintReference) {
            return (ConstraintReference)reference;
        }
        return null;
    }

    private String createHelperKey() {
        return "__HELPER_KEY_" + this.numHelpers++ + "__";
    }

    public HelperReference helper(Object key, Helper type) {
        HelperReference reference;
        if (key == null) {
            key = this.createHelperKey();
        }
        if ((reference = this.mHelperReferences.get(key)) == null) {
            switch (type) {
                case HORIZONTAL_CHAIN: {
                    reference = new HorizontalChainReference(this);
                    break;
                }
                case VERTICAL_CHAIN: {
                    reference = new VerticalChainReference(this);
                    break;
                }
                case ALIGN_HORIZONTALLY: {
                    reference = new AlignHorizontallyReference(this);
                    break;
                }
                case ALIGN_VERTICALLY: {
                    reference = new AlignVerticallyReference(this);
                    break;
                }
                case BARRIER: {
                    reference = new BarrierReference(this);
                    break;
                }
                default: {
                    reference = new HelperReference(this, type);
                }
            }
            this.mHelperReferences.put(key, reference);
        }
        return reference;
    }

    public GuidelineReference horizontalGuideline(Object key) {
        return this.guideline(key, 0);
    }

    public GuidelineReference verticalGuideline(Object key) {
        return this.guideline(key, 1);
    }

    public GuidelineReference guideline(Object key, int orientation) {
        ConstraintReference reference = this.constraints(key);
        if (reference.getFacade() == null || !(reference.getFacade() instanceof GuidelineReference)) {
            GuidelineReference guidelineReference = new GuidelineReference(this);
            guidelineReference.setOrientation(orientation);
            guidelineReference.setKey(key);
            reference.setFacade(guidelineReference);
        }
        return (GuidelineReference)reference.getFacade();
    }

    public BarrierReference barrier(Object key, Direction direction) {
        ConstraintReference reference = this.constraints(key);
        if (reference.getFacade() == null || !(reference.getFacade() instanceof BarrierReference)) {
            BarrierReference barrierReference = new BarrierReference(this);
            barrierReference.setBarrierDirection(direction);
            reference.setFacade(barrierReference);
        }
        return (BarrierReference)reference.getFacade();
    }

    public VerticalChainReference verticalChain() {
        return (VerticalChainReference)this.helper(null, Helper.VERTICAL_CHAIN);
    }

    public VerticalChainReference verticalChain(Object ... references) {
        VerticalChainReference reference = (VerticalChainReference)this.helper(null, Helper.VERTICAL_CHAIN);
        reference.add(references);
        return reference;
    }

    public HorizontalChainReference horizontalChain() {
        return (HorizontalChainReference)this.helper(null, Helper.HORIZONTAL_CHAIN);
    }

    public HorizontalChainReference horizontalChain(Object ... references) {
        HorizontalChainReference reference = (HorizontalChainReference)this.helper(null, Helper.HORIZONTAL_CHAIN);
        reference.add(references);
        return reference;
    }

    public AlignHorizontallyReference centerHorizontally(Object ... references) {
        AlignHorizontallyReference reference = (AlignHorizontallyReference)this.helper(null, Helper.ALIGN_HORIZONTALLY);
        reference.add(references);
        return reference;
    }

    public AlignVerticallyReference centerVertically(Object ... references) {
        AlignVerticallyReference reference = (AlignVerticallyReference)this.helper(null, Helper.ALIGN_VERTICALLY);
        reference.add(references);
        return reference;
    }

    public void directMapping() {
        for (Object key : this.mReferences.keySet()) {
            ConstraintReference ref = this.constraints(key);
            if (!(ref instanceof ConstraintReference)) continue;
            ConstraintReference reference = ref;
            reference.setView(key);
        }
    }

    public void map(Object key, Object view) {
        ConstraintReference ref = this.constraints(key);
        if (ref instanceof ConstraintReference) {
            ConstraintReference reference = ref;
            reference.setView(view);
        }
    }

    public void setTag(String key, String tag) {
        ConstraintReference ref = this.constraints(key);
        if (ref instanceof ConstraintReference) {
            ConstraintReference reference = ref;
            reference.setTag(tag);
            ArrayList<Object> list = null;
            if (!this.mTags.containsKey(tag)) {
                list = new ArrayList();
                this.mTags.put(tag, list);
            } else {
                list = this.mTags.get(tag);
            }
            list.add(key);
        }
    }

    public ArrayList<String> getIdsForTag(String tag) {
        if (this.mTags.containsKey(tag)) {
            return this.mTags.get(tag);
        }
        return null;
    }

    public void apply(ConstraintWidgetContainer container) {
        ConstraintWidget widget;
        Object constraintReference;
        HelperWidget helperWidget;
        Reference reference;
        container.removeAllChildren();
        this.mParent.getWidth().apply(this, container, 0);
        this.mParent.getHeight().apply(this, container, 1);
        for (Object key : this.mHelperReferences.keySet()) {
            reference = this.mHelperReferences.get(key);
            helperWidget = ((HelperReference)reference).getHelperWidget();
            if (helperWidget == null) continue;
            constraintReference = this.mReferences.get(key);
            if (constraintReference == null) {
                constraintReference = this.constraints(key);
            }
            constraintReference.setConstraintWidget(helperWidget);
        }
        for (Object key : this.mReferences.keySet()) {
            reference = this.mReferences.get(key);
            if (reference == this.mParent || !(reference.getFacade() instanceof HelperReference) || (helperWidget = ((HelperReference)reference.getFacade()).getHelperWidget()) == null) continue;
            constraintReference = this.mReferences.get(key);
            if (constraintReference == null) {
                constraintReference = this.constraints(key);
            }
            constraintReference.setConstraintWidget(helperWidget);
        }
        for (Object key : this.mReferences.keySet()) {
            reference = this.mReferences.get(key);
            if (reference != this.mParent) {
                widget = reference.getConstraintWidget();
                widget.setDebugName(reference.getKey().toString());
                widget.setParent(null);
                if (reference.getFacade() instanceof GuidelineReference) {
                    reference.apply();
                }
                container.add(widget);
                continue;
            }
            reference.setConstraintWidget(container);
        }
        for (Object key : this.mHelperReferences.keySet()) {
            reference = this.mHelperReferences.get(key);
            helperWidget = ((HelperReference)reference).getHelperWidget();
            if (helperWidget != null) {
                for (Object e : ((HelperReference)reference).mReferences) {
                    Reference constraintReference2 = this.mReferences.get(e);
                    ((HelperReference)reference).getHelperWidget().add(constraintReference2.getConstraintWidget());
                }
                ((HelperReference)reference).apply();
                continue;
            }
            ((HelperReference)reference).apply();
        }
        for (Object key : this.mReferences.keySet()) {
            HelperReference helperReference;
            HelperWidget helperWidget2;
            reference = this.mReferences.get(key);
            if (reference == this.mParent || !(reference.getFacade() instanceof HelperReference) || (helperWidget2 = (helperReference = (HelperReference)reference.getFacade()).getHelperWidget()) == null) continue;
            for (Object keyRef : helperReference.mReferences) {
                Reference constraintReference3 = this.mReferences.get(keyRef);
                if (constraintReference3 != null) {
                    helperWidget2.add(constraintReference3.getConstraintWidget());
                    continue;
                }
                if (keyRef instanceof Reference) {
                    helperWidget2.add(((Reference)keyRef).getConstraintWidget());
                    continue;
                }
                System.out.println("couldn't find reference for " + keyRef);
            }
            reference.apply();
        }
        for (Object key : this.mReferences.keySet()) {
            reference = this.mReferences.get(key);
            reference.apply();
            widget = reference.getConstraintWidget();
            if (widget == null || !(key instanceof String)) continue;
            widget.stringId = (String)key;
        }
    }

    public static enum Chain {
        SPREAD,
        SPREAD_INSIDE,
        PACKED;

    }

    public static enum Helper {
        HORIZONTAL_CHAIN,
        VERTICAL_CHAIN,
        ALIGN_HORIZONTALLY,
        ALIGN_VERTICALLY,
        BARRIER,
        LAYER,
        FLOW;

    }

    public static enum Direction {
        LEFT,
        RIGHT,
        START,
        END,
        TOP,
        BOTTOM;

    }

    public static enum Constraint {
        LEFT_TO_LEFT,
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT,
        RIGHT_TO_RIGHT,
        START_TO_START,
        START_TO_END,
        END_TO_START,
        END_TO_END,
        TOP_TO_TOP,
        TOP_TO_BOTTOM,
        BOTTOM_TO_TOP,
        BOTTOM_TO_BOTTOM,
        BASELINE_TO_BASELINE,
        CENTER_HORIZONTALLY,
        CENTER_VERTICALLY,
        CIRCULAR_CONSTRAINT;

    }
}

