/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.utils.Easing;

public class Schlick
extends Easing {
    private static final boolean DEBUG = false;
    double mS;
    double mT;
    double eps;

    Schlick(String configString) {
        this.str = configString;
        int start = configString.indexOf(40);
        int off1 = configString.indexOf(44, start);
        this.mS = Double.parseDouble(configString.substring(start + 1, off1).trim());
        int off2 = configString.indexOf(44, off1 + 1);
        this.mT = Double.parseDouble(configString.substring(off1 + 1, off2).trim());
    }

    private double func(double x) {
        if (x < this.mT) {
            return this.mT * x / (x + this.mS * (this.mT - x));
        }
        return (1.0 - this.mT) * (x - 1.0) / (1.0 - x - this.mS * (this.mT - x));
    }

    private double dfunc(double x) {
        if (x < this.mT) {
            return this.mS * this.mT * this.mT / ((this.mS * (this.mT - x) + x) * (this.mS * (this.mT - x) + x));
        }
        return this.mS * (this.mT - 1.0) * (this.mT - 1.0) / ((-this.mS * (this.mT - x) - x + 1.0) * (-this.mS * (this.mT - x) - x + 1.0));
    }

    @Override
    public double getDiff(double x) {
        return this.dfunc(x);
    }

    @Override
    public double get(double x) {
        return this.func(x);
    }
}

