/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import android.graphics.Typeface;
import android.os.Build;
import androidx.collection.LruCache;
import androidx.compose.ui.text.font.DefaultFontFamily;
import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontListFontFamily;
import androidx.compose.ui.text.font.FontMatcher;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontSynthesis;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.font.GenericFontFamily;
import androidx.compose.ui.text.font.LoadedFontFamily;
import androidx.compose.ui.text.platform.AndroidTypeface;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0010\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0016J.\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00152\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Landroidx/compose/ui/text/platform/TypefaceAdapter;", "", "fontMatcher", "Landroidx/compose/ui/text/font/FontMatcher;", "resourceLoader", "Landroidx/compose/ui/text/font/Font$ResourceLoader;", "(Landroidx/compose/ui/text/font/FontMatcher;Landroidx/compose/ui/text/font/Font$ResourceLoader;)V", "getFontMatcher", "()Landroidx/compose/ui/text/font/FontMatcher;", "getResourceLoader", "()Landroidx/compose/ui/text/font/Font$ResourceLoader;", "create", "Landroid/graphics/Typeface;", "fontFamily", "Landroidx/compose/ui/text/font/FontFamily;", "fontWeight", "Landroidx/compose/ui/text/font/FontWeight;", "fontStyle", "Landroidx/compose/ui/text/font/FontStyle;", "fontSynthesis", "Landroidx/compose/ui/text/font/FontSynthesis;", "Landroidx/compose/ui/text/font/FontListFontFamily;", "genericFontFamily", "", "CacheKey", "Companion", "ui-text_release"})
public class TypefaceAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FontMatcher fontMatcher;
    @NotNull
    private final Font.ResourceLoader resourceLoader;
    @NotNull
    private static final FontWeight ANDROID_BOLD = FontWeight.Companion.getW600();
    @NotNull
    private static final LruCache<CacheKey, Typeface> typefaceCache = new LruCache(16);

    public TypefaceAdapter(@NotNull FontMatcher fontMatcher, @NotNull Font.ResourceLoader resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)fontMatcher, (String)"fontMatcher");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        this.fontMatcher = fontMatcher;
        this.resourceLoader = resourceLoader;
    }

    public /* synthetic */ TypefaceAdapter(FontMatcher fontMatcher, Font.ResourceLoader resourceLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            fontMatcher = new FontMatcher();
        }
        this(fontMatcher, resourceLoader);
    }

    @NotNull
    public final FontMatcher getFontMatcher() {
        return this.fontMatcher;
    }

    @NotNull
    public final Font.ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @NotNull
    public Typeface create(@Nullable FontFamily fontFamily, @NotNull FontWeight fontWeight, @NotNull FontStyle fontStyle, @NotNull FontSynthesis fontSynthesis) {
        Typeface typeface;
        Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"fontWeight");
        Intrinsics.checkNotNullParameter((Object)((Object)fontStyle), (String)"fontStyle");
        Intrinsics.checkNotNullParameter((Object)((Object)fontSynthesis), (String)"fontSynthesis");
        CacheKey cacheKey = new CacheKey(fontFamily, fontWeight, fontStyle, fontSynthesis);
        Typeface cachedTypeface = (Typeface)Companion.getTypefaceCache().get((Object)cacheKey);
        if (cachedTypeface != null) {
            return cachedTypeface;
        }
        FontFamily fontFamily2 = fontFamily;
        if (fontFamily2 instanceof FontListFontFamily) {
            typeface = this.create(fontStyle, fontWeight, (FontListFontFamily)fontFamily, fontSynthesis);
        } else if (fontFamily2 instanceof GenericFontFamily) {
            typeface = this.create(((GenericFontFamily)fontFamily).getName(), fontWeight, fontStyle);
        } else if (fontFamily2 instanceof DefaultFontFamily ? true : fontFamily2 == null) {
            typeface = this.create(null, fontWeight, fontStyle);
        } else if (fontFamily2 instanceof LoadedFontFamily) {
            typeface = ((AndroidTypeface)((LoadedFontFamily)fontFamily).getTypeface()).getNativeTypeface(fontWeight, fontStyle, fontSynthesis);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Typeface typeface2 = typeface;
        Companion.getTypefaceCache().put((Object)cacheKey, (Object)typeface2);
        return typeface2;
    }

    public static /* synthetic */ Typeface create$default(TypefaceAdapter typefaceAdapter, FontFamily fontFamily, FontWeight fontWeight, FontStyle fontStyle, FontSynthesis fontSynthesis, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 1) != 0) {
            fontFamily = null;
        }
        if ((n & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n & 4) != 0) {
            fontStyle = FontStyle.Normal;
        }
        if ((n & 8) != 0) {
            fontSynthesis = FontSynthesis.All;
        }
        return typefaceAdapter.create(fontFamily, fontWeight, fontStyle, fontSynthesis);
    }

    private final Typeface create(String genericFontFamily, FontWeight fontWeight, FontStyle fontStyle) {
        CharSequence charSequence;
        CharSequence charSequence2;
        if (fontStyle == FontStyle.Normal && Intrinsics.areEqual((Object)fontWeight, (Object)FontWeight.Companion.getNormal())) {
            charSequence2 = genericFontFamily;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence2 == null || charSequence2.length() == 0) {
                charSequence2 = Typeface.DEFAULT;
                Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"DEFAULT");
                return charSequence2;
            }
        }
        if (Build.VERSION.SDK_INT < 28) {
            int targetStyle = Companion.getTypefaceStyle(fontWeight, fontStyle);
            CharSequence charSequence3 = genericFontFamily;
            boolean bl = false;
            boolean bl3 = false;
            charSequence2 = charSequence3 == null || charSequence3.length() == 0 ? Typeface.defaultFromStyle((int)targetStyle) : Typeface.create((String)genericFontFamily, (int)targetStyle);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"{\n            val targetStyle = getTypefaceStyle(fontWeight, fontStyle)\n            if (genericFontFamily.isNullOrEmpty()) {\n                Typeface.defaultFromStyle(targetStyle)\n            } else {\n                Typeface.create(genericFontFamily, targetStyle)\n            }\n        }");
            charSequence = charSequence2;
        } else {
            Typeface familyTypeface = genericFontFamily == null ? Typeface.DEFAULT : Typeface.create((String)genericFontFamily, (int)0);
            charSequence2 = Typeface.create((Typeface)familyTypeface, (int)fontWeight.getWeight(), (fontStyle == FontStyle.Italic ? 1 : 0) != 0);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"{\n            val familyTypeface = if (genericFontFamily == null) {\n                Typeface.DEFAULT\n            } else {\n                Typeface.create(genericFontFamily, Typeface.NORMAL)\n            }\n\n            Typeface.create(\n                familyTypeface,\n                fontWeight.weight,\n                fontStyle == FontStyle.Italic\n            )\n        }");
            charSequence = charSequence2;
        }
        return charSequence;
    }

    static /* synthetic */ Typeface create$default(TypefaceAdapter typefaceAdapter, String string, FontWeight fontWeight, FontStyle fontStyle, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n & 4) != 0) {
            fontStyle = FontStyle.Normal;
        }
        return typefaceAdapter.create(string, fontWeight, fontStyle);
    }

    private final Typeface create(FontStyle fontStyle, FontWeight fontWeight, FontListFontFamily fontFamily, FontSynthesis fontSynthesis) {
        boolean loadedFontIsSameAsRequest;
        Typeface typeface;
        Font font = this.fontMatcher.matchFont(fontFamily, fontWeight, fontStyle);
        try {
            typeface = (Typeface)this.resourceLoader.load(font);
        }
        catch (Exception e) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Cannot create Typeface from ", (Object)font));
        }
        Typeface typeface2 = typeface;
        boolean bl = loadedFontIsSameAsRequest = Intrinsics.areEqual((Object)fontWeight, (Object)font.getWeight()) && fontStyle == font.getStyle();
        if (fontSynthesis == FontSynthesis.None || loadedFontIsSameAsRequest) {
            return typeface2;
        }
        return Companion.synthesize(typeface2, font, fontWeight, fontStyle, fontSynthesis);
    }

    static /* synthetic */ Typeface create$default(TypefaceAdapter typefaceAdapter, FontStyle fontStyle, FontWeight fontWeight, FontListFontFamily fontListFontFamily, FontSynthesis fontSynthesis, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 1) != 0) {
            fontStyle = FontStyle.Normal;
        }
        if ((n & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n & 8) != 0) {
            fontSynthesis = FontSynthesis.All;
        }
        return typefaceAdapter.create(fontStyle, fontWeight, fontListFontFamily, fontSynthesis);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J3\u0010\u0017\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Landroidx/compose/ui/text/platform/TypefaceAdapter$CacheKey;", "", "fontFamily", "Landroidx/compose/ui/text/font/FontFamily;", "fontWeight", "Landroidx/compose/ui/text/font/FontWeight;", "fontStyle", "Landroidx/compose/ui/text/font/FontStyle;", "fontSynthesis", "Landroidx/compose/ui/text/font/FontSynthesis;", "(Landroidx/compose/ui/text/font/FontFamily;Landroidx/compose/ui/text/font/FontWeight;Landroidx/compose/ui/text/font/FontStyle;Landroidx/compose/ui/text/font/FontSynthesis;)V", "getFontFamily", "()Landroidx/compose/ui/text/font/FontFamily;", "getFontStyle", "()Landroidx/compose/ui/text/font/FontStyle;", "getFontSynthesis", "()Landroidx/compose/ui/text/font/FontSynthesis;", "getFontWeight", "()Landroidx/compose/ui/text/font/FontWeight;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ui-text_release"})
    public static final class CacheKey {
        @Nullable
        private final FontFamily fontFamily;
        @NotNull
        private final FontWeight fontWeight;
        @NotNull
        private final FontStyle fontStyle;
        @NotNull
        private final FontSynthesis fontSynthesis;

        public CacheKey(@Nullable FontFamily fontFamily, @NotNull FontWeight fontWeight, @NotNull FontStyle fontStyle, @NotNull FontSynthesis fontSynthesis) {
            Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"fontWeight");
            Intrinsics.checkNotNullParameter((Object)((Object)fontStyle), (String)"fontStyle");
            Intrinsics.checkNotNullParameter((Object)((Object)fontSynthesis), (String)"fontSynthesis");
            this.fontFamily = fontFamily;
            this.fontWeight = fontWeight;
            this.fontStyle = fontStyle;
            this.fontSynthesis = fontSynthesis;
        }

        public /* synthetic */ CacheKey(FontFamily fontFamily, FontWeight fontWeight, FontStyle fontStyle, FontSynthesis fontSynthesis, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                fontFamily = null;
            }
            this(fontFamily, fontWeight, fontStyle, fontSynthesis);
        }

        @Nullable
        public final FontFamily getFontFamily() {
            return this.fontFamily;
        }

        @NotNull
        public final FontWeight getFontWeight() {
            return this.fontWeight;
        }

        @NotNull
        public final FontStyle getFontStyle() {
            return this.fontStyle;
        }

        @NotNull
        public final FontSynthesis getFontSynthesis() {
            return this.fontSynthesis;
        }

        @Nullable
        public final FontFamily component1() {
            return this.fontFamily;
        }

        @NotNull
        public final FontWeight component2() {
            return this.fontWeight;
        }

        @NotNull
        public final FontStyle component3() {
            return this.fontStyle;
        }

        @NotNull
        public final FontSynthesis component4() {
            return this.fontSynthesis;
        }

        @NotNull
        public final CacheKey copy(@Nullable FontFamily fontFamily, @NotNull FontWeight fontWeight, @NotNull FontStyle fontStyle, @NotNull FontSynthesis fontSynthesis) {
            Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"fontWeight");
            Intrinsics.checkNotNullParameter((Object)((Object)fontStyle), (String)"fontStyle");
            Intrinsics.checkNotNullParameter((Object)((Object)fontSynthesis), (String)"fontSynthesis");
            return new CacheKey(fontFamily, fontWeight, fontStyle, fontSynthesis);
        }

        public static /* synthetic */ CacheKey copy$default(CacheKey cacheKey, FontFamily fontFamily, FontWeight fontWeight, FontStyle fontStyle, FontSynthesis fontSynthesis, int n, Object object) {
            if ((n & 1) != 0) {
                fontFamily = cacheKey.fontFamily;
            }
            if ((n & 2) != 0) {
                fontWeight = cacheKey.fontWeight;
            }
            if ((n & 4) != 0) {
                fontStyle = cacheKey.fontStyle;
            }
            if ((n & 8) != 0) {
                fontSynthesis = cacheKey.fontSynthesis;
            }
            return cacheKey.copy(fontFamily, fontWeight, fontStyle, fontSynthesis);
        }

        @NotNull
        public String toString() {
            return "CacheKey(fontFamily=" + this.fontFamily + ", fontWeight=" + this.fontWeight + ", fontStyle=" + (Object)((Object)this.fontStyle) + ", fontSynthesis=" + (Object)((Object)this.fontSynthesis) + ')';
        }

        public int hashCode() {
            int result = this.fontFamily == null ? 0 : this.fontFamily.hashCode();
            result = result * 31 + this.fontWeight.hashCode();
            result = result * 31 + this.fontStyle.hashCode();
            result = result * 31 + this.fontSynthesis.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)other;
            if (!Intrinsics.areEqual((Object)this.fontFamily, (Object)cacheKey.fontFamily)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fontWeight, (Object)cacheKey.fontWeight)) {
                return false;
            }
            if (this.fontStyle != cacheKey.fontStyle) {
                return false;
            }
            return this.fontSynthesis == cacheKey.fontSynthesis;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J.\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Landroidx/compose/ui/text/platform/TypefaceAdapter$Companion;", "", "()V", "ANDROID_BOLD", "Landroidx/compose/ui/text/font/FontWeight;", "typefaceCache", "Landroidx/collection/LruCache;", "Landroidx/compose/ui/text/platform/TypefaceAdapter$CacheKey;", "Landroid/graphics/Typeface;", "getTypefaceCache", "()Landroidx/collection/LruCache;", "getTypefaceStyle", "", "fontWeight", "fontStyle", "Landroidx/compose/ui/text/font/FontStyle;", "isBold", "", "isItalic", "synthesize", "typeface", "font", "Landroidx/compose/ui/text/font/Font;", "fontSynthesis", "Landroidx/compose/ui/text/font/FontSynthesis;", "ui-text_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LruCache<CacheKey, Typeface> getTypefaceCache() {
            return typefaceCache;
        }

        @NotNull
        public final Typeface synthesize(@NotNull Typeface typeface, @NotNull Font font, @NotNull FontWeight fontWeight, @NotNull FontStyle fontStyle, @NotNull FontSynthesis fontSynthesis) {
            Typeface typeface2;
            boolean synthesizeStyle;
            Intrinsics.checkNotNullParameter((Object)typeface, (String)"typeface");
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"fontWeight");
            Intrinsics.checkNotNullParameter((Object)((Object)fontStyle), (String)"fontStyle");
            Intrinsics.checkNotNullParameter((Object)((Object)fontSynthesis), (String)"fontSynthesis");
            boolean synthesizeWeight = fontSynthesis.isWeightOn$ui_text_release() && fontWeight.compareTo(ANDROID_BOLD) >= 0 && font.getWeight().compareTo(ANDROID_BOLD) < 0;
            boolean bl = synthesizeStyle = fontSynthesis.isStyleOn$ui_text_release() && fontStyle != font.getStyle();
            if (!synthesizeStyle && !synthesizeWeight) {
                return typeface;
            }
            if (Build.VERSION.SDK_INT < 28) {
                int targetStyle = this.getTypefaceStyle(synthesizeWeight, synthesizeStyle && fontStyle == FontStyle.Italic);
                Typeface typeface3 = Typeface.create((Typeface)typeface, (int)targetStyle);
                Intrinsics.checkNotNullExpressionValue((Object)typeface3, (String)"{\n                val targetStyle = getTypefaceStyle(\n                    isBold = synthesizeWeight,\n                    isItalic = synthesizeStyle && fontStyle == FontStyle.Italic\n                )\n                Typeface.create(typeface, targetStyle)\n            }");
                typeface2 = typeface3;
            } else {
                int finalFontWeight;
                int n = finalFontWeight = synthesizeWeight ? fontWeight.getWeight() : font.getWeight().getWeight();
                boolean finalFontStyle = synthesizeStyle ? fontStyle == FontStyle.Italic : font.getStyle() == FontStyle.Italic;
                Typeface typeface4 = Typeface.create((Typeface)typeface, (int)finalFontWeight, (boolean)finalFontStyle);
                Intrinsics.checkNotNullExpressionValue((Object)typeface4, (String)"{\n                val finalFontWeight = if (synthesizeWeight) {\n                    // if we want to synthesize weight, we send the requested fontWeight\n                    fontWeight.weight\n                } else {\n                    // if we do not want to synthesize weight, we keep the loaded font weight\n                    font.weight.weight\n                }\n\n                val finalFontStyle = if (synthesizeStyle) {\n                    // if we want to synthesize style, we send the requested fontStyle\n                    fontStyle == FontStyle.Italic\n                } else {\n                    // if we do not want to synthesize style, we keep the loaded font style\n                    font.style == FontStyle.Italic\n                }\n\n                Typeface.create(typeface, finalFontWeight, finalFontStyle)\n            }");
                typeface2 = typeface4;
            }
            return typeface2;
        }

        public final int getTypefaceStyle(@NotNull FontWeight fontWeight, @NotNull FontStyle fontStyle) {
            Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"fontWeight");
            Intrinsics.checkNotNullParameter((Object)((Object)fontStyle), (String)"fontStyle");
            return this.getTypefaceStyle(fontWeight.compareTo(ANDROID_BOLD) >= 0, fontStyle == FontStyle.Italic);
        }

        private final int getTypefaceStyle(boolean isBold, boolean isItalic) {
            return isItalic && isBold ? 3 : (isBold ? 1 : (isItalic ? 2 : 0));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

