/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import android.graphics.Typeface;
import android.os.Build;
import androidx.annotation.GuardedBy;
import androidx.collection.SparseArrayCompat;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontSynthesis;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.font.GenericFontFamily;
import androidx.compose.ui.text.platform.AndroidTypeface;
import androidx.compose.ui.text.platform.TypefaceAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u000e\u001a\n \u000f*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0002\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/compose/ui/text/platform/AndroidGenericFontFamilyTypeface;", "Landroidx/compose/ui/text/platform/AndroidTypeface;", "fontFamily", "Landroidx/compose/ui/text/font/GenericFontFamily;", "(Landroidx/compose/ui/text/font/GenericFontFamily;)V", "Landroidx/compose/ui/text/font/FontFamily;", "getFontFamily", "()Landroidx/compose/ui/text/font/FontFamily;", "lock", "", "nativeTypeface", "Landroid/graphics/Typeface;", "styledCache", "Landroidx/collection/SparseArrayCompat;", "buildStyledTypeface", "kotlin.jvm.PlatformType", "fontWeight", "Landroidx/compose/ui/text/font/FontWeight;", "fontStyle", "Landroidx/compose/ui/text/font/FontStyle;", "getNativeTypeface", "synthesis", "Landroidx/compose/ui/text/font/FontSynthesis;", "getOrPut", "ui-text_release"})
public final class AndroidGenericFontFamilyTypeface
implements AndroidTypeface {
    @NotNull
    private final FontFamily fontFamily;
    @NotNull
    private final Typeface nativeTypeface;
    @NotNull
    private final Object lock;
    @GuardedBy(value="lock")
    @NotNull
    private final SparseArrayCompat<Typeface> styledCache;

    public AndroidGenericFontFamilyTypeface(@NotNull GenericFontFamily fontFamily) {
        Intrinsics.checkNotNullParameter((Object)fontFamily, (String)"fontFamily");
        this.fontFamily = fontFamily;
        Typeface typeface = Typeface.create((String)fontFamily.getName(), (int)0);
        Intrinsics.checkNotNull((Object)typeface);
        this.nativeTypeface = typeface;
        this.lock = new Object();
        this.styledCache = new SparseArrayCompat(4);
    }

    @Override
    @NotNull
    public FontFamily getFontFamily() {
        return this.fontFamily;
    }

    @Override
    @NotNull
    public Typeface getNativeTypeface(@NotNull FontWeight fontWeight, @NotNull FontStyle fontStyle, @NotNull FontSynthesis synthesis) {
        Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"fontWeight");
        Intrinsics.checkNotNullParameter((Object)((Object)fontStyle), (String)"fontStyle");
        Intrinsics.checkNotNullParameter((Object)((Object)synthesis), (String)"synthesis");
        return this.getOrPut(fontWeight, fontStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Typeface getOrPut(@NotNull FontWeight fontWeight, @NotNull FontStyle fontStyle) {
        Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"fontWeight");
        Intrinsics.checkNotNullParameter((Object)((Object)fontStyle), (String)"fontStyle");
        int key = fontWeight.getWeight() << 1 | (fontStyle == FontStyle.Italic ? 1 : 0);
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            Typeface typeface;
            boolean bl3 = false;
            Typeface typeface2 = (Typeface)this.styledCache.get(key);
            if (typeface2 == null) {
                Typeface typeface3 = this.buildStyledTypeface(fontWeight, fontStyle);
                boolean bl4 = false;
                boolean bl5 = false;
                Typeface it = typeface3;
                boolean bl6 = false;
                this.styledCache.append(key, (Object)it);
                Typeface typeface4 = typeface3;
                Intrinsics.checkNotNullExpressionValue((Object)typeface4, (String)"buildStyledTypeface(fontWeight, fontStyle).also {\n                styledCache.append(key, it)\n            }");
                typeface = typeface4;
            } else {
                typeface = typeface2;
            }
            Typeface typeface5 = typeface;
            return typeface5;
        }
    }

    private final Typeface buildStyledTypeface(FontWeight fontWeight, FontStyle fontStyle) {
        return Build.VERSION.SDK_INT < 28 ? Typeface.create((Typeface)this.nativeTypeface, (int)TypefaceAdapter.Companion.getTypefaceStyle(fontWeight, fontStyle)) : Typeface.create((Typeface)this.nativeTypeface, (int)fontWeight.getWeight(), (fontStyle == FontStyle.Italic ? 1 : 0) != 0);
    }
}

