/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import android.content.Context;
import android.graphics.Typeface;
import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontListFontFamily;
import androidx.compose.ui.text.font.FontMatcher;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontSynthesis;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.platform.AndroidTypeface;
import androidx.compose.ui.text.platform.AndroidTypefaceCache;
import androidx.compose.ui.text.platform.TypefaceAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001c\b\u0002\u0010\u0006\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0018\u00010\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ \u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0002\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u000b\u001a\u00020\f\u00a2\u0006\n\n\u0002\b\u0013\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/compose/ui/text/platform/AndroidFontListTypeface;", "Landroidx/compose/ui/text/platform/AndroidTypeface;", "fontFamily", "Landroidx/compose/ui/text/font/FontListFontFamily;", "context", "Landroid/content/Context;", "necessaryStyles", "", "Lkotlin/Pair;", "Landroidx/compose/ui/text/font/FontWeight;", "Landroidx/compose/ui/text/font/FontStyle;", "fontMatcher", "Landroidx/compose/ui/text/font/FontMatcher;", "(Landroidx/compose/ui/text/font/FontListFontFamily;Landroid/content/Context;Ljava/util/List;Landroidx/compose/ui/text/font/FontMatcher;)V", "Landroidx/compose/ui/text/font/FontFamily;", "getFontFamily", "()Landroidx/compose/ui/text/font/FontFamily;", "getFontMatcher", "()Landroidx/compose/ui/text/font/FontMatcher;", "fontMatcher$1", "loadedTypefaces", "", "Landroidx/compose/ui/text/font/Font;", "Landroid/graphics/Typeface;", "getNativeTypeface", "fontWeight", "fontStyle", "synthesis", "Landroidx/compose/ui/text/font/FontSynthesis;", "Companion", "ui-text_release"})
public final class AndroidFontListTypeface
implements AndroidTypeface {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final FontMatcher fontMatcher$1;
    @NotNull
    private final Map<Font, Typeface> loadedTypefaces;
    @NotNull
    private final FontFamily fontFamily;
    @NotNull
    private static final FontMatcher fontMatcher = new FontMatcher();

    /*
     * WARNING - void declaration
     */
    public AndroidFontListTypeface(@NotNull FontListFontFamily fontFamily, @NotNull Context context, @Nullable List<? extends Pair<FontWeight, ? extends FontStyle>> necessaryStyles, @NotNull FontMatcher fontMatcher) {
        Pair pair;
        List list;
        Intrinsics.checkNotNullParameter((Object)fontFamily, (String)"fontFamily");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fontMatcher, (String)"fontMatcher");
        this.fontMatcher$1 = fontMatcher;
        List<? extends Pair<FontWeight, ? extends FontStyle>> list2 = necessaryStyles;
        if (list2 == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $dstr$weight$style;
                pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FontWeight weight = (FontWeight)$dstr$weight$style.component1();
                FontStyle style = (FontStyle)((Object)$dstr$weight$style.component2());
                Font font = this.getFontMatcher().matchFont(fontFamily, weight, style);
                collection.add(font);
            }
            List list3 = (List)destination$iv$iv;
            list = CollectionsKt.distinct((Iterable)list3);
        }
        List list4 = list;
        List targetFonts = list4 == null ? fontFamily.getFonts() : list4;
        boolean bl = false;
        Map typefaces = new LinkedHashMap();
        List $this$fastForEach$iv = targetFonts;
        boolean $i$f$fastForEach = false;
        int n = 0;
        n = 0;
        int n2 = $this$fastForEach$iv.size() + -1;
        if (n <= n2) {
            do {
                int index$iv = n++;
                Object item$iv = $this$fastForEach$iv.get(index$iv);
                Font it = (Font)item$iv;
                boolean bl2 = false;
                try {
                    Object item$iv$iv;
                    item$iv$iv = typefaces;
                    pair = AndroidTypefaceCache.INSTANCE.getOrCreate(context, it);
                    boolean bl3 = false;
                    item$iv$iv.put((Font)it, (Pair)pair);
                }
                catch (Exception e) {
                    throw new IllegalStateException(Intrinsics.stringPlus((String)"Cannot create Typeface from ", (Object)it));
                }
            } while (n <= n2);
        }
        this.loadedTypefaces = typefaces;
        this.fontFamily = fontFamily;
    }

    public /* synthetic */ AndroidFontListTypeface(FontListFontFamily fontListFontFamily, Context context, List list, FontMatcher fontMatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = null;
        }
        if ((n & 8) != 0) {
            fontMatcher = Companion.getFontMatcher();
        }
        this(fontListFontFamily, context, list, fontMatcher);
    }

    @NotNull
    public final FontMatcher getFontMatcher() {
        return this.fontMatcher$1;
    }

    @Override
    @NotNull
    public FontFamily getFontFamily() {
        return this.fontFamily;
    }

    @Override
    @NotNull
    public Typeface getNativeTypeface(@NotNull FontWeight fontWeight, @NotNull FontStyle fontStyle, @NotNull FontSynthesis synthesis) {
        Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"fontWeight");
        Intrinsics.checkNotNullParameter((Object)((Object)fontStyle), (String)"fontStyle");
        Intrinsics.checkNotNullParameter((Object)((Object)synthesis), (String)"synthesis");
        Font font = this.fontMatcher$1.matchFont((Iterable<? extends Font>)this.loadedTypefaces.keySet(), fontWeight, fontStyle);
        Typeface typeface = this.loadedTypefaces.get(font);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (typeface == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (Intrinsics.areEqual((Object)font.getWeight(), (Object)fontWeight) && font.getStyle() == fontStyle || synthesis == FontSynthesis.None) {
            return typeface;
        }
        return TypefaceAdapter.Companion.synthesize(typeface, font, fontWeight, fontStyle, synthesis);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/ui/text/platform/AndroidFontListTypeface$Companion;", "", "()V", "fontMatcher", "Landroidx/compose/ui/text/font/FontMatcher;", "getFontMatcher", "()Landroidx/compose/ui/text/font/FontMatcher;", "ui-text_release"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FontMatcher getFontMatcher() {
            return fontMatcher;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

