/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.RectF;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Radius;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RoundRect;
import androidx.compose.ui.graphics.AndroidPath$WhenMappings;
import androidx.compose.ui.graphics.DegreesKt;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathFillType;
import androidx.compose.ui.graphics.PathOperation;
import androidx.compose.ui.graphics.RectHelperKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016J \u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020!H\u0016J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\"\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b+\u0010,J\u0010\u0010-\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u000200H\u0016J(\u00101\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u00102\u001a\u00020\u000fH\u0016J\b\u00103\u001a\u00020\u001eH\u0016J8\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u00020!2\u0006\u00106\u001a\u00020!2\u0006\u00107\u001a\u00020!2\u0006\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020!H\u0016J\b\u0010;\u001a\u00020\u001cH\u0016J\u0018\u0010<\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020!2\u0006\u0010>\u001a\u00020!H\u0016J\u0018\u0010?\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020!2\u0006\u0010>\u001a\u00020!H\u0016J \u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020\u00012\u0006\u0010B\u001a\u00020\u00012\u0006\u0010C\u001a\u00020DH\u0016J(\u0010E\u001a\u00020\u001e2\u0006\u00105\u001a\u00020!2\u0006\u00106\u001a\u00020!2\u0006\u00107\u001a\u00020!2\u0006\u00108\u001a\u00020!H\u0016J8\u0010F\u001a\u00020\u001e2\u0006\u0010G\u001a\u00020!2\u0006\u0010H\u001a\u00020!2\u0006\u0010I\u001a\u00020!2\u0006\u0010J\u001a\u00020!2\u0006\u0010K\u001a\u00020!2\u0006\u0010L\u001a\u00020!H\u0016J\u0018\u0010M\u001a\u00020\u001e2\u0006\u0010N\u001a\u00020!2\u0006\u0010O\u001a\u00020!H\u0016J\u0018\u0010P\u001a\u00020\u001e2\u0006\u0010N\u001a\u00020!2\u0006\u0010O\u001a\u00020!H\u0016J(\u0010Q\u001a\u00020\u001e2\u0006\u0010G\u001a\u00020!2\u0006\u0010H\u001a\u00020!2\u0006\u0010I\u001a\u00020!2\u0006\u0010J\u001a\u00020!H\u0016J\b\u0010R\u001a\u00020\u001eH\u0016J\u001a\u0010S\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\bT\u0010UR$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006V"}, d2={"Landroidx/compose/ui/graphics/AndroidPath;", "Landroidx/compose/ui/graphics/Path;", "internalPath", "Landroid/graphics/Path;", "(Landroid/graphics/Path;)V", "value", "Landroidx/compose/ui/graphics/PathFillType;", "fillType", "getFillType", "()Landroidx/compose/ui/graphics/PathFillType;", "setFillType", "(Landroidx/compose/ui/graphics/PathFillType;)V", "getInternalPath", "()Landroid/graphics/Path;", "isConvex", "", "isConvex$annotations", "()V", "()Z", "isEmpty", "mMatrix", "Landroid/graphics/Matrix;", "radii", "", "rectF", "Landroid/graphics/RectF;", "_rectIsValid", "rect", "Landroidx/compose/ui/geometry/Rect;", "addArc", "", "oval", "startAngleDegrees", "", "sweepAngleDegrees", "addArcRad", "startAngleRadians", "sweepAngleRadians", "addOval", "addPath", "path", "offset", "Landroidx/compose/ui/geometry/Offset;", "addPath-ej0GBII", "(Landroidx/compose/ui/graphics/Path;J)V", "addRect", "addRoundRect", "roundRect", "Landroidx/compose/ui/geometry/RoundRect;", "arcTo", "forceMoveTo", "close", "cubicTo", "x1", "y1", "x2", "y2", "x3", "y3", "getBounds", "lineTo", "x", "y", "moveTo", "op", "path1", "path2", "operation", "Landroidx/compose/ui/graphics/PathOperation;", "quadraticBezierTo", "relativeCubicTo", "dx1", "dy1", "dx2", "dy2", "dx3", "dy3", "relativeLineTo", "dx", "dy", "relativeMoveTo", "relativeQuadraticBezierTo", "reset", "translate", "translate-k-4lQ0M", "(J)V", "ui-graphics_release"})
public final class AndroidPath
implements Path {
    private final RectF rectF;
    private final float[] radii;
    private final Matrix mMatrix;
    @NotNull
    private final android.graphics.Path internalPath;

    @Override
    @NotNull
    public PathFillType getFillType() {
        if (this.internalPath.getFillType() == Path.FillType.EVEN_ODD) {
            return PathFillType.EvenOdd;
        }
        return PathFillType.NonZero;
    }

    @Override
    public void setFillType(@NotNull PathFillType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.internalPath.setFillType(value == PathFillType.EvenOdd ? Path.FillType.EVEN_ODD : Path.FillType.WINDING);
    }

    @Override
    public void moveTo(float x, float y) {
        this.internalPath.moveTo(x, y);
    }

    @Override
    public void relativeMoveTo(float dx, float dy) {
        this.internalPath.rMoveTo(dx, dy);
    }

    @Override
    public void lineTo(float x, float y) {
        this.internalPath.lineTo(x, y);
    }

    @Override
    public void relativeLineTo(float dx, float dy) {
        this.internalPath.rLineTo(dx, dy);
    }

    @Override
    public void quadraticBezierTo(float x1, float y1, float x2, float y2) {
        this.internalPath.quadTo(x1, y1, x2, y2);
    }

    @Override
    public void relativeQuadraticBezierTo(float dx1, float dy1, float dx2, float dy2) {
        this.internalPath.rQuadTo(dx1, dy1, dx2, dy2);
    }

    @Override
    public void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.internalPath.cubicTo(x1, y1, x2, y2, x3, y3);
    }

    @Override
    public void relativeCubicTo(float dx1, float dy1, float dx2, float dy2, float dx3, float dy3) {
        this.internalPath.rCubicTo(dx1, dy1, dx2, dy2, dx3, dy3);
    }

    @Override
    public void arcTo(@NotNull Rect rect, float startAngleDegrees, float sweepAngleDegrees, boolean forceMoveTo) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        float left = rect.getLeft();
        float top = rect.getTop();
        float right = rect.getRight();
        float bottom = rect.getBottom();
        this.rectF.set(left, top, right, bottom);
        this.internalPath.arcTo(this.rectF, startAngleDegrees, sweepAngleDegrees, forceMoveTo);
    }

    @Override
    public void addRect(@NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        boolean bl = this._rectIsValid(rect);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.rectF.set(RectHelperKt.toAndroidRect(rect));
        this.internalPath.addRect(this.rectF, Path.Direction.CCW);
    }

    @Override
    public void addOval(@NotNull Rect oval) {
        Intrinsics.checkNotNullParameter((Object)oval, (String)"oval");
        this.rectF.set(RectHelperKt.toAndroidRect(oval));
        this.internalPath.addOval(this.rectF, Path.Direction.CCW);
    }

    @Override
    public void addArcRad(@NotNull Rect oval, float startAngleRadians, float sweepAngleRadians) {
        Intrinsics.checkNotNullParameter((Object)oval, (String)"oval");
        this.addArc(oval, DegreesKt.degrees(startAngleRadians), DegreesKt.degrees(sweepAngleRadians));
    }

    @Override
    public void addArc(@NotNull Rect oval, float startAngleDegrees, float sweepAngleDegrees) {
        Intrinsics.checkNotNullParameter((Object)oval, (String)"oval");
        boolean bl = this._rectIsValid(oval);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.rectF.set(RectHelperKt.toAndroidRect(oval));
        this.internalPath.addArc(this.rectF, startAngleDegrees, sweepAngleDegrees);
    }

    @Override
    public void addRoundRect(@NotNull RoundRect roundRect) {
        Intrinsics.checkNotNullParameter((Object)roundRect, (String)"roundRect");
        this.rectF.set(roundRect.getLeft(), roundRect.getTop(), roundRect.getRight(), roundRect.getBottom());
        this.radii[0] = Radius.getX-impl((long)roundRect.getTopLeftRadius-QM5bGvM());
        this.radii[1] = Radius.getY-impl((long)roundRect.getTopLeftRadius-QM5bGvM());
        this.radii[2] = Radius.getX-impl((long)roundRect.getTopRightRadius-QM5bGvM());
        this.radii[3] = Radius.getY-impl((long)roundRect.getTopRightRadius-QM5bGvM());
        this.radii[4] = Radius.getX-impl((long)roundRect.getBottomRightRadius-QM5bGvM());
        this.radii[5] = Radius.getY-impl((long)roundRect.getBottomRightRadius-QM5bGvM());
        this.radii[6] = Radius.getX-impl((long)roundRect.getBottomLeftRadius-QM5bGvM());
        this.radii[7] = Radius.getY-impl((long)roundRect.getBottomLeftRadius-QM5bGvM());
        this.internalPath.addRoundRect(this.rectF, this.radii, Path.Direction.CCW);
    }

    @Override
    public void addPath-ej0GBII(@NotNull Path path, long offset) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path $this$asAndroidPath$iv = path;
        boolean $i$f$asAndroidPath = false;
        if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
            throw (Throwable)new UnsupportedOperationException("Unable to obtain android.graphics.Path");
        }
        this.internalPath.addPath(((AndroidPath)$this$asAndroidPath$iv).getInternalPath(), Offset.getX-impl((long)offset), Offset.getY-impl((long)offset));
    }

    @Override
    public void close() {
        this.internalPath.close();
    }

    @Override
    public void reset() {
        this.internalPath.reset();
    }

    @Override
    public void translate-k-4lQ0M(long offset) {
        this.mMatrix.reset();
        this.mMatrix.setTranslate(Offset.getX-impl((long)offset), Offset.getY-impl((long)offset));
        this.internalPath.transform(this.mMatrix);
    }

    @Override
    @NotNull
    public Rect getBounds() {
        this.internalPath.computeBounds(this.rectF, true);
        return new Rect(this.rectF.left, this.rectF.top, this.rectF.right, this.rectF.bottom);
    }

    @Override
    public boolean op(@NotNull Path path1, @NotNull Path path2, @NotNull PathOperation operation) {
        Path.Op op;
        Intrinsics.checkNotNullParameter((Object)path1, (String)"path1");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path2");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        switch (AndroidPath$WhenMappings.$EnumSwitchMapping$0[operation.ordinal()]) {
            case 1: {
                op = Path.Op.DIFFERENCE;
                break;
            }
            case 2: {
                op = Path.Op.INTERSECT;
                break;
            }
            case 3: {
                op = Path.Op.REVERSE_DIFFERENCE;
                break;
            }
            case 4: {
                op = Path.Op.UNION;
                break;
            }
            default: {
                op = Path.Op.XOR;
            }
        }
        Path.Op op2 = op;
        Path $this$asAndroidPath$iv = path1;
        boolean $i$f$asAndroidPath = false;
        if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
            throw (Throwable)new UnsupportedOperationException("Unable to obtain android.graphics.Path");
        }
        android.graphics.Path path = ((AndroidPath)$this$asAndroidPath$iv).getInternalPath();
        $this$asAndroidPath$iv = path2;
        $i$f$asAndroidPath = false;
        if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
            throw (Throwable)new UnsupportedOperationException("Unable to obtain android.graphics.Path");
        }
        return this.internalPath.op(path, ((AndroidPath)$this$asAndroidPath$iv).getInternalPath(), op2);
    }

    public static /* synthetic */ void isConvex$annotations() {
    }

    @Override
    public boolean isConvex() {
        return this.internalPath.isConvex();
    }

    @Override
    public boolean isEmpty() {
        return this.internalPath.isEmpty();
    }

    private final boolean _rectIsValid(Rect rect) {
        float f = rect.getLeft();
        boolean bl = false;
        boolean bl2 = !Float.isNaN(f);
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "Rect.left is NaN";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        float f2 = rect.getTop();
        bl = false;
        boolean bl5 = !Float.isNaN(f2);
        bl = false;
        bl3 = false;
        if (!bl5) {
            boolean bl6 = false;
            String string = "Rect.top is NaN";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        float f3 = rect.getRight();
        bl = false;
        boolean bl7 = !Float.isNaN(f3);
        bl = false;
        bl3 = false;
        if (!bl7) {
            boolean bl8 = false;
            String string = "Rect.right is NaN";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        float f4 = rect.getBottom();
        bl = false;
        boolean bl9 = !Float.isNaN(f4);
        bl = false;
        bl3 = false;
        if (!bl9) {
            boolean bl10 = false;
            String string = "Rect.bottom is NaN";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return true;
    }

    @NotNull
    public final android.graphics.Path getInternalPath() {
        return this.internalPath;
    }

    public AndroidPath(@NotNull android.graphics.Path internalPath) {
        Intrinsics.checkNotNullParameter((Object)internalPath, (String)"internalPath");
        this.internalPath = internalPath;
        this.rectF = new RectF();
        this.radii = new float[8];
        this.mMatrix = new Matrix();
    }

    public /* synthetic */ AndroidPath(android.graphics.Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            path = new android.graphics.Path();
        }
        this(path);
    }

    public AndroidPath() {
        this(null, 1, null);
    }

    @Override
    public void arcToRad(@NotNull Rect rect, float startAngleRadians, float sweepAngleRadians, boolean forceMoveTo) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Path.DefaultImpls.arcToRad(this, rect, startAngleRadians, sweepAngleRadians, forceMoveTo);
    }

    @Override
    @Deprecated(message="Use addRoundRect(roundRect) instead", replaceWith=@ReplaceWith(imports={"androidx.compose.ui.graphics"}, expression="addRoundRect(rrect)"))
    public void addRRect(@NotNull RoundRect rrect) {
        Intrinsics.checkNotNullParameter((Object)rrect, (String)"rrect");
        Path.DefaultImpls.addRRect(this, rrect);
    }

    @Override
    @Deprecated(message="Use translate(offset) instead", replaceWith=@ReplaceWith(imports={"androidx.compose.ui.graphics.Path"}, expression="translate(offset)"))
    public void shift-k-4lQ0M(long offset) {
        Path.DefaultImpls.shift-k-4lQ0M(this, offset);
    }
}

