/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.node.DepthSortedSetsForDifferentPasses;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.MeasureAndLayoutDelegate;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\f\u0010\u0012\u001a\u00020\r*\u00020\u0003H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/compose/ui/node/LayoutTreeConsistencyChecker;", "", "root", "Landroidx/compose/ui/node/LayoutNode;", "relayoutNodes", "Landroidx/compose/ui/node/DepthSortedSetsForDifferentPasses;", "postponedMeasureRequests", "", "Landroidx/compose/ui/node/MeasureAndLayoutDelegate$PostponedRequest;", "(Landroidx/compose/ui/node/LayoutNode;Landroidx/compose/ui/node/DepthSortedSetsForDifferentPasses;Ljava/util/List;)V", "assertConsistent", "", "isTreeConsistent", "", "node", "logTree", "", "nodeToString", "consistentLayoutState", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLayoutTreeConsistencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutTreeConsistencyChecker.kt\nandroidx/compose/ui/node/LayoutTreeConsistencyChecker\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,143:1\n33#2,6:144\n116#2,2:150\n33#2,6:152\n118#2:158\n116#2,2:159\n33#2,6:161\n118#2:167\n33#2,6:168\n*S KotlinDebug\n*F\n+ 1 LayoutTreeConsistencyChecker.kt\nandroidx/compose/ui/node/LayoutTreeConsistencyChecker\n*L\n44#1:144,6\n59#1:150,2\n59#1:152,6\n59#1:158\n84#1:159,2\n84#1:161,6\n84#1:167\n136#1:168,6\n*E\n"})
public final class LayoutTreeConsistencyChecker {
    @NotNull
    private final LayoutNode root;
    @NotNull
    private final DepthSortedSetsForDifferentPasses relayoutNodes;
    @NotNull
    private final List<MeasureAndLayoutDelegate.PostponedRequest> postponedMeasureRequests;
    public static final int $stable = 8;

    public LayoutTreeConsistencyChecker(@NotNull LayoutNode root, @NotNull DepthSortedSetsForDifferentPasses relayoutNodes, @NotNull List<MeasureAndLayoutDelegate.PostponedRequest> postponedMeasureRequests) {
        this.root = root;
        this.relayoutNodes = relayoutNodes;
        this.postponedMeasureRequests = postponedMeasureRequests;
    }

    public final void assertConsistent() {
        boolean inconsistencyFound;
        boolean bl = inconsistencyFound = !this.isTreeConsistent(this.root);
        if (inconsistencyFound) {
            System.out.println((Object)this.logTree());
            throw new IllegalStateException("Inconsistency found!");
        }
    }

    private final boolean isTreeConsistent(LayoutNode node) {
        if (!this.consistentLayoutState(node)) {
            return false;
        }
        List<LayoutNode> $this$fastForEach$iv = node.getChildren$ui();
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            LayoutNode item$iv;
            LayoutNode it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            if (this.isTreeConsistent(it)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean consistentLayoutState(LayoutNode $this$consistentLayoutState) {
        MeasureAndLayoutDelegate.PostponedRequest it;
        boolean bl;
        MeasureAndLayoutDelegate.PostponedRequest it$iv;
        MeasureAndLayoutDelegate.PostponedRequest item$iv$iv;
        int index$iv$iv;
        int n;
        boolean $i$f$fastForEach;
        List<MeasureAndLayoutDelegate.PostponedRequest> $this$fastForEach$iv$iv;
        List<MeasureAndLayoutDelegate.PostponedRequest> $this$fastFirstOrNull$iv;
        boolean $i$f$fastFirstOrNull;
        LayoutNode.LayoutState parentLayoutState;
        LayoutNode parent2;
        block23: {
            block22: {
                LayoutNode layoutNode = parent2 = $this$consistentLayoutState.getParent$ui();
                LayoutNode.LayoutState layoutState = parentLayoutState = layoutNode != null ? layoutNode.getLayoutState$ui() : null;
                if ($this$consistentLayoutState.isPlaced()) break block22;
                if ($this$consistentLayoutState.getPlaceOrder$ui() == Integer.MAX_VALUE) break block23;
                LayoutNode layoutNode2 = parent2;
                boolean bl2 = layoutNode2 != null ? layoutNode2.isPlaced() : false;
                if (!bl2) break block23;
            }
            if ($this$consistentLayoutState.getMeasurePending$ui()) {
                MeasureAndLayoutDelegate.PostponedRequest postponedRequest;
                block20: {
                    List<MeasureAndLayoutDelegate.PostponedRequest> list = this.postponedMeasureRequests;
                    $i$f$fastFirstOrNull = false;
                    $this$fastForEach$iv$iv = $this$fastFirstOrNull$iv;
                    $i$f$fastForEach = false;
                    n = $this$fastForEach$iv$iv.size();
                    for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                        it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                        bl = false;
                        it = it$iv;
                        boolean bl3 = false;
                        if (!(Intrinsics.areEqual((Object)it.getNode(), (Object)$this$consistentLayoutState) && !it.isLookahead())) continue;
                        postponedRequest = it$iv;
                        break block20;
                    }
                    postponedRequest = null;
                }
                if (postponedRequest != null) {
                    return true;
                }
            }
            if ($this$consistentLayoutState.getMeasurePending$ui()) {
                boolean bl4;
                boolean bl5;
                if (this.relayoutNodes.contains($this$consistentLayoutState)) return true;
                if ($this$consistentLayoutState.getLayoutState$ui() == LayoutNode.LayoutState.LookaheadMeasuring) return true;
                LayoutNode layoutNode = parent2;
                if (layoutNode != null) {
                    if (layoutNode.getMeasurePending$ui()) {
                        return true;
                    }
                    bl5 = false;
                } else {
                    bl5 = false;
                }
                if (bl5) return true;
                LayoutNode layoutNode3 = parent2;
                if (layoutNode3 != null) {
                    if (layoutNode3.getLookaheadMeasurePending$ui()) {
                        return true;
                    }
                    bl4 = false;
                } else {
                    bl4 = false;
                }
                if (bl4) return true;
                if (parentLayoutState != LayoutNode.LayoutState.Measuring) return false;
                return true;
            }
            if ($this$consistentLayoutState.getLayoutPending$ui()) {
                if (this.relayoutNodes.contains($this$consistentLayoutState)) return true;
                if (parent2 == null) return true;
                if (parent2.getMeasurePending$ui()) return true;
                if (parent2.getLayoutPending$ui()) return true;
                if (parentLayoutState == LayoutNode.LayoutState.Measuring) return true;
                if (parentLayoutState != LayoutNode.LayoutState.LayingOut) return false;
                return true;
            }
        }
        if (!Intrinsics.areEqual((Object)$this$consistentLayoutState.isPlacedInLookahead(), (Object)true)) return true;
        if ($this$consistentLayoutState.getLookaheadMeasurePending$ui()) {
            MeasureAndLayoutDelegate.PostponedRequest postponedRequest;
            block21: {
                $this$fastFirstOrNull$iv = this.postponedMeasureRequests;
                $i$f$fastFirstOrNull = false;
                $this$fastForEach$iv$iv = $this$fastFirstOrNull$iv;
                $i$f$fastForEach = false;
                n = $this$fastForEach$iv$iv.size();
                for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    bl = false;
                    it = it$iv;
                    boolean bl6 = false;
                    if (!(Intrinsics.areEqual((Object)it.getNode(), (Object)$this$consistentLayoutState) && it.isLookahead())) continue;
                    postponedRequest = it$iv;
                    break block21;
                }
                postponedRequest = null;
            }
            if (postponedRequest != null) {
                return true;
            }
        }
        if ($this$consistentLayoutState.getLookaheadMeasurePending$ui()) {
            boolean bl7;
            if (this.relayoutNodes.contains($this$consistentLayoutState, true)) return true;
            LayoutNode layoutNode = parent2;
            if (layoutNode != null) {
                if (layoutNode.getLookaheadMeasurePending$ui()) {
                    return true;
                }
                bl7 = false;
            } else {
                bl7 = false;
            }
            if (bl7) return true;
            if (parentLayoutState == LayoutNode.LayoutState.LookaheadMeasuring) return true;
            LayoutNode layoutNode4 = parent2;
            if (layoutNode4 == null) return false;
            if (!layoutNode4.getMeasurePending$ui()) return false;
            boolean bl8 = true;
            if (!bl8) return false;
            if (!Intrinsics.areEqual((Object)$this$consistentLayoutState.getLookaheadRoot$ui(), (Object)$this$consistentLayoutState)) return false;
            return true;
        }
        if (!$this$consistentLayoutState.getLookaheadLayoutPending$ui()) return true;
        if (this.relayoutNodes.contains($this$consistentLayoutState, true)) return true;
        if (parent2 == null) return true;
        if (parent2.getLookaheadMeasurePending$ui()) return true;
        if (parent2.getLookaheadLayoutPending$ui()) return true;
        if (parentLayoutState == LayoutNode.LayoutState.LookaheadMeasuring) return true;
        if (parentLayoutState == LayoutNode.LayoutState.LookaheadLayingOut) return true;
        if (!parent2.getLayoutPending$ui()) return false;
        if (!Intrinsics.areEqual((Object)$this$consistentLayoutState.getLookaheadRoot$ui(), (Object)$this$consistentLayoutState)) return false;
        return true;
    }

    private final String nodeToString(LayoutNode node) {
        StringBuilder $this$nodeToString_u24lambda_u243 = new StringBuilder();
        boolean bl = false;
        $this$nodeToString_u24lambda_u243.append(node);
        $this$nodeToString_u24lambda_u243.append("[" + node.getLayoutState$ui() + "]");
        if (!node.isPlaced()) {
            $this$nodeToString_u24lambda_u243.append("[!isPlaced]");
        }
        $this$nodeToString_u24lambda_u243.append("[measuredByParent=" + node.getMeasuredByParent$ui() + "]");
        if (!this.consistentLayoutState(node)) {
            $this$nodeToString_u24lambda_u243.append("[INCONSISTENT]");
        }
        return $this$nodeToString_u24lambda_u243.toString();
    }

    private final String logTree() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("Tree state:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        LayoutTreeConsistencyChecker.logTree$printSubTree(this, stringBuilder, this.root, 0);
        return stringBuilder.toString();
    }

    private static final void logTree$printSubTree(LayoutTreeConsistencyChecker this$0, StringBuilder stringBuilder, LayoutNode node, int depth) {
        int childrenDepth = 0;
        childrenDepth = depth;
        String nodeRepresentation = this$0.nodeToString(node);
        if (((CharSequence)nodeRepresentation).length() > 0) {
            for (int i = 0; i < depth; ++i) {
                stringBuilder.append("..");
            }
            StringBuilder stringBuilder2 = stringBuilder.append(nodeRepresentation);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            ++childrenDepth;
        }
        List<LayoutNode> $this$fastForEach$iv = node.getChildren$ui();
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            LayoutNode item$iv;
            LayoutNode it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            LayoutTreeConsistencyChecker.logTree$printSubTree(this$0, stringBuilder, it, childrenDepth);
        }
    }
}

