/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.awt;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocalKt;
import androidx.compose.runtime.ProvidedValue;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.awt.ComposeLayer;
import androidx.compose.ui.awt.LocalLayerContainer_desktopKt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.ClipComponent;
import org.jetbrains.skiko.GraphicsApi;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\tH\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u001d\u001a\u00020\tH\u0016J\b\u0010\u001e\u001a\u00020\tH\u0016J(\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!H\u0016J\u001e\u0010%\u001a\u00020\t2\u0011\u0010\u0007\u001a\r\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\u0010&R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000f\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\b\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Landroidx/compose/ui/awt/ComposePanel;", "Ljavax/swing/JLayeredPane;", "()V", "clipMap", "", "Ljava/awt/Component;", "Lorg/jetbrains/skiko/ClipComponent;", "content", "Lkotlin/Function0;", "", "Landroidx/compose/runtime/Composable;", "Lkotlin/jvm/functions/Function2;", "layer", "Landroidx/compose/ui/awt/ComposeLayer;", "getLayer$ui", "()Landroidx/compose/ui/awt/ComposeLayer;", "setLayer$ui", "(Landroidx/compose/ui/awt/ComposeLayer;)V", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "add", "component", "addNotify", "getPreferredSize", "Ljava/awt/Dimension;", "initContent", "remove", "removeNotify", "requestFocus", "setBounds", "x", "", "y", "width", "height", "setContent", "(Lkotlin/jvm/functions/Function2;)V", "ui"})
@StabilityInferred(parameters=0)
public final class ComposePanel
extends JLayeredPane {
    @Nullable
    private ComposeLayer layer;
    @NotNull
    private final Map<Component, ClipComponent> clipMap;
    @Nullable
    private Function2<? super Composer, ? super Integer, Unit> content;
    public static final int $stable = 8;

    public ComposePanel() {
        if (!SwingUtilities.isEventDispatchThread()) {
            boolean bl = false;
            String string = "ComposePanel should be created inside AWT Event Dispatch Thread (use SwingUtilities.invokeLater).\nCreating from another thread isn't supported.";
            throw new IllegalStateException(string.toString());
        }
        this.setBackground(Color.white);
        this.setLayout(null);
        this.clipMap = new LinkedHashMap();
    }

    @Nullable
    public final ComposeLayer getLayer$ui() {
        return this.layer;
    }

    public final void setLayer$ui(@Nullable ComposeLayer composeLayer) {
        this.layer = composeLayer;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        ComposeLayer composeLayer = this.layer;
        if (composeLayer != null && (composeLayer = composeLayer.getComponent()) != null) {
            composeLayer.setSize(width, height);
        }
        super.setBounds(x, y, width, height);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize() {
        ComposeLayer composeLayer;
        return this.isPreferredSizeSet() ? super.getPreferredSize() : ((composeLayer = this.layer) != null && (composeLayer = composeLayer.getComponent()) != null ? composeLayer.getPreferredSize() : null);
    }

    public final void setContent(@NotNull Function2<? super Composer, ? super Integer, Unit> content) {
        this.content = content;
        this.initContent();
    }

    private final void initContent() {
        if (this.layer != null && this.content != null) {
            ComposeLayer composeLayer = this.layer;
            Intrinsics.checkNotNull((Object)composeLayer);
            ComposeLayer.setContent$default(composeLayer, null, null, (Function2)ComposableLambdaKt.composableLambdaInstance((int)-991691413, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(this){
                final /* synthetic */ ComposePanel this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                @Composable
                public final void invoke(@Nullable Composer $composer, int $changed) {
                    ComposerKt.sourceInformation((Composer)$composer, (String)"C71@2618L138:ComposePanel.desktop.kt#ccs55x");
                    if (($changed & 0xB) != 2 || !$composer.getSkipping()) {
                        if (ComposerKt.isTraceInProgress()) {
                            ComposerKt.traceEventStart((int)-991691413, (int)$changed, (int)-1, (String)"androidx.compose.ui.awt.ComposePanel.initContent.<anonymous> (ComposePanel.desktop.kt:71)");
                        }
                        ProvidedValue providedValue = LocalLayerContainer_desktopKt.getLocalLayerContainer().provides((Object)this.this$0);
                        Function2 function2 = ComposePanel.access$getContent$p(this.this$0);
                        Intrinsics.checkNotNull((Object)function2);
                        CompositionLocalKt.CompositionLocalProvider((ProvidedValue)providedValue, (Function2)function2, (Composer)$composer, (int)8);
                        if (ComposerKt.isTraceInProgress()) {
                            ComposerKt.traceEventEnd();
                        }
                    } else {
                        $composer.skipToGroupEnd();
                    }
                }
            }), 3, null);
        }
    }

    @Override
    @NotNull
    public Component add(@NotNull Component component) {
        if (this.layer == null) {
            return component;
        }
        ClipComponent clipComponent = new ClipComponent(component);
        this.clipMap.put(component, clipComponent);
        ComposeLayer composeLayer = this.layer;
        Intrinsics.checkNotNull((Object)composeLayer);
        composeLayer.getComponent().getClipComponents().add(clipComponent);
        return super.add(component, 0);
    }

    @Override
    public void remove(@NotNull Component component) {
        ComposeLayer composeLayer = this.layer;
        Intrinsics.checkNotNull((Object)composeLayer);
        List list = composeLayer.getComponent().getClipComponents();
        ClipComponent clipComponent = this.clipMap.get(component);
        Intrinsics.checkNotNull((Object)clipComponent);
        list.remove(clipComponent);
        this.clipMap.remove(component);
        super.remove(component);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addNotify() {
        void $this$addNotify_u24lambda_u241;
        ComposeLayer composeLayer;
        super.addNotify();
        ComposeLayer composeLayer2 = composeLayer = new ComposeLayer();
        ComposePanel composePanel = this;
        boolean bl = false;
        $this$addNotify_u24lambda_u241.getComponent().setSize(this.getWidth(), this.getHeight());
        composePanel.layer = composeLayer;
        this.initContent();
        ComposeLayer composeLayer3 = this.layer;
        Intrinsics.checkNotNull((Object)composeLayer3);
        super.add((Component)composeLayer3.getComponent(), 1);
    }

    @Override
    public void removeNotify() {
        if (this.layer != null) {
            ComposeLayer composeLayer = this.layer;
            Intrinsics.checkNotNull((Object)composeLayer);
            composeLayer.dispose();
            ComposeLayer composeLayer2 = this.layer;
            Intrinsics.checkNotNull((Object)composeLayer2);
            super.remove((Component)composeLayer2.getComponent());
        }
        super.removeNotify();
    }

    @Override
    public void requestFocus() {
        if (this.layer != null) {
            ComposeLayer composeLayer = this.layer;
            Intrinsics.checkNotNull((Object)composeLayer);
            composeLayer.getComponent().requestFocus();
        }
    }

    @NotNull
    public final GraphicsApi getRenderApi() {
        GraphicsApi graphicsApi;
        if (this.layer != null) {
            ComposeLayer composeLayer = this.layer;
            Intrinsics.checkNotNull((Object)composeLayer);
            graphicsApi = composeLayer.getComponent().getRenderApi();
        } else {
            graphicsApi = GraphicsApi.UNKNOWN;
        }
        return graphicsApi;
    }

    public static final /* synthetic */ Function2 access$getContent$p(ComposePanel $this) {
        return $this.content;
    }
}

