/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import android.os.Build;
import androidx.compose.ui.geometry.CornerRadius;
import androidx.compose.ui.geometry.CornerRadiusKt;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RoundRect;
import androidx.compose.ui.geometry.RoundRectKt;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.AndroidPath;
import androidx.compose.ui.graphics.AndroidPath_androidKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Outline;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.RectangleShapeKt;
import androidx.compose.ui.graphics.Shape;
import androidx.compose.ui.platform.ShapeContainingUtilKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u001b\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u001f\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b1\u00102J\u001b\u00103\u001a\u00020,2\u0006\u0010$\u001a\u00020\u001c\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b4\u00105J6\u00103\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u00106\u001a\u00020!2\u0006\u0010+\u001a\u00020\u00062\u0006\u00107\u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003J\b\u00108\u001a\u00020,H\u0002J\u0010\u00109\u001a\u00020,2\u0006\u0010:\u001a\u00020\nH\u0002J\u0010\u0010;\u001a\u00020,2\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u00020,2\u0006\u0010?\u001a\u00020(H\u0002J3\u0010@\u001a\u00020\u0006*\u0004\u0018\u00010(2\u0006\u0010A\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010B\u001a\u00020!H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bC\u0010DR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0019\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010$\u001a\u00020\u001cX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0010\u0010%\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006E"}, d2={"Landroidx/compose/ui/platform/OutlineResolver;", "", "density", "Landroidx/compose/ui/unit/Density;", "(Landroidx/compose/ui/unit/Density;)V", "cacheIsDirty", "", "cachedOutline", "Landroid/graphics/Outline;", "cachedRrectPath", "Landroidx/compose/ui/graphics/Path;", "calculatedOutline", "Landroidx/compose/ui/graphics/Outline;", "clipPath", "getClipPath", "()Landroidx/compose/ui/graphics/Path;", "isSupportedOutline", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "outline", "getOutline", "()Landroid/graphics/Outline;", "outlineClipSupported", "getOutlineClipSupported", "()Z", "outlineNeeded", "outlinePath", "rectSize", "Landroidx/compose/ui/geometry/Size;", "J", "rectTopLeft", "Landroidx/compose/ui/geometry/Offset;", "roundedCornerRadius", "", "shape", "Landroidx/compose/ui/graphics/Shape;", "size", "tmpOpPath", "tmpPath", "tmpRoundRect", "Landroidx/compose/ui/geometry/RoundRect;", "tmpTouchPointPath", "usePathForClip", "clipToOutline", "", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "isInOutline", "position", "isInOutline-k-4lQ0M", "(J)Z", "update", "update-uvyYCjk", "(J)V", "alpha", "elevation", "updateCache", "updateCacheWithPath", "composePath", "updateCacheWithRect", "rect", "Landroidx/compose/ui/geometry/Rect;", "updateCacheWithRoundRect", "roundRect", "isSameBounds", "offset", "radius", "isSameBounds-4L21HEs", "(Landroidx/compose/ui/geometry/RoundRect;JJF)Z", "ui_release"})
@SourceDebugExtension(value={"SMAP\nOutlineResolver.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutlineResolver.android.kt\nandroidx/compose/ui/platform/OutlineResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AndroidPath.android.kt\nandroidx/compose/ui/graphics/AndroidPath_androidKt\n*L\n1#1,356:1\n1#2:357\n35#3,5:358\n*S KotlinDebug\n*F\n+ 1 OutlineResolver.android.kt\nandroidx/compose/ui/platform/OutlineResolver\n*L\n330#1:358,5\n*E\n"})
public final class OutlineResolver {
    @NotNull
    private Density density;
    private boolean isSupportedOutline;
    @NotNull
    private final android.graphics.Outline cachedOutline;
    private long size;
    @NotNull
    private Shape shape;
    @Nullable
    private Path cachedRrectPath;
    @Nullable
    private Path outlinePath;
    private boolean cacheIsDirty;
    private boolean usePathForClip;
    @Nullable
    private Path tmpPath;
    @Nullable
    private RoundRect tmpRoundRect;
    private float roundedCornerRadius;
    private long rectTopLeft;
    private long rectSize;
    private boolean outlineNeeded;
    @NotNull
    private LayoutDirection layoutDirection;
    @Nullable
    private Path tmpTouchPointPath;
    @Nullable
    private Path tmpOpPath;
    @Nullable
    private Outline calculatedOutline;

    /*
     * WARNING - void declaration
     */
    public OutlineResolver(@NotNull Density density) {
        void $this$cachedOutline_u24lambda_u240;
        android.graphics.Outline outline;
        this.density = density;
        this.isSupportedOutline = true;
        android.graphics.Outline outline2 = outline = new android.graphics.Outline();
        OutlineResolver outlineResolver = this;
        boolean bl = false;
        $this$cachedOutline_u24lambda_u240.setAlpha(1.0f);
        outlineResolver.cachedOutline = outline;
        this.size = Size.Companion.getZero-NH-jbRc();
        this.shape = RectangleShapeKt.getRectangleShape();
        this.rectTopLeft = Offset.Companion.getZero-F1C5BW0();
        this.rectSize = Size.Companion.getZero-NH-jbRc();
        this.layoutDirection = LayoutDirection.Ltr;
    }

    @Nullable
    public final android.graphics.Outline getOutline() {
        this.updateCache();
        return !this.outlineNeeded || !this.isSupportedOutline ? null : this.cachedOutline;
    }

    public final boolean getOutlineClipSupported() {
        return !this.usePathForClip;
    }

    @Nullable
    public final Path getClipPath() {
        this.updateCache();
        return this.outlinePath;
    }

    public final boolean update(@NotNull Shape shape, float alpha, boolean clipToOutline, float elevation, @NotNull LayoutDirection layoutDirection, @NotNull Density density) {
        boolean outlineNeeded;
        boolean shapeChanged;
        this.cachedOutline.setAlpha(alpha);
        boolean bl = shapeChanged = !Intrinsics.areEqual((Object)this.shape, (Object)shape);
        if (shapeChanged) {
            this.shape = shape;
            this.cacheIsDirty = true;
        }
        boolean bl2 = outlineNeeded = clipToOutline || elevation > 0.0f;
        if (this.outlineNeeded != outlineNeeded) {
            this.outlineNeeded = outlineNeeded;
            this.cacheIsDirty = true;
        }
        if (this.layoutDirection != layoutDirection) {
            this.layoutDirection = layoutDirection;
            this.cacheIsDirty = true;
        }
        if (!Intrinsics.areEqual((Object)this.density, (Object)density)) {
            this.density = density;
            this.cacheIsDirty = true;
        }
        return shapeChanged;
    }

    public final boolean isInOutline-k-4lQ0M(long position) {
        if (!this.outlineNeeded) {
            return true;
        }
        Outline outline = this.calculatedOutline;
        if (outline == null) {
            return true;
        }
        Outline outline2 = outline;
        return ShapeContainingUtilKt.isInOutline(outline2, Offset.getX-impl((long)position), Offset.getY-impl((long)position), this.tmpTouchPointPath, this.tmpOpPath);
    }

    public final void clipToOutline(@NotNull Canvas canvas) {
        Path targetPath = this.getClipPath();
        if (targetPath != null) {
            Canvas.clipPath-mtrdD-E$default((Canvas)canvas, (Path)targetPath, (int)0, (int)2, null);
        } else if (this.roundedCornerRadius > 0.0f) {
            Path roundRectClipPath = this.tmpPath;
            RoundRect roundRect = this.tmpRoundRect;
            if (roundRectClipPath == null || !this.isSameBounds-4L21HEs(roundRect, this.rectTopLeft, this.rectSize, this.roundedCornerRadius)) {
                roundRect = RoundRectKt.RoundRect-gG7oq9Y((float)Offset.getX-impl((long)this.rectTopLeft), (float)Offset.getY-impl((long)this.rectTopLeft), (float)(Offset.getX-impl((long)this.rectTopLeft) + Size.getWidth-impl((long)this.rectSize)), (float)(Offset.getY-impl((long)this.rectTopLeft) + Size.getHeight-impl((long)this.rectSize)), (long)CornerRadiusKt.CornerRadius$default((float)this.roundedCornerRadius, (float)0.0f, (int)2, null));
                if (roundRectClipPath == null) {
                    roundRectClipPath = AndroidPath_androidKt.Path();
                } else {
                    roundRectClipPath.reset();
                }
                roundRectClipPath.addRoundRect(roundRect);
                this.tmpRoundRect = roundRect;
                this.tmpPath = roundRectClipPath;
            }
            Canvas.clipPath-mtrdD-E$default((Canvas)canvas, (Path)roundRectClipPath, (int)0, (int)2, null);
        } else {
            Canvas.clipRect-N_I0leg$default((Canvas)canvas, (float)Offset.getX-impl((long)this.rectTopLeft), (float)Offset.getY-impl((long)this.rectTopLeft), (float)(Offset.getX-impl((long)this.rectTopLeft) + Size.getWidth-impl((long)this.rectSize)), (float)(Offset.getY-impl((long)this.rectTopLeft) + Size.getHeight-impl((long)this.rectSize)), (int)0, (int)16, null);
        }
    }

    public final void update-uvyYCjk(long size) {
        if (!Size.equals-impl0((long)this.size, (long)size)) {
            this.size = size;
            this.cacheIsDirty = true;
        }
    }

    private final void updateCache() {
        if (this.cacheIsDirty) {
            this.rectTopLeft = Offset.Companion.getZero-F1C5BW0();
            this.rectSize = this.size;
            this.roundedCornerRadius = 0.0f;
            this.outlinePath = null;
            this.cacheIsDirty = false;
            this.usePathForClip = false;
            if (this.outlineNeeded && Size.getWidth-impl((long)this.size) > 0.0f && Size.getHeight-impl((long)this.size) > 0.0f) {
                Outline outline;
                this.isSupportedOutline = true;
                this.calculatedOutline = outline = this.shape.createOutline-Pq9zytI(this.size, this.layoutDirection, this.density);
                Outline outline2 = outline;
                if (outline2 instanceof Outline.Rectangle) {
                    this.updateCacheWithRect(((Outline.Rectangle)outline).getRect());
                } else if (outline2 instanceof Outline.Rounded) {
                    this.updateCacheWithRoundRect(((Outline.Rounded)outline).getRoundRect());
                } else if (outline2 instanceof Outline.Generic) {
                    this.updateCacheWithPath(((Outline.Generic)outline).getPath());
                }
            } else {
                this.cachedOutline.setEmpty();
            }
        }
    }

    private final void updateCacheWithRect(Rect rect) {
        this.rectTopLeft = OffsetKt.Offset((float)rect.getLeft(), (float)rect.getTop());
        this.rectSize = SizeKt.Size((float)rect.getWidth(), (float)rect.getHeight());
        this.cachedOutline.setRect(MathKt.roundToInt((float)rect.getLeft()), MathKt.roundToInt((float)rect.getTop()), MathKt.roundToInt((float)rect.getRight()), MathKt.roundToInt((float)rect.getBottom()));
    }

    private final void updateCacheWithRoundRect(RoundRect roundRect) {
        float radius = CornerRadius.getX-impl((long)roundRect.getTopLeftCornerRadius-kKHJgLs());
        this.rectTopLeft = OffsetKt.Offset((float)roundRect.getLeft(), (float)roundRect.getTop());
        this.rectSize = SizeKt.Size((float)roundRect.getWidth(), (float)roundRect.getHeight());
        if (RoundRectKt.isSimple((RoundRect)roundRect)) {
            this.cachedOutline.setRoundRect(MathKt.roundToInt((float)roundRect.getLeft()), MathKt.roundToInt((float)roundRect.getTop()), MathKt.roundToInt((float)roundRect.getRight()), MathKt.roundToInt((float)roundRect.getBottom()), radius);
            this.roundedCornerRadius = radius;
        } else {
            Path path = this.cachedRrectPath;
            if (path == null) {
                Path path2;
                Path it = path2 = AndroidPath_androidKt.Path();
                boolean bl = false;
                this.cachedRrectPath = it;
                path = path2;
            }
            Path path3 = path;
            path3.reset();
            path3.addRoundRect(roundRect);
            this.updateCacheWithPath(path3);
        }
    }

    private final void updateCacheWithPath(Path composePath) {
        if (Build.VERSION.SDK_INT > 28 || composePath.isConvex()) {
            Path $this$asAndroidPath$iv = composePath;
            boolean $i$f$asAndroidPath = false;
            if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
                throw new UnsupportedOperationException("Unable to obtain android.graphics.Path");
            }
            this.cachedOutline.setConvexPath(((AndroidPath)$this$asAndroidPath$iv).getInternalPath());
            this.usePathForClip = !this.cachedOutline.canClip();
        } else {
            this.isSupportedOutline = false;
            this.cachedOutline.setEmpty();
            this.usePathForClip = true;
        }
        this.outlinePath = composePath;
    }

    private final boolean isSameBounds-4L21HEs(RoundRect $this$isSameBounds_u2d4L21HEs, long offset, long size, float radius) {
        if ($this$isSameBounds_u2d4L21HEs == null || !RoundRectKt.isSimple((RoundRect)$this$isSameBounds_u2d4L21HEs)) {
            return false;
        }
        return $this$isSameBounds_u2d4L21HEs.getLeft() == Offset.getX-impl((long)offset) && $this$isSameBounds_u2d4L21HEs.getTop() == Offset.getY-impl((long)offset) && $this$isSameBounds_u2d4L21HEs.getRight() == Offset.getX-impl((long)offset) + Size.getWidth-impl((long)size) && $this$isSameBounds_u2d4L21HEs.getBottom() == Offset.getY-impl((long)offset) + Size.getHeight-impl((long)size) && CornerRadius.getX-impl((long)$this$isSameBounds_u2d4L21HEs.getTopLeftCornerRadius-kKHJgLs()) == radius;
    }
}

