/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.input.PlatformTextInput;
import androidx.compose.ui.text.input.PlatformTextInputAdapter;
import androidx.compose.ui.text.input.PlatformTextInputPlugin;
import androidx.compose.ui.text.input.PlatformTextInputService;
import androidx.compose.ui.text.input.TextInputService;
import androidx.compose.ui.text.input.TextInputServiceAndroid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Landroidx/compose/ui/text/input/AndroidTextInputServicePlugin;", "Landroidx/compose/ui/text/input/PlatformTextInputPlugin;", "Landroidx/compose/ui/text/input/AndroidTextInputServicePlugin$Adapter;", "()V", "createAdapter", "platformTextInput", "Landroidx/compose/ui/text/input/PlatformTextInput;", "view", "Landroid/view/View;", "Adapter", "ui_release"})
public final class AndroidTextInputServicePlugin
implements PlatformTextInputPlugin<Adapter> {
    @NotNull
    public static final AndroidTextInputServicePlugin INSTANCE = new AndroidTextInputServicePlugin();

    private AndroidTextInputServicePlugin() {
    }

    @NotNull
    public Adapter createAdapter(@NotNull PlatformTextInput platformTextInput, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)platformTextInput, (String)"platformTextInput");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        TextInputServiceAndroid platformService = new TextInputServiceAndroid(view, platformTextInput);
        return new Adapter(new TextInputService((PlatformTextInputService)platformService), platformService);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Landroidx/compose/ui/text/input/AndroidTextInputServicePlugin$Adapter;", "Landroidx/compose/ui/text/input/PlatformTextInputAdapter;", "service", "Landroidx/compose/ui/text/input/TextInputService;", "androidService", "Landroidx/compose/ui/text/input/TextInputServiceAndroid;", "(Landroidx/compose/ui/text/input/TextInputService;Landroidx/compose/ui/text/input/TextInputServiceAndroid;)V", "getService", "()Landroidx/compose/ui/text/input/TextInputService;", "createInputConnection", "Landroid/view/inputmethod/InputConnection;", "outAttrs", "Landroid/view/inputmethod/EditorInfo;", "ui_release"})
    @StabilityInferred(parameters=0)
    public static final class Adapter
    implements PlatformTextInputAdapter {
        @NotNull
        private final TextInputService service;
        @NotNull
        private final TextInputServiceAndroid androidService;
        public static final int $stable = 8;

        public Adapter(@NotNull TextInputService service, @NotNull TextInputServiceAndroid androidService) {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            Intrinsics.checkNotNullParameter((Object)androidService, (String)"androidService");
            this.service = service;
            this.androidService = androidService;
        }

        @NotNull
        public final TextInputService getService() {
            return this.service;
        }

        @NotNull
        public InputConnection createInputConnection(@NotNull EditorInfo outAttrs) {
            Intrinsics.checkNotNullParameter((Object)outAttrs, (String)"outAttrs");
            return this.androidService.createInputConnection(outAttrs);
        }
    }
}

