/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import android.os.Build;
import android.view.View;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.compose.ui.geometry.MutableRect;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.AndroidCanvas_androidKt;
import androidx.compose.ui.graphics.AndroidPaint_androidKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CanvasHolder;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.Paint;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.RectangleShapeKt;
import androidx.compose.ui.graphics.RenderEffect;
import androidx.compose.ui.graphics.Shape;
import androidx.compose.ui.graphics.TransformOrigin;
import androidx.compose.ui.layout.GraphicLayerInfo;
import androidx.compose.ui.node.OwnedLayer;
import androidx.compose.ui.platform.AndroidComposeView;
import androidx.compose.ui.platform.DeviceRenderNode;
import androidx.compose.ui.platform.LayerMatrixCache;
import androidx.compose.ui.platform.OutlineResolver;
import androidx.compose.ui.platform.RenderNodeApi23;
import androidx.compose.ui.platform.RenderNodeApi29;
import androidx.compose.ui.platform.RenderNodeLayer;
import androidx.compose.ui.platform.WrapperRenderNodeLayerHelperMethods;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 h2\u00020\u00012\u00020\u0002:\u0002hiB/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u0007H\u0002J\b\u0010*\u001a\u00020\bH\u0016J\u0010\u0010+\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u0007H\u0016J\b\u0010,\u001a\u00020\bH\u0016J\u001d\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020/H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b0\u00101J\u001d\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u000204H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b5\u00106J\u0018\u00107\u001a\u00020\b2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u000fH\u0016J%\u0010;\u001a\u0002042\u0006\u0010<\u001a\u0002042\u0006\u0010:\u001a\u00020\u000fH\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b=\u0010>J\u001d\u0010?\u001a\u00020\b2\u0006\u00103\u001a\u00020@H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bA\u0010BJ\u001d\u0010C\u001a\u00020\b2\u0006\u0010D\u001a\u00020EH\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bF\u0010BJ*\u0010G\u001a\u00020\b2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0016J\u001d\u0010H\u001a\u00020\b2\u0006\u0010.\u001a\u00020/H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bI\u00101J\b\u0010J\u001a\u00020\bH\u0002J\b\u0010K\u001a\u00020\bH\u0016J\u00af\u0001\u0010L\u001a\u00020\b2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020N2\u0006\u0010P\u001a\u00020N2\u0006\u0010Q\u001a\u00020N2\u0006\u0010R\u001a\u00020N2\u0006\u0010S\u001a\u00020N2\u0006\u0010T\u001a\u00020N2\u0006\u0010U\u001a\u00020N2\u0006\u0010V\u001a\u00020N2\u0006\u0010W\u001a\u00020N2\u0006\u0010%\u001a\u00020&2\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020\u000f2\b\u0010[\u001a\u0004\u0018\u00010\\2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020^2\u0006\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020eH\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bf\u0010gR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0018R\u000e\u0010\"\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010%\u001a\u00020&X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010'\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006j"}, d2={"Landroidx/compose/ui/platform/RenderNodeLayer;", "Landroidx/compose/ui/node/OwnedLayer;", "Landroidx/compose/ui/layout/GraphicLayerInfo;", "ownerView", "Landroidx/compose/ui/platform/AndroidComposeView;", "drawBlock", "Lkotlin/Function1;", "Landroidx/compose/ui/graphics/Canvas;", "", "invalidateParentLayer", "Lkotlin/Function0;", "(Landroidx/compose/ui/platform/AndroidComposeView;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "canvasHolder", "Landroidx/compose/ui/graphics/CanvasHolder;", "drawnWithZ", "", "isDestroyed", "value", "isDirty", "setDirty", "(Z)V", "layerId", "", "getLayerId", "()J", "matrixCache", "Landroidx/compose/ui/platform/LayerMatrixCache;", "Landroidx/compose/ui/platform/DeviceRenderNode;", "outlineResolver", "Landroidx/compose/ui/platform/OutlineResolver;", "getOwnerView", "()Landroidx/compose/ui/platform/AndroidComposeView;", "ownerViewId", "getOwnerViewId", "renderNode", "softwareLayerPaint", "Landroidx/compose/ui/graphics/Paint;", "transformOrigin", "Landroidx/compose/ui/graphics/TransformOrigin;", "J", "clipRenderNode", "canvas", "destroy", "drawLayer", "invalidate", "inverseTransform", "matrix", "Landroidx/compose/ui/graphics/Matrix;", "inverseTransform-58bKbWc", "([F)V", "isInLayer", "position", "Landroidx/compose/ui/geometry/Offset;", "isInLayer-k-4lQ0M", "(J)Z", "mapBounds", "rect", "Landroidx/compose/ui/geometry/MutableRect;", "inverse", "mapOffset", "point", "mapOffset-8S9VItk", "(JZ)J", "move", "Landroidx/compose/ui/unit/IntOffset;", "move--gyyYBs", "(J)V", "resize", "size", "Landroidx/compose/ui/unit/IntSize;", "resize-ozmzZPI", "reuseLayer", "transform", "transform-58bKbWc", "triggerRepaint", "updateDisplayList", "updateLayerProperties", "scaleX", "", "scaleY", "alpha", "translationX", "translationY", "shadowElevation", "rotationX", "rotationY", "rotationZ", "cameraDistance", "shape", "Landroidx/compose/ui/graphics/Shape;", "clip", "renderEffect", "Landroidx/compose/ui/graphics/RenderEffect;", "ambientShadowColor", "Landroidx/compose/ui/graphics/Color;", "spotShadowColor", "compositingStrategy", "Landroidx/compose/ui/graphics/CompositingStrategy;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "density", "Landroidx/compose/ui/unit/Density;", "updateLayerProperties-dDxr-wY", "(FFFFFFFFFFJLandroidx/compose/ui/graphics/Shape;ZLandroidx/compose/ui/graphics/RenderEffect;JJILandroidx/compose/ui/unit/LayoutDirection;Landroidx/compose/ui/unit/Density;)V", "Companion", "UniqueDrawingIdApi29", "ui_release"})
@RequiresApi(value=23)
@SourceDebugExtension(value={"SMAP\nRenderNodeLayer.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderNodeLayer.android.kt\nandroidx/compose/ui/platform/RenderNodeLayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,378:1\n1#2:379\n*E\n"})
public final class RenderNodeLayer
implements OwnedLayer,
GraphicLayerInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AndroidComposeView ownerView;
    @Nullable
    private Function1<? super Canvas, Unit> drawBlock;
    @Nullable
    private Function0<Unit> invalidateParentLayer;
    private boolean isDirty;
    @NotNull
    private final OutlineResolver outlineResolver;
    private boolean isDestroyed;
    private boolean drawnWithZ;
    @Nullable
    private Paint softwareLayerPaint;
    @NotNull
    private final LayerMatrixCache<DeviceRenderNode> matrixCache;
    @NotNull
    private final CanvasHolder canvasHolder;
    private long transformOrigin;
    @NotNull
    private final DeviceRenderNode renderNode;
    @NotNull
    private static final Function2<DeviceRenderNode, android.graphics.Matrix, Unit> getMatrix = Companion.getMatrix.1.INSTANCE;

    /*
     * WARNING - void declaration
     */
    public RenderNodeLayer(@NotNull AndroidComposeView ownerView, @NotNull Function1<? super Canvas, Unit> drawBlock, @NotNull Function0<Unit> invalidateParentLayer2) {
        void $this$renderNode_u24lambda_u240;
        DeviceRenderNode deviceRenderNode;
        Intrinsics.checkNotNullParameter((Object)ownerView, (String)"ownerView");
        Intrinsics.checkNotNullParameter(drawBlock, (String)"drawBlock");
        Intrinsics.checkNotNullParameter(invalidateParentLayer2, (String)"invalidateParentLayer");
        this.ownerView = ownerView;
        this.drawBlock = drawBlock;
        this.invalidateParentLayer = invalidateParentLayer2;
        this.outlineResolver = new OutlineResolver(this.ownerView.getDensity());
        this.matrixCache = new LayerMatrixCache<DeviceRenderNode>(getMatrix);
        this.canvasHolder = new CanvasHolder();
        this.transformOrigin = TransformOrigin.Companion.getCenter-SzJe1aQ();
        DeviceRenderNode deviceRenderNode2 = deviceRenderNode = Build.VERSION.SDK_INT >= 29 ? (DeviceRenderNode)new RenderNodeApi29(this.ownerView) : (DeviceRenderNode)new RenderNodeApi23(this.ownerView);
        RenderNodeLayer renderNodeLayer = this;
        boolean bl = false;
        $this$renderNode_u24lambda_u240.setHasOverlappingRendering(true);
        renderNodeLayer.renderNode = deviceRenderNode;
    }

    @NotNull
    public final AndroidComposeView getOwnerView() {
        return this.ownerView;
    }

    private final void setDirty(boolean value) {
        if (value != this.isDirty) {
            this.isDirty = value;
            this.ownerView.notifyLayerIsDirty$ui_release(this, value);
        }
    }

    @Override
    public long getLayerId() {
        return this.renderNode.getUniqueId();
    }

    @Override
    public long getOwnerViewId() {
        return Build.VERSION.SDK_INT >= 29 ? UniqueDrawingIdApi29.getUniqueDrawingId((View)this.ownerView) : -1L;
    }

    @Override
    public void updateLayerProperties-dDxr-wY(float scaleX, float scaleY, float alpha, float translationX, float translationY, float shadowElevation, float rotationX, float rotationY, float rotationZ, float cameraDistance, long transformOrigin, @NotNull Shape shape, boolean clip, @Nullable RenderEffect renderEffect, long ambientShadowColor, long spotShadowColor, int compositingStrategy, @NotNull LayoutDirection layoutDirection, @NotNull Density density) {
        boolean isClippingManually;
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        this.transformOrigin = transformOrigin;
        boolean wasClippingManually = this.renderNode.getClipToOutline() && !this.outlineResolver.getOutlineClipSupported();
        this.renderNode.setScaleX(scaleX);
        this.renderNode.setScaleY(scaleY);
        this.renderNode.setAlpha(alpha);
        this.renderNode.setTranslationX(translationX);
        this.renderNode.setTranslationY(translationY);
        this.renderNode.setElevation(shadowElevation);
        this.renderNode.setAmbientShadowColor(ColorKt.toArgb-8_81llA((long)ambientShadowColor));
        this.renderNode.setSpotShadowColor(ColorKt.toArgb-8_81llA((long)spotShadowColor));
        this.renderNode.setRotationZ(rotationZ);
        this.renderNode.setRotationX(rotationX);
        this.renderNode.setRotationY(rotationY);
        this.renderNode.setCameraDistance(cameraDistance);
        this.renderNode.setPivotX(TransformOrigin.getPivotFractionX-impl(transformOrigin) * (float)this.renderNode.getWidth());
        this.renderNode.setPivotY(TransformOrigin.getPivotFractionY-impl(transformOrigin) * (float)this.renderNode.getHeight());
        this.renderNode.setClipToOutline(clip && shape != RectangleShapeKt.getRectangleShape());
        this.renderNode.setClipToBounds(clip && shape == RectangleShapeKt.getRectangleShape());
        this.renderNode.setRenderEffect(renderEffect);
        this.renderNode.setCompositingStrategy-aDBOjCE(compositingStrategy);
        boolean shapeChanged = this.outlineResolver.update(shape, this.renderNode.getAlpha(), this.renderNode.getClipToOutline(), this.renderNode.getElevation(), layoutDirection, density);
        this.renderNode.setOutline(this.outlineResolver.getOutline());
        boolean bl = isClippingManually = this.renderNode.getClipToOutline() && !this.outlineResolver.getOutlineClipSupported();
        if (wasClippingManually != isClippingManually || isClippingManually && shapeChanged) {
            this.invalidate();
        } else {
            this.triggerRepaint();
        }
        if (!this.drawnWithZ && this.renderNode.getElevation() > 0.0f) {
            Function0<Unit> function0 = this.invalidateParentLayer;
            if (function0 != null) {
                function0.invoke();
            }
        }
        this.matrixCache.invalidate();
    }

    @Override
    public boolean isInLayer-k-4lQ0M(long position) {
        float x = Offset.getX-impl((long)position);
        float y = Offset.getY-impl((long)position);
        if (this.renderNode.getClipToBounds()) {
            return 0.0f <= x && x < (float)this.renderNode.getWidth() && 0.0f <= y && y < (float)this.renderNode.getHeight();
        }
        if (this.renderNode.getClipToOutline()) {
            return this.outlineResolver.isInOutline-k-4lQ0M(position);
        }
        return true;
    }

    @Override
    public void resize-ozmzZPI(long size) {
        int width = IntSize.getWidth-impl((long)size);
        int height = IntSize.getHeight-impl((long)size);
        this.renderNode.setPivotX(TransformOrigin.getPivotFractionX-impl(this.transformOrigin) * (float)width);
        this.renderNode.setPivotY(TransformOrigin.getPivotFractionY-impl(this.transformOrigin) * (float)height);
        if (this.renderNode.setPosition(this.renderNode.getLeft(), this.renderNode.getTop(), this.renderNode.getLeft() + width, this.renderNode.getTop() + height)) {
            this.outlineResolver.update-uvyYCjk(SizeKt.Size((float)width, (float)height));
            this.renderNode.setOutline(this.outlineResolver.getOutline());
            this.invalidate();
            this.matrixCache.invalidate();
        }
    }

    @Override
    public void move--gyyYBs(long position) {
        int oldLeft = this.renderNode.getLeft();
        int oldTop = this.renderNode.getTop();
        int newLeft = IntOffset.getX-impl((long)position);
        int newTop = IntOffset.getY-impl((long)position);
        if (oldLeft != newLeft || oldTop != newTop) {
            this.renderNode.offsetLeftAndRight(newLeft - oldLeft);
            this.renderNode.offsetTopAndBottom(newTop - oldTop);
            this.triggerRepaint();
            this.matrixCache.invalidate();
        }
    }

    @Override
    public void invalidate() {
        if (!this.isDirty && !this.isDestroyed) {
            this.ownerView.invalidate();
            this.setDirty(true);
        }
    }

    private final void triggerRepaint() {
        if (Build.VERSION.SDK_INT >= 26) {
            WrapperRenderNodeLayerHelperMethods.INSTANCE.onDescendantInvalidated(this.ownerView);
        } else {
            this.ownerView.invalidate();
        }
    }

    @Override
    public void drawLayer(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        android.graphics.Canvas androidCanvas = AndroidCanvas_androidKt.getNativeCanvas((Canvas)canvas);
        if (androidCanvas.isHardwareAccelerated()) {
            this.updateDisplayList();
            boolean bl = this.drawnWithZ = this.renderNode.getElevation() > 0.0f;
            if (this.drawnWithZ) {
                canvas.enableZ();
            }
            this.renderNode.drawInto(androidCanvas);
            if (this.drawnWithZ) {
                canvas.disableZ();
            }
        } else {
            float left = this.renderNode.getLeft();
            float top = this.renderNode.getTop();
            float right = this.renderNode.getRight();
            float bottom = this.renderNode.getBottom();
            if (this.renderNode.getAlpha() < 1.0f) {
                Paint paint;
                Paint paint2 = this.softwareLayerPaint;
                if (paint2 == null) {
                    Paint paint3;
                    Paint it = paint3 = AndroidPaint_androidKt.Paint();
                    boolean bl = false;
                    this.softwareLayerPaint = it;
                    paint2 = paint3;
                }
                Paint $this$drawLayer_u24lambda_u242 = paint = paint2;
                boolean bl = false;
                $this$drawLayer_u24lambda_u242.setAlpha(this.renderNode.getAlpha());
                Paint paint4 = paint;
                androidCanvas.saveLayer(left, top, right, bottom, paint4.asFrameworkPaint());
            } else {
                canvas.save();
            }
            canvas.translate(left, top);
            canvas.concat-58bKbWc(this.matrixCache.calculateMatrix-GrdbGEg(this.renderNode));
            this.clipRenderNode(canvas);
            Function1<? super Canvas, Unit> function1 = this.drawBlock;
            if (function1 != null) {
                function1.invoke((Object)canvas);
            }
            canvas.restore();
            this.setDirty(false);
        }
    }

    private final void clipRenderNode(Canvas canvas) {
        if (this.renderNode.getClipToOutline() || this.renderNode.getClipToBounds()) {
            this.outlineResolver.clipToOutline(canvas);
        }
    }

    @Override
    public void updateDisplayList() {
        block1: {
            if (!this.isDirty && this.renderNode.getHasDisplayList()) break block1;
            this.setDirty(false);
            Path clipPath = this.renderNode.getClipToOutline() && !this.outlineResolver.getOutlineClipSupported() ? this.outlineResolver.getClipPath() : null;
            Function1<? super Canvas, Unit> function1 = this.drawBlock;
            if (function1 != null) {
                Function1<? super Canvas, Unit> it = function1;
                boolean bl = false;
                this.renderNode.record(this.canvasHolder, clipPath, it);
            }
        }
    }

    @Override
    public void destroy() {
        if (this.renderNode.getHasDisplayList()) {
            this.renderNode.discardDisplayList();
        }
        this.drawBlock = null;
        this.invalidateParentLayer = null;
        this.isDestroyed = true;
        this.setDirty(false);
        this.ownerView.requestClearInvalidObservations();
        this.ownerView.recycle$ui_release(this);
    }

    @Override
    public long mapOffset-8S9VItk(long point, boolean inverse) {
        long l;
        if (inverse) {
            float[] fArray = this.matrixCache.calculateInverseMatrix-bWbORWo(this.renderNode);
            l = fArray != null ? Matrix.map-MK-Hz9U((float[])fArray, (long)point) : Offset.Companion.getInfinite-F1C5BW0();
        } else {
            l = Matrix.map-MK-Hz9U((float[])this.matrixCache.calculateMatrix-GrdbGEg(this.renderNode), (long)point);
        }
        return l;
    }

    @Override
    public void mapBounds(@NotNull MutableRect rect, boolean inverse) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        if (inverse) {
            float[] matrix = this.matrixCache.calculateInverseMatrix-bWbORWo(this.renderNode);
            if (matrix == null) {
                rect.set(0.0f, 0.0f, 0.0f, 0.0f);
            } else {
                Matrix.map-impl((float[])matrix, (MutableRect)rect);
            }
        } else {
            Matrix.map-impl((float[])this.matrixCache.calculateMatrix-GrdbGEg(this.renderNode), (MutableRect)rect);
        }
    }

    @Override
    public void reuseLayer(@NotNull Function1<? super Canvas, Unit> drawBlock, @NotNull Function0<Unit> invalidateParentLayer2) {
        Intrinsics.checkNotNullParameter(drawBlock, (String)"drawBlock");
        Intrinsics.checkNotNullParameter(invalidateParentLayer2, (String)"invalidateParentLayer");
        this.setDirty(false);
        this.isDestroyed = false;
        this.drawnWithZ = false;
        this.transformOrigin = TransformOrigin.Companion.getCenter-SzJe1aQ();
        this.drawBlock = drawBlock;
        this.invalidateParentLayer = invalidateParentLayer2;
    }

    @Override
    public void transform-58bKbWc(@NotNull float[] matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Matrix.timesAssign-58bKbWc((float[])matrix, (float[])this.matrixCache.calculateMatrix-GrdbGEg(this.renderNode));
    }

    @Override
    public void inverseTransform-58bKbWc(@NotNull float[] matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        float[] inverse = this.matrixCache.calculateInverseMatrix-bWbORWo(this.renderNode);
        if (inverse != null) {
            Matrix.timesAssign-58bKbWc((float[])matrix, (float[])inverse);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/compose/ui/platform/RenderNodeLayer$Companion;", "", "()V", "getMatrix", "Lkotlin/Function2;", "Landroidx/compose/ui/platform/DeviceRenderNode;", "Landroid/graphics/Matrix;", "", "ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Landroidx/compose/ui/platform/RenderNodeLayer$UniqueDrawingIdApi29;", "", "()V", "getUniqueDrawingId", "", "view", "Landroid/view/View;", "ui_release"})
    @RequiresApi(value=29)
    private static final class UniqueDrawingIdApi29 {
        @NotNull
        public static final UniqueDrawingIdApi29 INSTANCE = new UniqueDrawingIdApi29();

        private UniqueDrawingIdApi29() {
        }

        @JvmStatic
        @DoNotInline
        public static final long getUniqueDrawingId(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            return view.getUniqueDrawingId();
        }
    }
}

