/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.lint;

import androidx.compose.lint.ComposableUtilsKt;
import androidx.compose.lint.PsiUtilsKt;
import androidx.compose.runtime.lint.ComposableLambdaParameterDetector;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UVariable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\r"}, d2={"Landroidx/compose/runtime/lint/ComposableLambdaParameterDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UMethod;", "Companion", "runtime-lint"})
public final class ComposableLambdaParameterDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue ComposableLambdaParameterNaming;
    @NotNull
    private static final Issue ComposableLambdaParameterPosition;

    @NotNull
    public List<Class<UMethod>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UMethod.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            /*
             * WARNING - void declaration
             */
            public void visitMethod(UMethod node) {
                @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"androidx/compose/runtime/lint/ComposableLambdaParameterDetector$createUastHandler$1$visitMethod$ComposableLambdaParameterInfo", "", "parameter", "Lorg/jetbrains/uast/UParameter;", "functionType", "Lorg/jetbrains/kotlin/psi/KtFunctionType;", "(Lorg/jetbrains/uast/UParameter;Lorg/jetbrains/kotlin/psi/KtFunctionType;)V", "getFunctionType", "()Lorg/jetbrains/kotlin/psi/KtFunctionType;", "getParameter", "()Lorg/jetbrains/uast/UParameter;", "runtime-lint"})
                public final class ComposableLambdaParameterInfo {
                    private final UParameter parameter;
                    private final KtFunctionType functionType;

                    public ComposableLambdaParameterInfo(UParameter parameter, KtFunctionType functionType) {
                        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                        Intrinsics.checkNotNullParameter((Object)functionType, (String)"functionType");
                        this.parameter = parameter;
                        this.functionType = functionType;
                    }

                    public final UParameter getParameter() {
                        return this.parameter;
                    }

                    public final KtFunctionType getFunctionType() {
                        return this.functionType;
                    }
                }
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!ComposableUtilsKt.isComposable((PsiMethod)node)) {
                    return;
                }
                if (!PsiUtilsKt.getReturnsUnit((PsiMethod)node)) {
                    return;
                }
                Iterable $this$mapNotNull$iv = node.getUastParameters();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ComposableLambdaParameterInfo composableLambdaParameterInfo;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    UParameter parameter = (UParameter)element$iv$iv;
                    boolean bl2 = false;
                    PsiElement psiElement = parameter.getSourcePsi();
                    if ((psiElement instanceof KtParameter ? (KtParameter)psiElement : null) == null) {
                        composableLambdaParameterInfo = null;
                    } else {
                        KtFunctionType functionType;
                        KtTypeElement ktTypeElement;
                        KtParameter ktParameter;
                        ktParameter = ktParameter;
                        boolean isComposable = ComposableUtilsKt.isComposable((UVariable)parameter);
                        KtTypeReference ktTypeReference = ktParameter.getTypeReference();
                        Intrinsics.checkNotNull((Object)ktTypeReference);
                        KtTypeElement type = ktTypeReference.getTypeElement();
                        Object object = type instanceof KtFunctionType ? (KtFunctionType)type : (type instanceof KtNullableType ? ((ktTypeElement = ((KtNullableType)type).getInnerType()) instanceof KtFunctionType ? (KtFunctionType)ktTypeElement : null) : (functionType = null));
                        composableLambdaParameterInfo = functionType != null && isComposable ? new ComposableLambdaParameterInfo(parameter, functionType) : null;
                    }
                    if (composableLambdaParameterInfo == null) continue;
                    ComposableLambdaParameterInfo it$iv$iv = composableLambdaParameterInfo;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List composableLambdaParameters = (List)destination$iv$iv;
                if (composableLambdaParameters.size() != 1) {
                    return;
                }
                ComposableLambdaParameterInfo parameterInfo = (ComposableLambdaParameterInfo)CollectionsKt.first((List)composableLambdaParameters);
                UParameter parameter = parameterInfo.getParameter();
                String string = parameter.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameter.name");
                String name = string;
                UElement uElement = (UElement)parameter;
                if (!Intrinsics.areEqual((Object)name, (Object)"content") && parameterInfo.getFunctionType().getParameters().isEmpty()) {
                    this.$context.report(ComposableLambdaParameterDetector.Companion.getComposableLambdaParameterNaming(), uElement, this.$context.getNameLocation(uElement), "Composable lambda parameter should be named `content`", LintFix.Companion.create().replace().name("Rename " + name + " to content").text(name).with("content").autoFix().build());
                }
                if (parameter != CollectionsKt.last((List)node.getUastParameters())) {
                    JavaContext.report$default((JavaContext)this.$context, (Issue)ComposableLambdaParameterDetector.Companion.getComposableLambdaParameterPosition(), (UElement)uElement, (Location)this.$context.getNameLocation(uElement), (String)"Composable lambda parameter should be the last parameter so it can be used as a trailing lambda", null, (int)16, null);
                }
            }
        };
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(ComposableLambdaParameterDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES));
        ComposableLambdaParameterNaming = Issue.Companion.create$default((Issue.Companion)companion, (String)"ComposableLambdaParameterNaming", (String)"Primary composable lambda parameter not named `content`", (String)"Composable functions with only one composable lambda parameter should use the name `content` for the parameter.", (Implementation)implementation, null, (Category)category, (int)3, (Severity)severity, (boolean)false, null, null, null, (int)3600, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = new Implementation(ComposableLambdaParameterDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES));
        ComposableLambdaParameterPosition = Issue.Companion.create$default((Issue.Companion)companion, (String)"ComposableLambdaParameterPosition", (String)"Non-trailing primary composable lambda parameter", (String)"Composable functions with only one composable lambda parameter should place the parameter at the end of the parameter list, so it can be used as a trailing lambda.", (Implementation)implementation, null, (Category)category, (int)3, (Severity)severity, (boolean)false, null, null, null, (int)3600, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Landroidx/compose/runtime/lint/ComposableLambdaParameterDetector$Companion;", "", "()V", "ComposableLambdaParameterNaming", "Lcom/android/tools/lint/detector/api/Issue;", "getComposableLambdaParameterNaming", "()Lcom/android/tools/lint/detector/api/Issue;", "ComposableLambdaParameterPosition", "getComposableLambdaParameterPosition", "runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getComposableLambdaParameterNaming() {
            return ComposableLambdaParameterNaming;
        }

        @NotNull
        public final Issue getComposableLambdaParameterPosition() {
            return ComposableLambdaParameterPosition;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

