/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import androidx.annotation.VisibleForTesting;
import androidx.compose.material3.carousel.Keyline;
import androidx.compose.material3.carousel.KeylineList;
import androidx.compose.ui.util.MathHelpersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\b\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0001\u001a \u0010\u0000\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0005H\u0001\u001a0\u0010\u0000\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"lerp", "Landroidx/compose/material3/carousel/Keyline;", "start", "end", "fraction", "", "Landroidx/compose/material3/carousel/KeylineList;", "from", "to", "outputMin", "outputMax", "inputMin", "inputMax", "value", "material3_release"})
@SourceDebugExtension(value={"SMAP\nStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Strategy.kt\nandroidx/compose/material3/carousel/StrategyKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,509:1\n277#2,3:510\n69#2,4:513\n280#2,2:517\n74#2:519\n282#2:520\n*S KotlinDebug\n*F\n+ 1 Strategy.kt\nandroidx/compose/material3/carousel/StrategyKt\n*L\n488#1:510,3\n488#1:513,4\n488#1:517,2\n488#1:519\n488#1:520\n*E\n"})
public final class StrategyKt {
    @VisibleForTesting
    @NotNull
    public static final Keyline lerp(@NotNull Keyline start, @NotNull Keyline end, float fraction) {
        return new Keyline(MathHelpersKt.lerp((float)start.getSize(), (float)end.getSize(), (float)fraction), MathHelpersKt.lerp((float)start.getOffset(), (float)end.getOffset(), (float)fraction), MathHelpersKt.lerp((float)start.getUnadjustedOffset(), (float)end.getUnadjustedOffset(), (float)fraction), fraction < 0.5f ? start.isFocal() : end.isFocal(), fraction < 0.5f ? start.isAnchor() : end.isAnchor(), fraction < 0.5f ? start.isPivot() : end.isPivot(), MathHelpersKt.lerp((float)start.getCutoff(), (float)end.getCutoff(), (float)fraction));
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final KeylineList lerp(@NotNull KeylineList from, @NotNull KeylineList to, float fraction) {
        List $this$fastMapIndexed$iv = from;
        boolean $i$f$fastMapIndexed = false;
        ArrayList target$iv = new ArrayList($this$fastMapIndexed$iv.size());
        List $this$fastForEachIndexed$iv$iv = $this$fastMapIndexed$iv;
        boolean $i$f$fastForEachIndexed = false;
        int index$iv$iv = 0;
        int n = $this$fastForEachIndexed$iv$iv.size();
        while (index$iv$iv < n) {
            void i;
            void k;
            void e$iv;
            Object item$iv$iv;
            Object e = item$iv$iv = $this$fastForEachIndexed$iv$iv.get(index$iv$iv);
            int index$iv = index$iv$iv++;
            boolean bl = false;
            Keyline keyline = (Keyline)e$iv;
            int n2 = index$iv;
            Collection collection = target$iv;
            boolean bl2 = false;
            collection.add(StrategyKt.lerp((Keyline)k, to.get((int)i), fraction));
        }
        List interpolatedKeylines = target$iv;
        return new KeylineList(interpolatedKeylines);
    }

    private static final float lerp(float outputMin, float outputMax, float inputMin, float inputMax, float value) {
        if (value <= inputMin) {
            return outputMin;
        }
        if (value >= inputMax) {
            return outputMax;
        }
        return MathHelpersKt.lerp((float)outputMin, (float)outputMax, (float)((value - inputMin) / (inputMax - inputMin)));
    }

    public static final /* synthetic */ float access$lerp(float outputMin, float outputMax, float inputMin, float inputMax, float value) {
        return StrategyKt.lerp(outputMin, outputMax, inputMin, inputMax, value);
    }
}

