/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.KeyboardReturn: ImageVector
    get() {
        if (_keyboardReturn != null) {
            return _keyboardReturn!!
        }
        _keyboardReturn = materialIcon(name = "TwoTone.KeyboardReturn") {
            materialPath {
                moveTo(19.0f, 7.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(5.83f)
                lineToRelative(3.58f, -3.59f)
                lineTo(8.0f, 6.0f)
                lineToRelative(-6.0f, 6.0f)
                lineToRelative(6.0f, 6.0f)
                lineToRelative(1.41f, -1.41f)
                lineTo(5.83f, 13.0f)
                horizontalLineTo(21.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
        }
        return _keyboardReturn!!
    }

private var _keyboardReturn: ImageVector? = null
