/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Bento: ImageVector
    get() {
        if (_bento != null) {
            return _bento!!
        }
        _bento = materialIcon(name = "TwoTone.Bento") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.0f, 17.0f)
                horizontalLineToRelative(8.0f)
                verticalLineTo(7.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(17.0f)
                close()
                moveTo(8.0f, 10.5f)
                curveToRelative(0.83f, 0.0f, 1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveTo(8.83f, 13.5f, 8.0f, 13.5f)
                reflectiveCurveTo(6.5f, 12.83f, 6.5f, 12.0f)
                reflectiveCurveTo(7.17f, 10.5f, 8.0f, 10.5f)
                close()
                moveTo(14.0f, 13.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-6.0f)
                verticalLineTo(13.0f)
                close()
                moveTo(20.0f, 7.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-6.0f)
                verticalLineTo(7.0f)
                horizontalLineTo(20.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 5.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 5.0f, 2.0f, 5.9f, 2.0f, 7.0f)
                verticalLineToRelative(10.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(7.0f)
                curveTo(22.0f, 5.9f, 21.1f, 5.0f, 20.0f, 5.0f)
                close()
                moveTo(20.0f, 11.0f)
                horizontalLineToRelative(-6.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(6.0f)
                verticalLineTo(11.0f)
                close()
                moveTo(4.0f, 7.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(10.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(14.0f, 17.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(14.0f)
                close()
                moveTo(9.5f, 12.0f)
                curveToRelative(0.0f, 0.83f, -0.67f, 1.5f, -1.5f, 1.5f)
                reflectiveCurveTo(6.5f, 12.83f, 6.5f, 12.0f)
                reflectiveCurveToRelative(0.67f, -1.5f, 1.5f, -1.5f)
                reflectiveCurveTo(9.5f, 11.17f, 9.5f, 12.0f)
                close()
            }
        }
        return _bento!!
    }

private var _bento: ImageVector? = null
