/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Weekend: ImageVector
    get() {
        if (_weekend != null) {
            return _weekend!!
        }
        _weekend = materialIcon(name = "Sharp.Weekend") {
            materialPath {
                moveTo(6.0f, 9.03f)
                verticalLineTo(14.0f)
                horizontalLineToRelative(12.0f)
                verticalLineTo(9.03f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(5.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(4.03f)
                close()
                moveTo(19.0f, 15.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(-4.97f)
                horizontalLineTo(1.0f)
                verticalLineTo(19.0f)
                horizontalLineToRelative(22.0f)
                verticalLineToRelative(-8.97f)
                horizontalLineToRelative(-4.0f)
                close()
            }
        }
        return _weekend!!
    }

private var _weekend: ImageVector? = null
