/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PrecisionManufacturing: ImageVector
    get() {
        if (_precisionManufacturing != null) {
            return _precisionManufacturing!!
        }
        _precisionManufacturing = materialIcon(name = "Sharp.PrecisionManufacturing") {
            materialPath {
                moveTo(14.0f, 10.0f)
                verticalLineTo(9.82f)
                lineToRelative(2.01f, 2.01f)
                lineToRelative(5.23f, -2.44f)
                lineToRelative(-0.63f, -1.36f)
                lineToRelative(-4.28f, 2.0f)
                lineTo(14.0f, 7.7f)
                verticalLineTo(6.3f)
                lineToRelative(2.33f, -2.33f)
                lineToRelative(4.28f, 2.0f)
                lineToRelative(0.63f, -1.36f)
                lineToRelative(-5.23f, -2.44f)
                lineTo(14.0f, 4.18f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(8.82f)
                curveTo(8.4f, 4.84f, 7.3f, 4.0f, 6.0f, 4.0f)
                curveTo(4.34f, 4.0f, 3.0f, 5.34f, 3.0f, 7.0f)
                curveToRelative(0.0f, 1.1f, 0.6f, 2.05f, 1.48f, 2.58f)
                lineTo(7.08f, 18.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(13.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(-3.62f)
                lineTo(8.41f, 8.76f)
                curveTo(8.58f, 8.53f, 8.72f, 8.28f, 8.82f, 8.0f)
                horizontalLineTo(12.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(14.0f)
                close()
                moveTo(6.0f, 8.0f)
                curveTo(5.45f, 8.0f, 5.0f, 7.55f, 5.0f, 7.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(7.0f, 7.55f, 6.55f, 8.0f, 6.0f, 8.0f)
                close()
            }
        }
        return _precisionManufacturing!!
    }

private var _precisionManufacturing: ImageVector? = null
