/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.BreakfastDining: ImageVector
    get() {
        if (_breakfastDining != null) {
            return _breakfastDining!!
        }
        _breakfastDining = materialIcon(name = "Sharp.BreakfastDining") {
            materialPath {
                moveTo(17.85f, 3.0f)
                lineTo(6.14f, 3.0f)
                curveTo(4.15f, 3.0f, 2.36f, 4.39f, 2.05f, 6.36f)
                curveTo(1.78f, 8.11f, 2.64f, 9.65f, 4.0f, 10.45f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(10.45f)
                curveToRelative(1.36f, -0.79f, 2.23f, -2.36f, 1.95f, -4.11f)
                curveTo(21.63f, 4.38f, 19.83f, 3.0f, 17.85f, 3.0f)
                close()
                moveTo(16.41f, 13.0f)
                lineTo(12.0f, 17.42f)
                lineTo(7.59f, 13.0f)
                lineTo(12.0f, 8.59f)
                lineTo(16.41f, 13.0f)
                close()
            }
        }
        return _breakfastDining!!
    }

private var _breakfastDining: ImageVector? = null
