/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ThumbUpAlt: ImageVector
    get() {
        if (_thumbUpAlt != null) {
            return _thumbUpAlt!!
        }
        _thumbUpAlt = materialIcon(name = "Rounded.ThumbUpAlt") {
            materialPath {
                moveTo(13.12f, 2.06f)
                lineTo(7.58f, 7.6f)
                curveToRelative(-0.37f, 0.37f, -0.58f, 0.88f, -0.58f, 1.41f)
                verticalLineTo(19.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(9.0f)
                curveToRelative(0.8f, 0.0f, 1.52f, -0.48f, 1.84f, -1.21f)
                lineToRelative(3.26f, -7.61f)
                curveTo(23.94f, 10.2f, 22.49f, 8.0f, 20.34f, 8.0f)
                horizontalLineToRelative(-5.65f)
                lineToRelative(0.95f, -4.58f)
                curveToRelative(0.1f, -0.5f, -0.05f, -1.01f, -0.41f, -1.37f)
                curveToRelative(-0.59f, -0.58f, -1.53f, -0.58f, -2.11f, 0.01f)
                close()
                moveTo(3.0f, 21.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-8.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(8.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                close()
            }
        }
        return _thumbUpAlt!!
    }

private var _thumbUpAlt: ImageVector? = null
