/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.TempleBuddhist: ImageVector
    get() {
        if (_templeBuddhist != null) {
            return _templeBuddhist!!
        }
        _templeBuddhist = materialIcon(name = "Rounded.TempleBuddhist") {
            materialPath {
                moveTo(21.85f, 9.01f)
                curveToRelative(-0.41f, 0.0f, -0.82f, 0.24f, -0.95f, 0.63f)
                curveTo(20.64f, 10.43f, 19.89f, 11.0f, 19.02f, 11.0f)
                horizontalLineTo(4.98f)
                curveToRelative(-0.87f, 0.0f, -1.62f, -0.57f, -1.88f, -1.36f)
                curveTo(2.97f, 9.25f, 2.57f, 9.02f, 2.16f, 9.02f)
                horizontalLineToRelative(0.0f)
                curveTo(1.5f, 9.02f, 1.0f, 9.66f, 1.21f, 10.28f)
                curveToRelative(0.43f, 1.27f, 1.48f, 2.24f, 2.79f, 2.58f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(4.0f)
                lineToRelative(0.0f, -2.89f)
                curveToRelative(0.0f, -1.0f, 0.68f, -1.92f, 1.66f, -2.08f)
                curveTo(12.92f, 16.82f, 14.0f, 17.79f, 14.0f, 19.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-7.14f)
                curveToRelative(0.46f, -0.12f, 2.22f, -0.76f, 2.81f, -2.58f)
                curveTo(23.01f, 9.65f, 22.51f, 9.0f, 21.85f, 9.01f)
                lineTo(21.85f, 9.01f)
                close()
            }
            materialPath {
                moveTo(6.0f, 8.86f)
                verticalLineTo(10.0f)
                horizontalLineToRelative(12.0f)
                verticalLineTo(8.86f)
                curveToRelative(0.46f, -0.12f, 2.22f, -0.76f, 2.81f, -2.58f)
                curveToRelative(0.2f, -0.63f, -0.3f, -1.27f, -0.96f, -1.27f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.41f, 0.0f, -0.82f, 0.24f, -0.95f, 0.63f)
                curveTo(18.64f, 6.43f, 17.89f, 7.0f, 17.02f, 7.0f)
                horizontalLineTo(6.98f)
                curveTo(6.11f, 7.0f, 5.36f, 6.43f, 5.1f, 5.64f)
                curveTo(4.97f, 5.25f, 4.57f, 5.02f, 4.16f, 5.02f)
                horizontalLineToRelative(0.0f)
                curveTo(3.5f, 5.02f, 3.0f, 5.66f, 3.21f, 6.28f)
                curveTo(3.64f, 7.55f, 4.69f, 8.53f, 6.0f, 8.86f)
                close()
            }
            materialPath {
                moveTo(11.2f, 2.07f)
                lineTo(8.25f, 6.0f)
                horizontalLineToRelative(7.5f)
                lineTo(12.8f, 2.07f)
                curveTo(12.4f, 1.53f, 11.6f, 1.53f, 11.2f, 2.07f)
                close()
            }
        }
        return _templeBuddhist!!
    }

private var _templeBuddhist: ImageVector? = null
