/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SignalWifiBad: ImageVector
    get() {
        if (_signalWifiBad != null) {
            return _signalWifiBad!!
        }
        _signalWifiBad = materialIcon(name = "Rounded.SignalWifiBad") {
            materialPath {
                moveTo(23.21f, 8.24f)
                curveTo(20.22f, 5.6f, 16.3f, 4.0f, 12.0f, 4.0f)
                curveTo(7.7f, 4.0f, 3.78f, 5.6f, 0.79f, 8.24f)
                curveTo(0.35f, 8.63f, 0.32f, 9.3f, 0.73f, 9.71f)
                lineToRelative(10.56f, 10.58f)
                curveToRelative(0.19f, 0.19f, 0.45f, 0.29f, 0.7f, 0.29f)
                verticalLineTo(14.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                horizontalLineToRelative(6.99f)
                lineToRelative(2.29f, -2.29f)
                curveTo(23.68f, 9.3f, 23.65f, 8.63f, 23.21f, 8.24f)
                close()
            }
            materialPath {
                moveTo(20.3f, 14.71f)
                lineTo(20.3f, 14.71f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(-1.39f, 1.38f)
                lineToRelative(-1.39f, -1.38f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(1.39f, 1.39f)
                lineToRelative(-1.39f, 1.39f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(1.39f, -1.38f)
                lineToRelative(1.39f, 1.38f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(-1.38f, -1.39f)
                lineToRelative(1.38f, -1.39f)
                curveTo(20.69f, 15.73f, 20.69f, 15.1f, 20.3f, 14.71f)
                close()
            }
        }
        return _signalWifiBad!!
    }

private var _signalWifiBad: ImageVector? = null
