/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SettingsRemote: ImageVector
    get() {
        if (_settingsRemote != null) {
            return _settingsRemote!!
        }
        _settingsRemote = materialIcon(name = "Rounded.SettingsRemote") {
            materialPath {
                moveTo(15.0f, 9.0f)
                horizontalLineTo(9.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(10.0f)
                curveTo(16.0f, 9.45f, 15.55f, 9.0f, 15.0f, 9.0f)
                close()
                moveTo(12.0f, 14.25f)
                curveToRelative(-0.69f, 0.0f, -1.25f, -0.56f, -1.25f, -1.25f)
                reflectiveCurveToRelative(0.56f, -1.25f, 1.25f, -1.25f)
                reflectiveCurveToRelative(1.25f, 0.56f, 1.25f, 1.25f)
                reflectiveCurveTo(12.69f, 14.25f, 12.0f, 14.25f)
                close()
            }
            materialPath {
                moveTo(7.82f, 6.82f)
                lineTo(7.82f, 6.82f)
                curveToRelative(0.35f, 0.35f, 0.9f, 0.38f, 1.3f, 0.1f)
                curveTo(9.93f, 6.34f, 10.93f, 6.0f, 12.0f, 6.0f)
                curveToRelative(1.07f, 0.0f, 2.07f, 0.34f, 2.88f, 0.91f)
                curveToRelative(0.4f, 0.28f, 0.95f, 0.26f, 1.3f, -0.09f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.43f, -0.43f, 0.39f, -1.15f, -0.09f, -1.5f)
                curveTo(14.94f, 4.49f, 13.53f, 4.0f, 12.0f, 4.0f)
                curveToRelative(-1.53f, 0.0f, -2.94f, 0.49f, -4.09f, 1.32f)
                curveTo(7.42f, 5.67f, 7.39f, 6.39f, 7.82f, 6.82f)
                close()
            }
            materialPath {
                moveTo(12.0f, 0.0f)
                curveTo(9.36f, 0.0f, 6.94f, 0.93f, 5.05f, 2.47f)
                curveToRelative(-0.46f, 0.38f, -0.5f, 1.07f, -0.08f, 1.49f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.36f, 0.36f, 0.93f, 0.39f, 1.32f, 0.07f)
                curveTo(7.84f, 2.77f, 9.83f, 2.0f, 12.0f, 2.0f)
                curveToRelative(2.17f, 0.0f, 4.16f, 0.77f, 5.7f, 2.04f)
                curveToRelative(0.39f, 0.32f, 0.96f, 0.29f, 1.32f, -0.07f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.42f, -0.42f, 0.38f, -1.11f, -0.08f, -1.49f)
                curveTo(17.06f, 0.93f, 14.64f, 0.0f, 12.0f, 0.0f)
                close()
            }
        }
        return _settingsRemote!!
    }

private var _settingsRemote: ImageVector? = null
