/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SettingsBrightness: ImageVector
    get() {
        if (_settingsBrightness != null) {
            return _settingsBrightness!!
        }
        _settingsBrightness = materialIcon(name = "Rounded.SettingsBrightness") {
            materialPath {
                moveTo(20.0f, 4.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 4.0f, 2.0f, 4.9f, 2.0f, 6.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(6.0f)
                curveTo(22.0f, 4.9f, 21.1f, 4.0f, 20.0f, 4.0f)
                close()
                moveTo(17.15f, 12.35f)
                lineTo(16.0f, 13.5f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 0.28f, -0.22f, 0.5f, -0.5f, 0.5f)
                horizontalLineToRelative(-2.0f)
                lineToRelative(-1.15f, 1.15f)
                curveToRelative(-0.2f, 0.2f, -0.51f, 0.2f, -0.71f, 0.0f)
                lineTo(10.5f, 16.0f)
                horizontalLineToRelative(-2.0f)
                curveTo(8.22f, 16.0f, 8.0f, 15.78f, 8.0f, 15.5f)
                verticalLineToRelative(-2.0f)
                lineToRelative(-1.15f, -1.15f)
                curveToRelative(-0.2f, -0.2f, -0.2f, -0.51f, 0.0f, -0.71f)
                lineTo(8.0f, 10.5f)
                verticalLineToRelative(-2.0f)
                curveTo(8.0f, 8.22f, 8.22f, 8.0f, 8.5f, 8.0f)
                horizontalLineToRelative(2.0f)
                lineToRelative(1.15f, -1.15f)
                curveToRelative(0.2f, -0.2f, 0.51f, -0.2f, 0.71f, 0.0f)
                lineTo(13.5f, 8.0f)
                horizontalLineToRelative(2.0f)
                curveTo(15.78f, 8.0f, 16.0f, 8.22f, 16.0f, 8.5f)
                verticalLineToRelative(2.0f)
                lineToRelative(1.15f, 1.15f)
                curveTo(17.34f, 11.84f, 17.34f, 12.16f, 17.15f, 12.35f)
                close()
                moveTo(12.0f, 9.0f)
                verticalLineToRelative(6.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                curveTo(15.0f, 10.34f, 13.66f, 9.0f, 12.0f, 9.0f)
                close()
            }
        }
        return _settingsBrightness!!
    }

private var _settingsBrightness: ImageVector? = null
