/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Plumbing: ImageVector
    get() {
        if (_plumbing != null) {
            return _plumbing!!
        }
        _plumbing = materialIcon(name = "Rounded.Plumbing") {
            materialPath {
                moveTo(19.28f, 4.93f)
                lineToRelative(-2.12f, -2.12f)
                curveToRelative(-0.78f, -0.78f, -2.05f, -0.78f, -2.83f, 0.0f)
                lineTo(11.5f, 5.64f)
                lineToRelative(2.12f, 2.12f)
                lineToRelative(2.12f, -2.12f)
                lineToRelative(3.54f, 3.54f)
                curveTo(20.45f, 8.0f, 20.45f, 6.1f, 19.28f, 4.93f)
                close()
            }
            materialPath {
                moveTo(5.49f, 13.77f)
                curveToRelative(0.59f, 0.59f, 1.54f, 0.59f, 2.12f, 0.0f)
                lineToRelative(2.47f, -2.47f)
                lineTo(7.96f, 9.17f)
                lineToRelative(-2.47f, 2.47f)
                curveTo(4.9f, 12.23f, 4.9f, 13.18f, 5.49f, 13.77f)
                lineTo(5.49f, 13.77f)
                close()
            }
            materialPath {
                moveTo(14.33f, 8.46f)
                lineToRelative(-0.71f, 0.71f)
                lineToRelative(-3.18f, -3.18f)
                curveTo(9.85f, 5.4f, 8.9f, 5.4f, 8.32f, 5.99f)
                curveToRelative(-0.59f, 0.59f, -0.59f, 1.54f, 0.0f, 2.12f)
                lineToRelative(3.18f, 3.18f)
                lineToRelative(-7.0f, 7.0f)
                curveToRelative(-0.7f, 0.7f, -0.88f, 1.84f, -0.29f, 2.65f)
                curveToRelative(0.74f, 1.03f, 2.19f, 1.12f, 3.05f, 0.26f)
                lineTo(16.45f, 12.0f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(-2.12f, -2.12f)
                curveTo(15.35f, 8.07f, 14.72f, 8.07f, 14.33f, 8.46f)
                close()
            }
        }
        return _plumbing!!
    }

private var _plumbing: ImageVector? = null
