/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.NightShelter: ImageVector
    get() {
        if (_nightShelter != null) {
            return _nightShelter!!
        }
        _nightShelter = materialIcon(name = "Rounded.NightShelter") {
            materialPath {
                moveTo(10.8f, 3.9f)
                lineToRelative(-6.0f, 4.5f)
                curveTo(4.3f, 8.78f, 4.0f, 9.37f, 4.0f, 10.0f)
                verticalLineToRelative(9.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(12.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-9.0f)
                curveToRelative(0.0f, -0.63f, -0.3f, -1.22f, -0.8f, -1.6f)
                lineToRelative(-6.0f, -4.5f)
                curveTo(12.49f, 3.37f, 11.51f, 3.37f, 10.8f, 3.9f)
                close()
                moveTo(9.75f, 12.5f)
                curveToRelative(0.69f, 0.0f, 1.25f, 0.56f, 1.25f, 1.25f)
                reflectiveCurveTo(10.44f, 15.0f, 9.75f, 15.0f)
                reflectiveCurveTo(8.5f, 14.44f, 8.5f, 13.75f)
                reflectiveCurveTo(9.06f, 12.5f, 9.75f, 12.5f)
                close()
                moveTo(16.5f, 18.0f)
                lineTo(16.5f, 18.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(1.0f)
                curveTo(8.0f, 17.78f, 7.78f, 18.0f, 7.5f, 18.0f)
                horizontalLineToRelative(0.0f)
                curveTo(7.22f, 18.0f, 7.0f, 17.78f, 7.0f, 17.5f)
                verticalLineToRelative(-6.0f)
                curveTo(7.0f, 11.22f, 7.22f, 11.0f, 7.5f, 11.0f)
                horizontalLineToRelative(0.0f)
                curveTo(7.78f, 11.0f, 8.0f, 11.22f, 8.0f, 11.5f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(3.5f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                horizontalLineToRelative(3.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(3.5f)
                curveTo(17.0f, 17.78f, 16.78f, 18.0f, 16.5f, 18.0f)
                close()
            }
        }
        return _nightShelter!!
    }

private var _nightShelter: ImageVector? = null
