/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.DirectionsBoat: ImageVector
    get() {
        if (_directionsBoat != null) {
            return _directionsBoat!!
        }
        _directionsBoat = materialIcon(name = "Rounded.DirectionsBoat") {
            materialPath {
                moveTo(20.0f, 21.0f)
                curveToRelative(-1.19f, 0.0f, -2.38f, -0.35f, -3.47f, -0.98f)
                curveToRelative(-0.33f, -0.19f, -0.73f, -0.19f, -1.07f, 0.0f)
                curveToRelative(-2.17f, 1.26f, -4.76f, 1.26f, -6.93f, 0.0f)
                curveToRelative(-0.33f, -0.19f, -0.73f, -0.19f, -1.07f, 0.0f)
                curveTo(6.38f, 20.65f, 5.19f, 21.0f, 4.0f, 21.0f)
                horizontalLineTo(3.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(1.38f, 0.0f, 2.74f, -0.35f, 4.0f, -0.99f)
                curveToRelative(2.52f, 1.29f, 5.48f, 1.29f, 8.0f, 0.0f)
                curveToRelative(1.26f, 0.65f, 2.62f, 0.99f, 4.0f, 0.99f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(20.0f)
                close()
                moveTo(3.95f, 19.0f)
                horizontalLineTo(4.0f)
                curveToRelative(1.27f, 0.0f, 2.42f, -0.55f, 3.33f, -1.33f)
                curveToRelative(0.39f, -0.34f, 0.95f, -0.34f, 1.34f, 0.0f)
                curveTo(9.58f, 18.45f, 10.73f, 19.0f, 12.0f, 19.0f)
                reflectiveCurveToRelative(2.42f, -0.55f, 3.33f, -1.33f)
                curveToRelative(0.39f, -0.34f, 0.95f, -0.34f, 1.34f, 0.0f)
                curveTo(17.58f, 18.45f, 18.73f, 19.0f, 20.0f, 19.0f)
                horizontalLineToRelative(0.05f)
                lineToRelative(1.9f, -6.68f)
                curveToRelative(0.11f, -0.37f, 0.04f, -1.06f, -0.66f, -1.28f)
                lineTo(20.0f, 10.62f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineTo(2.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-4.0f)
                curveTo(9.45f, 1.0f, 9.0f, 1.45f, 9.0f, 2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(6.0f)
                curveTo(4.9f, 4.0f, 4.0f, 4.9f, 4.0f, 6.0f)
                verticalLineToRelative(4.62f)
                lineToRelative(-1.29f, 0.42f)
                curveToRelative(-0.63f, 0.19f, -0.81f, 0.84f, -0.66f, 1.28f)
                lineTo(3.95f, 19.0f)
                close()
                moveTo(6.0f, 6.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(3.97f)
                lineTo(12.62f, 8.2f)
                curveToRelative(-0.41f, -0.13f, -0.84f, -0.13f, -1.25f, 0.0f)
                lineTo(6.0f, 9.97f)
                verticalLineTo(6.0f)
                close()
            }
        }
        return _directionsBoat!!
    }

private var _directionsBoat: ImageVector? = null
