/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AppSettingsAlt: ImageVector
    get() {
        if (_appSettingsAlt != null) {
            return _appSettingsAlt!!
        }
        _appSettingsAlt = materialIcon(name = "Rounded.AppSettingsAlt") {
            materialPath {
                moveTo(17.0f, 18.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(3.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                lineTo(7.0f, 1.01f)
                curveTo(5.9f, 1.01f, 5.0f, 1.9f, 5.0f, 3.0f)
                verticalLineToRelative(18.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(18.0f)
                close()
                moveTo(21.0f, 12.0f)
                curveToRelative(0.0f, -0.13f, -0.02f, -0.26f, -0.04f, -0.39f)
                lineToRelative(0.64f, -0.48f)
                curveToRelative(0.2f, -0.15f, 0.26f, -0.44f, 0.13f, -0.66f)
                lineToRelative(-0.57f, -0.96f)
                curveToRelative(-0.13f, -0.21f, -0.39f, -0.3f, -0.62f, -0.2f)
                lineToRelative(-0.72f, 0.3f)
                curveToRelative(-0.2f, -0.15f, -0.42f, -0.29f, -0.65f, -0.39f)
                lineToRelative(-0.1f, -0.77f)
                curveToRelative(-0.03f, -0.25f, -0.24f, -0.43f, -0.49f, -0.44f)
                lineToRelative(-1.12f, -0.02f)
                curveToRelative(-0.26f, 0.0f, -0.47f, 0.18f, -0.5f, 0.44f)
                lineToRelative(-0.1f, 0.79f)
                curveToRelative(-0.24f, 0.1f, -0.45f, 0.23f, -0.65f, 0.39f)
                lineToRelative(-0.72f, -0.3f)
                curveToRelative(-0.23f, -0.1f, -0.5f, -0.01f, -0.62f, 0.2f)
                lineToRelative(-0.57f, 0.96f)
                curveToRelative(-0.13f, 0.22f, -0.08f, 0.5f, 0.13f, 0.66f)
                lineToRelative(0.64f, 0.48f)
                curveTo(15.02f, 11.74f, 15.0f, 11.87f, 15.0f, 12.0f)
                curveToRelative(0.0f, 0.13f, 0.02f, 0.25f, 0.04f, 0.37f)
                lineToRelative(-0.64f, 0.49f)
                curveToRelative(-0.2f, 0.15f, -0.26f, 0.43f, -0.13f, 0.65f)
                lineToRelative(0.56f, 0.97f)
                curveToRelative(0.13f, 0.22f, 0.39f, 0.31f, 0.63f, 0.21f)
                lineToRelative(0.73f, -0.31f)
                curveToRelative(0.2f, 0.16f, 0.42f, 0.3f, 0.67f, 0.4f)
                lineToRelative(0.1f, 0.77f)
                curveToRelative(0.03f, 0.25f, 0.24f, 0.44f, 0.5f, 0.44f)
                horizontalLineToRelative(1.12f)
                curveToRelative(0.25f, 0.0f, 0.46f, -0.19f, 0.5f, -0.44f)
                lineToRelative(0.1f, -0.77f)
                curveToRelative(0.24f, -0.1f, 0.46f, -0.24f, 0.67f, -0.4f)
                lineToRelative(0.73f, 0.31f)
                curveToRelative(0.23f, 0.1f, 0.5f, 0.01f, 0.63f, -0.21f)
                lineToRelative(0.56f, -0.97f)
                curveToRelative(0.13f, -0.22f, 0.07f, -0.5f, -0.13f, -0.65f)
                lineToRelative(-0.64f, -0.49f)
                curveTo(20.98f, 12.25f, 21.0f, 12.13f, 21.0f, 12.0f)
                close()
                moveTo(18.0f, 13.5f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                reflectiveCurveToRelative(0.67f, -1.5f, 1.5f, -1.5f)
                reflectiveCurveToRelative(1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveTo(18.83f, 13.5f, 18.0f, 13.5f)
                close()
            }
        }
        return _appSettingsAlt!!
    }

private var _appSettingsAlt: ImageVector? = null
