/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.DeveloperBoardOff: ImageVector
    get() {
        if (_developerBoardOff != null) {
            return _developerBoardOff!!
        }
        _developerBoardOff = materialIcon(name = "Outlined.DeveloperBoardOff") {
            materialPath {
                moveTo(7.83f, 5.0f)
                horizontalLineTo(18.0f)
                verticalLineToRelative(10.17f)
                lineTo(19.83f, 17.0f)
                horizontalLineTo(22.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(5.83f)
                lineTo(7.83f, 5.0f)
                close()
                moveTo(12.0f, 9.17f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-3.17f)
                lineTo(12.0f, 9.17f)
                close()
                moveTo(9.83f, 7.0f)
                horizontalLineTo(11.0f)
                verticalLineToRelative(1.17f)
                lineTo(9.83f, 7.0f)
                close()
                moveTo(13.83f, 11.0f)
                horizontalLineTo(16.0f)
                verticalLineToRelative(2.17f)
                lineTo(13.83f, 11.0f)
                close()
                moveTo(18.0f, 21.0f)
                curveToRelative(0.06f, 0.0f, 0.11f, 0.0f, 0.16f, -0.01f)
                lineToRelative(2.32f, 2.32f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.1f, 2.1f)
                lineTo(0.69f, 3.51f)
                lineToRelative(1.32f, 1.32f)
                curveTo(2.0f, 4.89f, 2.0f, 4.94f, 2.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineTo(18.0f)
                close()
                moveTo(4.0f, 19.0f)
                verticalLineTo(6.83f)
                lineToRelative(2.0f, 2.0f)
                verticalLineTo(12.0f)
                horizontalLineToRelative(3.17f)
                lineToRelative(1.0f, 1.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(-3.17f)
                lineToRelative(1.0f, 1.0f)
                verticalLineTo(17.0f)
                horizontalLineToRelative(2.17f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(4.0f)
                close()
            }
        }
        return _developerBoardOff!!
    }

private var _developerBoardOff: ImageVector? = null
