/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.CheckBox: ImageVector
    get() {
        if (_checkBox != null) {
            return _checkBox!!
        }
        _checkBox = materialIcon(name = "TwoTone.CheckBox") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(5.0f, 19.0f)
                horizontalLineToRelative(14.0f)
                lineTo(19.0f, 5.0f)
                lineTo(5.0f, 5.0f)
                verticalLineToRelative(14.0f)
                close()
                moveTo(7.41f, 11.6f)
                lineToRelative(2.58f, 2.58f)
                lineToRelative(6.59f, -6.59f)
                lineTo(17.99f, 9.0f)
                lineToRelative(-8.0f, 8.0f)
                lineTo(6.0f, 13.01f)
                lineToRelative(1.41f, -1.41f)
                close()
            }
            materialPath {
                moveTo(19.0f, 3.0f)
                lineTo(5.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(21.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(19.0f, 19.0f)
                lineTo(5.0f, 19.0f)
                lineTo(5.0f, 5.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(14.0f)
                close()
                moveTo(17.99f, 9.0f)
                lineToRelative(-1.41f, -1.42f)
                lineToRelative(-6.59f, 6.59f)
                lineToRelative(-2.58f, -2.57f)
                lineToRelative(-1.42f, 1.41f)
                lineToRelative(4.0f, 3.99f)
                close()
            }
        }
        return _checkBox!!
    }

private var _checkBox: ImageVector? = null
