/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.WbIridescent: ImageVector
    get() {
        if (_wbIridescent != null) {
            return _wbIridescent!!
        }
        _wbIridescent = materialIcon(name = "Sharp.WbIridescent") {
            materialPath {
                moveTo(5.0f, 15.0f)
                horizontalLineToRelative(14.0f)
                lineTo(19.0f, 9.05f)
                lineTo(5.0f, 9.05f)
                lineTo(5.0f, 15.0f)
                close()
                moveTo(11.0f, 1.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(2.0f)
                lineTo(13.0f, 1.0f)
                horizontalLineToRelative(-2.0f)
                close()
                moveTo(19.04f, 3.6f)
                lineToRelative(-1.79f, 1.79f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(1.8f, -1.79f)
                lineToRelative(-1.42f, -1.41f)
                close()
                moveTo(13.0f, 23.0f)
                verticalLineToRelative(-2.95f)
                horizontalLineToRelative(-2.0f)
                lineTo(11.0f, 23.0f)
                horizontalLineToRelative(2.0f)
                close()
                moveTo(20.45f, 19.09f)
                lineToRelative(-1.8f, -1.79f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(1.79f, 1.8f)
                lineToRelative(1.42f, -1.42f)
                close()
                moveTo(3.55f, 5.01f)
                lineTo(5.34f, 6.8f)
                lineToRelative(1.41f, -1.41f)
                lineTo(4.96f, 3.6f)
                lineTo(3.55f, 5.01f)
                close()
                moveTo(4.96f, 20.5f)
                lineToRelative(1.79f, -1.8f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(-1.79f, 1.79f)
                lineToRelative(1.41f, 1.42f)
                close()
            }
        }
        return _wbIridescent!!
    }

private var _wbIridescent: ImageVector? = null
